/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofObject;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectType;
import org.graalvm.visualvm.lib.jfluid.heap.Type;

class HprofField
extends HprofObject
implements Field {
    ClassDump classDump;

    HprofField(ClassDump cls, long offset) {
        super(offset);
        this.classDump = cls;
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.classDump;
    }

    @Override
    public String getName() {
        long nameID = this.classDump.getHprofBuffer().getID(this.fileOffset);
        return this.classDump.getHprof().getStringSegment().getStringByID(nameID);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public Type getType() {
        return ObjectType.getType(this.getValueType());
    }

    int getValueSize() {
        return this.classDump.getHprof().getValueSize(this.getValueType());
    }

    byte getValueType() {
        HprofByteBuffer buffer = this.classDump.getHprofBuffer();
        return buffer.get(this.fileOffset + (long)buffer.getIDSize());
    }
}

