/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Stateful;
import org.graalvm.visualvm.core.explorer.ExplorerNode;
import org.graalvm.visualvm.uisupport.UISupport;

class ExplorerNodeRenderer
extends DefaultTreeCellRenderer {
    ExplorerNodeRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ExplorerNode dsn = (ExplorerNode)value;
        JLabel rl = (JLabel)renderer;
        rl.setText(dsn.getName());
        rl.setIcon(dsn.getIcon());
        DataSource ds = dsn.getUserObject();
        if (ds instanceof Stateful) {
            rl.setEnabled(((Stateful)((Object)ds)).getState() == 1);
        } else {
            rl.setEnabled(true);
        }
        if (UISupport.isGTKLookAndFeel() || UISupport.isNimbusLookAndFeel()) {
            if (renderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)renderer;
                dtcr.setBackgroundSelectionColor(null);
                dtcr.setBorderSelectionColor(null);
            }
        } else if (UISupport.isAquaLookAndFeel()) {
            if (!sel) {
                rl.setOpaque(true);
                rl.setBackground(tree.getBackground());
            } else {
                rl.setOpaque(false);
            }
        }
        return renderer;
    }
}

