/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

public class FlatEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final Color background = UIManager.getColor("EditorTab.background");
    private static final Color activeBackground = Utils.getUIColor("EditorTab.activeBackground", background);
    private static final Color selectedBackground = Utils.getUIColor("EditorTab.selectedBackground", activeBackground);
    private static final Color selectedBackgroundBottomGradient = Utils.getUIColor("EditorTab.selectedBackgroundBottomGradient", selectedBackground);
    private static final Color hoverBackground = UIManager.getColor("EditorTab.hoverBackground");
    private static final Color selectedHoverBackground = Utils.getUIColor("EditorTab.selectedHoverBackground", hoverBackground);
    private static final Color attentionBackground = UIManager.getColor("EditorTab.attentionBackground");
    private static final Color foreground = Utils.getUIColor("EditorTab.foreground", "TabbedPane.foreground");
    private static final Color activeForeground = Utils.getUIColor("EditorTab.activeForeground", foreground);
    private static final Color selectedForeground = Utils.getUIColor("EditorTab.selectedForeground", activeForeground);
    private static final Color hoverForeground = Utils.getUIColor("EditorTab.hoverForeground", foreground);
    private static final Color selectedHoverForeground = Utils.getUIColor("EditorTab.selectedHoverForeground", hoverForeground);
    private static final Color attentionForeground = Utils.getUIColor("EditorTab.attentionForeground", foreground);
    private static final Color underlineColor = UIManager.getColor("EditorTab.underlineColor");
    private static final Color inactiveUnderlineColor = UIManager.getColor("EditorTab.inactiveUnderlineColor");
    private static final Color tabSeparatorColor = UIManager.getColor("EditorTab.tabSeparatorColor");
    private static final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private static final Insets tabInsets = UIScale.scale((Insets)UIManager.getInsets("EditorTab.tabInsets"));
    private static final int underlineHeight = UIScale.scale((int)UIManager.getInt("EditorTab.underlineHeight"));
    private static final boolean underlineAtTop = UIManager.getBoolean("EditorTab.underlineAtTop");
    private static boolean showTabSeparators = UIManager.getBoolean("EditorTab.showTabSeparators");
    private static final int CLOSE_ICON_RIGHT_PAD = FlatEditorTabCellRenderer.tabInsets.left - 2;
    private static final boolean showSelectedTabBorder = Utils.getUIBoolean("EditorTab.showSelectedTabBorder", underlineAtTop);
    private static final boolean unscaledBorders = Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private static final FlatTabPainter leftClipPainter = new FlatTabPainter(true, false);
    private static final FlatTabPainter noClipPainter = new FlatTabPainter(false, false);
    private static final FlatTabPainter rightClipPainter = new FlatTabPainter(false, true);
    boolean firstTab;
    boolean lastTab;
    boolean nextTabSelected;

    public FlatEditorTabCellRenderer() {
        super((TabPainter)leftClipPainter, (TabPainter)noClipPainter, (TabPainter)rightClipPainter, new Dimension(FlatEditorTabCellRenderer.tabInsets.left + FlatEditorTabCellRenderer.tabInsets.right, FlatEditorTabCellRenderer.tabInsets.top + FlatEditorTabCellRenderer.tabInsets.bottom));
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        if (this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton")) {
            dimension.width += this.findCloseIcon().getIconWidth() + UIScale.scale((int)CLOSE_ICON_RIGHT_PAD);
        }
        return dimension;
    }

    protected int getCaptionYPosition(Graphics graphics) {
        Font font = this.getFont();
        FontRenderContext fontRenderContext = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getFontRenderContext() : graphics.getFontMetrics(font).getFontRenderContext();
        double d = font.createGlyphVector(fontRenderContext, "H").getVisualBounds().getHeight();
        Insets insets = this.getInsets();
        int n = this.getHeight() - (insets.top + insets.bottom);
        int n2 = 2 + this.getIconYAdjustment();
        return insets.top + (int)Math.round(((double)n + d) / 2.0) + n2;
    }

    protected int stateChanged(int n, int n2) {
        int n3 = super.stateChanged(n, n2);
        this.setForeground(this.colorForState(foreground, activeForeground, selectedForeground, selectedHoverForeground, hoverForeground, attentionForeground));
        return n3;
    }

    private Color colorForState(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        return this.isAttention() ? color6 : (this.isArmed() ? (this.isSelected() ? color4 : color5) : (this.isSelected() ? color3 : (this.isActive() ? color2 : color)));
    }

    private Icon findCloseIcon() {
        return FlatTabControlIcon.get(1, this.inCloseButton() ? (this.isPressed() ? 1 : 3) : 0);
    }

    private static class FlatTabPainter
    implements TabPainter {
        final boolean leftClip;
        final boolean rightClip;

        public FlatTabPainter(boolean bl, boolean bl2) {
            this.leftClip = bl;
            this.rightClip = bl2;
        }

        public Insets getBorderInsets(Component component) {
            return tabInsets;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            FlatEditorTabCellRenderer flatEditorTabCellRenderer = (FlatEditorTabCellRenderer)((Object)jComponent);
            if (!flatEditorTabCellRenderer.isShowCloseButton() || this.leftClip || this.rightClip) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            Icon icon = flatEditorTabCellRenderer.findCloseIcon();
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            rectangle.x = rectangle2.x + rectangle2.width - n - UIScale.scale((int)CLOSE_ICON_RIGHT_PAD);
            int n3 = 2;
            rectangle.y = rectangle2.y + Math.max(0, (rectangle2.height - n2) / 2) - 1 + n3;
            rectangle.width = n;
            rectangle.height = n2;
        }

        public Polygon getInteriorPolygon(Component component) {
            int n = 0;
            int n2 = 0;
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public void paintInterior(Graphics graphics, Component component) {
            HiDPIUtils.paintAtScale1x(graphics, 0, 0, component.getWidth(), component.getHeight(), (graphics2D, n, n2, d) -> this.paintInteriorAtScale1x(graphics2D, component, n, n2, d));
            FlatEditorTabCellRenderer flatEditorTabCellRenderer = (FlatEditorTabCellRenderer)((Object)component);
            if (!flatEditorTabCellRenderer.isClipLeft() && !flatEditorTabCellRenderer.isClipRight()) {
                this.paintCloseButton(graphics, flatEditorTabCellRenderer);
            }
        }

        private static void fillGradientRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
            if (color2.equals(color)) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, n2 + n5, color, 0.0f, n2 + n4 - n5, color2, false));
            }
            graphics2D.fillRect(n, n2, n3, n4);
        }

        private void paintInteriorAtScale1x(Graphics2D graphics2D, Component component, int n, int n2, double d) {
            FlatEditorTabCellRenderer flatEditorTabCellRenderer = (FlatEditorTabCellRenderer)((Object)component);
            boolean bl = flatEditorTabCellRenderer.isSelected();
            Color color = flatEditorTabCellRenderer.colorForState(background, activeBackground, selectedBackground, selectedHoverBackground, hoverBackground, attentionBackground);
            boolean bl2 = showTabSeparators && !bl && !flatEditorTabCellRenderer.nextTabSelected && !flatEditorTabCellRenderer.lastTab && !this.rightClip;
            int n3 = unscaledBorders ? 1 : HiDPIUtils.deviceBorderWidth(d, 1);
            int n4 = bl2 ? n3 : 0;
            int n5 = (int)Math.round((double)underlineHeight * d);
            FlatTabPainter.fillGradientRect(graphics2D, 0, 0, n - (color != background ? n4 : 0), n2, color, bl && !selectedBackground.equals(selectedBackgroundBottomGradient) ? selectedBackgroundBottomGradient : color, underlineAtTop ? n5 : 0);
            if (bl) {
                if (showSelectedTabBorder) {
                    graphics2D.setColor(contentBorderColor);
                    graphics2D.fillRect(0, 0, n - n4, n3);
                    if (!this.leftClip) {
                        graphics2D.fillRect(0, 0, n3, n2);
                    }
                    if (!this.rightClip) {
                        graphics2D.fillRect(n - n4 - n3, 0, n3, n2);
                    }
                }
                if (n5 > 0) {
                    graphics2D.setColor(flatEditorTabCellRenderer.isActive() ? underlineColor : inactiveUnderlineColor);
                    if (underlineAtTop) {
                        graphics2D.fillRect(0, 0, n - n4, n5);
                    } else {
                        graphics2D.fillRect(0, n2 - n5, n - n4, n5);
                    }
                }
            } else {
                graphics2D.setColor(contentBorderColor);
                graphics2D.fillRect(0, n2 - n3, n, n3);
            }
            if (bl2) {
                int n6 = (int)(4.0 * d);
                graphics2D.setColor(tabSeparatorColor);
                graphics2D.fillRect(n - n4, n6, n4, n2 - n6 * 2 - 1);
            }
        }

        private void paintCloseButton(Graphics graphics, FlatEditorTabCellRenderer flatEditorTabCellRenderer) {
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)flatEditorTabCellRenderer), rectangle, new Rectangle(0, 0, flatEditorTabCellRenderer.getWidth(), flatEditorTabCellRenderer.getHeight()));
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            Icon icon = flatEditorTabCellRenderer.findCloseIcon();
            icon.paintIcon((Component)((Object)flatEditorTabCellRenderer), graphics, rectangle.x, rectangle.y);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return jComponent instanceof TabDisplayer ? ((TabDisplayer)jComponent).isShowCloseButton() : true;
        }
    }
}

