/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class CloseModeAction
extends AbstractAction
implements PropertyChangeListener {
    private ModeImpl mode;

    public CloseModeAction() {
        this.putValue("Name", NbBundle.getMessage(CloseModeAction.class, (String)"CTL_CloseModeAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseModeAction.this.updateEnabled();
                }
            });
        }
    }

    public CloseModeAction(ModeImpl modeImpl) {
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"CTL_CloseModeAction"));
        this.mode = modeImpl;
        if (modeImpl.getKind() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(Switches.isModeClosingEnabled());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent;
        ModeImpl modeImpl = this.mode;
        if (modeImpl == null && null != (topComponent = TopComponent.getRegistry().getActivated())) {
            modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        }
        if (modeImpl != null) {
            WindowManagerImpl.getInstance().userClosedMode(modeImpl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent) {
            this.setEnabled(false);
            return;
        }
        if (WindowManagerImpl.getInstance().isEditorTopComponent(topComponent)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(Switches.isModeClosingEnabled());
        }
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseMode", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseMode");
        }
        return super.getValue(string);
    }
}

