/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.results.ColoredFilter;
import org.graalvm.visualvm.lib.ui.results.PackageColorer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.SmallButton;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.modules.appui.options.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;

final class FiltersOptionsPanel
extends JPanel {
    private final List<ColoredFilter> colors = new ArrayList<ColoredFilter>();
    private final ColorsTableModel colorsModel = new ColorsTableModel();
    private JCheckBox coloringChoice;

    FiltersOptionsPanel() {
        this.initUI();
    }

    public String getDisplayName() {
        return Bundle.FiltersOptionsPanel_Name();
    }

    public void storeTo(ProfilerIDESettings settings) {
        settings.setSourcesColoringEnabled(this.coloringChoice.isSelected());
        PackageColorer.setRegisteredColors(this.colors);
        for (Window w : Window.getWindows()) {
            w.repaint();
        }
    }

    public void loadFrom(ProfilerIDESettings settings) {
        this.coloringChoice.setSelected(settings.isSourcesColoringEnabled());
        this.colors.clear();
        this.colors.addAll(PackageColorer.getRegisteredColors());
        this.colorsModel.fireTableDataChanged();
    }

    public boolean equalsTo(ProfilerIDESettings settings) {
        if (this.coloringChoice.isSelected() != settings.isSourcesColoringEnabled()) {
            return false;
        }
        return Objects.equals(PackageColorer.getRegisteredColors(), this.colors);
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        int htab = 15;
        int vgap = 5;
        SectionSeparator filtersSection = UISupport.createSectionSeparator((String)Bundle.FiltersOptionsPanel_Name());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 7, 0);
        this.add((Component)filtersSection, c);
        this.coloringChoice = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.coloringChoice, (String)Bundle.FiltersOptionsPanel_ColoringResults());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap * 3, 0);
        this.add((Component)this.coloringChoice, c);
        JLabel tableCaption = new JLabel();
        Mnemonics.setLocalizedText((JLabel)tableCaption, (String)Bundle.FiltersOptionsPanel_DefinedFilters());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)tableCaption, c);
        String colorString = "ABCabc123";
        final ProfilerTable colorsTable = new ProfilerTable((TableModel)this.colorsModel, false, false, null);
        colorsTable.setMainColumn(1);
        colorsTable.setFitWidthColumn(1);
        LabelRenderer stringRenderer = new LabelRenderer();
        colorsTable.setColumnRenderer(0, (ProfilerRenderer)stringRenderer);
        colorsTable.setColumnRenderer(1, (ProfilerRenderer)stringRenderer);
        LabelRenderer colorRenderer = new LabelRenderer(){
            private final Color _fg = new JTable().getForeground();
            private Color fg;
            {
                this.setText("ABCabc123");
                this.setHorizontalAlignment(11);
            }

            public void setValue(Object value, int row) {
                this.fg = (Color)value;
            }

            public void setForeground(Color color) {
                if (this.fg != null && Objects.equals(color, this._fg)) {
                    super.setForeground(this.fg);
                } else {
                    super.setForeground(color);
                }
            }
        };
        colorsTable.setColumnRenderer(2, (ProfilerRenderer)colorRenderer);
        stringRenderer.setValue((Object)"PLACEHOLDER FILTER NAME", -1);
        colorsTable.setDefaultColumnWidth(0, stringRenderer.getPreferredSize().width);
        stringRenderer.setValue((Object)"ABCabc123", -1);
        colorsTable.setDefaultColumnWidth(2, stringRenderer.getPreferredSize().width + 10);
        ProfilerTableContainer colorsContainer = new ProfilerTableContainer(colorsTable, true, null);
        colorsContainer.setPreferredSize(new Dimension(1, 1));
        tableCaption.setLabelFor((Component)colorsTable);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)colorsContainer, c);
        SmallButton addButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Add")){
            {
                this.setToolTipText(Bundle.FiltersOptionsPanel_AddFilter());
            }

            protected void fireActionPerformed(ActionEvent e) {
                ColoredFilter newColor = ColorCustomizer.customize(new ColoredFilter("", "", null), true);
                if (newColor != null) {
                    FiltersOptionsPanel.this.colors.add(newColor);
                    FiltersOptionsPanel.this.colorsModel.fireTableDataChanged();
                }
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)addButton, c);
        final Runnable editPerformer = new Runnable(){

            @Override
            public void run() {
                int row = colorsTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                ColoredFilter selected = (ColoredFilter)FiltersOptionsPanel.this.colors.get(row);
                ColoredFilter edited = ColorCustomizer.customize(selected, false);
                if (edited != null) {
                    selected.setName(edited.getName());
                    selected.setValue(edited.getValue());
                    selected.setColor(edited.getColor());
                    FiltersOptionsPanel.this.colorsModel.fireTableDataChanged();
                }
            }
        };
        SmallButton editButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Edit")){
            {
                super(x0);
                this.setToolTipText(Bundle.FiltersOptionsPanel_EditFilter());
            }

            protected void fireActionPerformed(ActionEvent e) {
                editPerformer.run();
            }
        };
        colorsTable.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editPerformer.run();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)editButton, c);
        SmallButton removeButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Remove")){
            {
                super(x0);
                this.setToolTipText(Bundle.FiltersOptionsPanel_DeleteFilter());
            }

            protected void fireActionPerformed(ActionEvent e) {
                int row = colorsTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                FiltersOptionsPanel.this.colors.remove(row);
                FiltersOptionsPanel.this.colorsModel.fireTableDataChanged();
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, vgap * 2, 0);
        this.add((Component)removeButton, c);
        SmallButton upButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Up")){
            {
                super(x0);
                this.setToolTipText(Bundle.FiltersOptionsPanel_MoveUp());
            }

            protected void fireActionPerformed(ActionEvent e) {
                int row = colorsTable.getSelectedRow();
                if (row < 1) {
                    return;
                }
                ColoredFilter color = (ColoredFilter)FiltersOptionsPanel.this.colors.remove(row);
                FiltersOptionsPanel.this.colors.add(row - 1, color);
                FiltersOptionsPanel.this.colorsModel.fireTableDataChanged();
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)upButton, c);
        SmallButton downButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Down")){
            {
                super(x0);
                this.setToolTipText(Bundle.FiltersOptionsPanel_MoveDown());
            }

            protected void fireActionPerformed(ActionEvent e) {
                int row = colorsTable.getSelectedRow();
                if (row == -1 || row > colorsTable.getRowCount() - 2) {
                    return;
                }
                ColoredFilter color = (ColoredFilter)FiltersOptionsPanel.this.colors.remove(row);
                FiltersOptionsPanel.this.colors.add(row + 1, color);
                FiltersOptionsPanel.this.colorsModel.fireTableDataChanged();
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)downButton, c);
        ListSelectionListener selection = new ListSelectionListener((JButton)editButton, (JButton)removeButton, (JButton)upButton, (JButton)downButton){
            final /* synthetic */ JButton val$editButton;
            final /* synthetic */ JButton val$removeButton;
            final /* synthetic */ JButton val$upButton;
            final /* synthetic */ JButton val$downButton;
            {
                this.val$editButton = jButton;
                this.val$removeButton = jButton2;
                this.val$upButton = jButton3;
                this.val$downButton = jButton4;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = colorsTable.getSelectedRow();
                if (row == -1) {
                    this.val$editButton.setEnabled(false);
                    this.val$removeButton.setEnabled(false);
                    this.val$upButton.setEnabled(false);
                    this.val$downButton.setEnabled(false);
                } else {
                    this.val$editButton.setEnabled(true);
                    this.val$removeButton.setEnabled(true);
                    this.val$upButton.setEnabled(row > 0);
                    this.val$downButton.setEnabled(row < colorsTable.getRowCount() - 1);
                }
            }
        };
        colorsTable.getSelectionModel().addListSelectionListener(selection);
        selection.valueChanged(null);
    }

    private static class ColorCustomizer {
        private ColorCustomizer() {
        }

        static ColoredFilter customize(ColoredFilter color, boolean newFilter) {
            final ColoredFilter customized = new ColoredFilter(color);
            JTextField nameF = new JTextField(customized.getName());
            JTextArea valueA = new JTextArea(customized.getValue());
            valueA.setRows(8);
            valueA.setColumns(45);
            valueA.setLineWrap(true);
            valueA.setWrapStyleWord(true);
            final JButton colorB = new JButton(){
                {
                    this.setIcon(customized.getIcon(16, 12));
                    this.setToolTipText("");
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    Color c = ColorCustomizer.selectColor(this, customized.getColor());
                    if (c != null) {
                        customized.setColor(c);
                        this.repaint();
                    }
                }

                @Override
                public String getToolTipText(MouseEvent e) {
                    Color col = customized.getColor();
                    return col == null ? Bundle.ColorCustomizer_DefaultColor() : Bundle.ColorCustomizer_CustomColor(col.getRed(), col.getGreen(), col.getBlue());
                }
            };
            JPanel p = new JPanel(new GridBagLayout());
            int hgap = 10;
            int htab = 5;
            int vgap = 5;
            int y = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.insets = new Insets(vgap * 2, hgap, 0, 0);
            p.add((Component)new JLabel(Bundle.ColorCustomizer_Name()), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(vgap * 2, htab, 0, 0);
            p.add((Component)nameF, c);
            JCheckBox colorC = new JCheckBox(Bundle.ColorCustomizer_Color(), customized.getColor() != null){
                private Color bkpC;

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    if (this.isSelected()) {
                        customized.setColor(this.bkpC);
                        colorB.setEnabled(true);
                    } else {
                        this.bkpC = customized.getColor();
                        customized.setColor(null);
                        colorB.setEnabled(false);
                    }
                }
            };
            colorC.setOpaque(false);
            colorC.setToolTipText(Bundle.ColorCustomizer_ColorHint());
            colorB.setEnabled(colorC.isSelected());
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = y;
            c.insets = new Insets(vgap * 2, hgap * 2, 0, 0);
            p.add((Component)colorC, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = y++;
            c.insets = new Insets(vgap * 2, 2, 0, hgap);
            p.add((Component)colorB, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.anchor = 18;
            c.insets = new Insets(vgap * 2, hgap, 0, 0);
            p.add((Component)new JLabel(Bundle.ColorCustomizer_Value()), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(vgap * 2, htab, vgap, hgap);
            p.add((Component)new JScrollPane(valueA), c);
            String dialogCaption = newFilter ? Bundle.ColorCustomizer_AddCaption() : Bundle.ColorCustomizer_EditCaption();
            DialogDescriptor dd = new DialogDescriptor((Object)p, dialogCaption, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != DialogDescriptor.OK_OPTION) {
                return null;
            }
            customized.setName(nameF.getText().trim());
            customized.setValue(valueA.getText().trim());
            return customized;
        }

        private static Color selectColor(Component comp, Color color) {
            JPanel previewPanel = new JPanel(new BorderLayout());
            previewPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            Object[][] previewData = new String[][]{{"org.mypackage", "100 ms"}, {"org.mypackage.MyClass", "10 ms"}, {"org.mypackage.MyClass.myMethod(boolean, int, String)", "1 ms"}};
            DefaultTableModel previewModel = new DefaultTableModel(previewData, new String[]{"Very long column name", "xxx"});
            ProfilerTable previewTable = new ProfilerTable((TableModel)previewModel, false, false, null);
            final Color initial = color == null ? previewTable.getForeground() : null;
            final JColorChooser pane = new JColorChooser(color == null ? initial : color);
            previewTable.setColumnRenderer(0, (ProfilerRenderer)new JavaNameRenderer(Icons.getIcon((String)"ProfilerIcons.NodeLeaf")){

                protected void setNormalValue(String value) {
                    super.setNormalValue(value);
                    Color color = pane.getColor();
                    if (initial != color) {
                        this.setCustomForeground(color);
                    }
                }
            });
            previewTable.setColumnRenderer(1, (ProfilerRenderer)new LabelRenderer(){
                {
                    this.setHorizontalAlignment(11);
                }
            });
            previewTable.setTableHeader(null);
            previewTable.setVisibleRows(3);
            JScrollPane previewScroll = new JScrollPane((Component)previewTable, 21, 31);
            previewPanel.add((Component)previewScroll, "Center");
            pane.setPreviewPanel(previewPanel);
            class Ret
            implements ActionListener {
                private Color clr;
                final /* synthetic */ JColorChooser val$pane;

                Ret(JColorChooser jColorChooser) {
                    this.val$pane = jColorChooser;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.clr = this.val$pane.getColor();
                }

                Color getColor() {
                    return this.clr;
                }
            }
            Ret ret = new Ret(pane);
            JDialog dialog = JColorChooser.createDialog(comp, Bundle.ColorCustomizer_ColorCaption(), true, pane, ret, null);
            dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Window w = (Window)e.getComponent();
                    w.dispose();
                }
            });
            dialog.setVisible(true);
            return ret.getColor();
        }
    }

    private class ColorsTableModel
    extends AbstractTableModel {
        private ColorsTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Bundle.FiltersOptionsPanel_ColumnFilter();
                }
                case 1: {
                    return Bundle.FiltersOptionsPanel_ColumnPackages();
                }
                case 2: {
                    return Bundle.FiltersOptionsPanel_ColumnColor();
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return FiltersOptionsPanel.this.colors.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int column) {
            switch (column) {
                case 0: {
                    return ((ColoredFilter)FiltersOptionsPanel.this.colors.get(rowIndex)).getName();
                }
                case 1: {
                    return ((ColoredFilter)FiltersOptionsPanel.this.colors.get(rowIndex)).getValue();
                }
                case 2: {
                    return ((ColoredFilter)FiltersOptionsPanel.this.colors.get(rowIndex)).getColor();
                }
            }
            return null;
        }
    }
}

