/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Locale;

public final class ContextName {
    public static final String ROOT_NAME = "ROOT";
    private static final String VERSION_MARKER = "##";
    private static final char FWD_SLASH_REPLACEMENT = '#';
    private final String baseName;
    private final String path;
    private final String version;
    private final String name;

    public ContextName(String string, boolean bl) {
        String string2;
        Object object = string;
        if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        if (((String)(object = ((String)object).replace('/', '#'))).startsWith(VERSION_MARKER) || ((String)object).isEmpty()) {
            object = ROOT_NAME + (String)object;
        }
        if (bl && (((String)object).toLowerCase(Locale.ENGLISH).endsWith(".war") || ((String)object).toLowerCase(Locale.ENGLISH).endsWith(".xml"))) {
            object = ((String)object).substring(0, ((String)object).length() - 4);
        }
        this.baseName = object;
        int n = this.baseName.indexOf(VERSION_MARKER);
        if (n > -1) {
            this.version = this.baseName.substring(n + 2);
            string2 = this.baseName.substring(0, n);
        } else {
            this.version = "";
            string2 = this.baseName;
        }
        this.path = ROOT_NAME.equals(string2) ? "" : "/" + string2.replace('#', '/');
        this.name = n > -1 ? this.path + VERSION_MARKER + this.version : this.path;
    }

    public ContextName(String string, String string2) {
        this.path = string == null || "/".equals(string) || "/ROOT".equals(string) ? "" : string;
        this.version = string2 == null ? "" : string2;
        this.name = this.version.isEmpty() ? this.path : this.path + VERSION_MARKER + this.version;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.path.isEmpty()) {
            stringBuilder.append(ROOT_NAME);
        } else {
            stringBuilder.append(this.path.substring(1).replace('/', '#'));
        }
        if (!this.version.isEmpty()) {
            stringBuilder.append(VERSION_MARKER);
            stringBuilder.append(this.version);
        }
        this.baseName = stringBuilder.toString();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        if ("".equals(this.path)) {
            stringBuilder.append('/');
        } else {
            stringBuilder.append(this.path);
        }
        if (!this.version.isEmpty()) {
            stringBuilder.append(VERSION_MARKER);
            stringBuilder.append(this.version);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ContextName extractFromPath(String string) {
        string = string.replace("\\", "/");
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return new ContextName(string, true);
    }
}

