/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import jakarta.annotation.Resource;
import jakarta.annotation.Resources;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.util.Introspection;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.res.StringManager;

public class WebAnnotationSet {
    private static final String SEPARATOR = "/";
    private static final String MAPPED_NAME_PROPERTY = "mappedName";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");

    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        String[] stringArray;
        for (String string : stringArray = context.findApplicationListeners()) {
            Class<?> clazz = Introspection.loadClass(context, string);
            if (clazz == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        FilterDef[] filterDefArray;
        for (FilterDef filterDef : filterDefArray = context.findFilterDefs()) {
            Class<?> clazz = Introspection.loadClass(context, filterDef.getFilterClass());
            if (clazz == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        Container[] containerArray;
        for (Container container : containerArray = context.findChildren()) {
            ServletSecurity servletSecurity;
            Class<?> clazz;
            Wrapper wrapper;
            if (!(container instanceof Wrapper) || (wrapper = (Wrapper)container).getServletClass() == null || (clazz = Introspection.loadClass(context, wrapper.getServletClass())) == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
            RunAs runAs = clazz.getAnnotation(RunAs.class);
            if (runAs != null) {
                wrapper.setRunAs(runAs.value());
            }
            if ((servletSecurity = clazz.getAnnotation(ServletSecurity.class)) == null) continue;
            context.addServletSecurity(new ApplicationServletRegistration(wrapper, context), new ServletSecurityElement(servletSecurity));
        }
    }

    protected static void loadClassAnnotation(Context context, Class<?> clazz) {
        Resource[] resourceArray;
        Resources resources;
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            WebAnnotationSet.addResource(context, resource);
        }
        if ((resources = clazz.getAnnotation(Resources.class)) != null && resources.value() != null) {
            resourceArray = resources.value();
            int n = resourceArray.length;
            for (int i = 0; i < n; ++i) {
                Resource resource2 = resourceArray[i];
                WebAnnotationSet.addResource(context, resource2);
            }
        }
        if ((resourceArray = clazz.getAnnotation(DeclareRoles.class)) != null && resourceArray.value() != null) {
            for (String string : resourceArray.value()) {
                context.addSecurityRole(string);
            }
        }
    }

    protected static void loadFieldsAnnotation(Context context, Class<?> clazz) {
        Field[] fieldArray = Introspection.getDeclaredFields(clazz);
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                Resource resource = field.getAnnotation(Resource.class);
                if (resource == null) continue;
                String string = clazz.getName() + SEPARATOR + field.getName();
                Class<?> clazz2 = field.getType();
                WebAnnotationSet.addResource(context, resource, string, clazz2);
            }
        }
    }

    protected static void loadMethodsAnnotation(Context context, Class<?> clazz) {
        Method[] methodArray = Introspection.getDeclaredMethods(clazz);
        if (methodArray != null && methodArray.length > 0) {
            for (Method method : methodArray) {
                Resource resource = method.getAnnotation(Resource.class);
                if (resource == null) continue;
                if (!Introspection.isValidSetter(method)) {
                    throw new IllegalArgumentException(sm.getString("webAnnotationSet.invalidInjection"));
                }
                String string = clazz.getName() + SEPARATOR + Introspection.getPropertyName(method);
                Class<?> clazz2 = method.getParameterTypes()[0];
                WebAnnotationSet.addResource(context, resource, string, clazz2);
            }
        }
    }

    protected static void addResource(Context context, Resource resource) {
        WebAnnotationSet.addResource(context, resource, null, null);
    }

    protected static void addResource(Context context, Resource resource, String string, Class<?> clazz) {
        String string2 = WebAnnotationSet.getName(resource, string);
        String string3 = WebAnnotationSet.getType(resource, clazz);
        if (string3.equals("java.lang.String") || string3.equals("java.lang.Character") || string3.equals("java.lang.Integer") || string3.equals("java.lang.Boolean") || string3.equals("java.lang.Double") || string3.equals("java.lang.Byte") || string3.equals("java.lang.Short") || string3.equals("java.lang.Long") || string3.equals("java.lang.Float")) {
            ContextEnvironment contextEnvironment = new ContextEnvironment();
            contextEnvironment.setName(string2);
            contextEnvironment.setType(string3);
            contextEnvironment.setDescription(resource.description());
            contextEnvironment.setProperty(MAPPED_NAME_PROPERTY, (Object)resource.mappedName());
            contextEnvironment.setLookupName(resource.lookup());
            context.getNamingResources().addEnvironment(contextEnvironment);
        } else if (string3.equals("javax.xml.rpc.Service")) {
            ContextService contextService = new ContextService();
            contextService.setName(string2);
            contextService.setWsdlfile(resource.mappedName());
            contextService.setType(string3);
            contextService.setDescription(resource.description());
            contextService.setLookupName(resource.lookup());
            context.getNamingResources().addService(contextService);
        } else if (string3.equals("javax.sql.DataSource") || string3.equals("javax.jms.ConnectionFactory") || string3.equals("javax.jms.QueueConnectionFactory") || string3.equals("javax.jms.TopicConnectionFactory") || string3.equals("jakarta.mail.Session") || string3.equals("java.net.URL") || string3.equals("javax.resource.cci.ConnectionFactory") || string3.equals("org.omg.CORBA_2_3.ORB") || string3.endsWith("ConnectionFactory")) {
            ContextResource contextResource = new ContextResource();
            contextResource.setName(string2);
            contextResource.setType(string3);
            if (resource.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                contextResource.setAuth("Container");
            } else if (resource.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                contextResource.setAuth("Application");
            }
            contextResource.setScope(resource.shareable() ? "Shareable" : "Unshareable");
            contextResource.setProperty(MAPPED_NAME_PROPERTY, (Object)resource.mappedName());
            contextResource.setDescription(resource.description());
            contextResource.setLookupName(resource.lookup());
            context.getNamingResources().addResource(contextResource);
        } else if (string3.equals("javax.jms.Queue") || string3.equals("javax.jms.Topic")) {
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            messageDestinationRef.setName(string2);
            messageDestinationRef.setType(string3);
            messageDestinationRef.setUsage(resource.mappedName());
            messageDestinationRef.setDescription(resource.description());
            messageDestinationRef.setLookupName(resource.lookup());
            context.getNamingResources().addMessageDestinationRef(messageDestinationRef);
        } else {
            ContextResourceEnvRef contextResourceEnvRef = new ContextResourceEnvRef();
            contextResourceEnvRef.setName(string2);
            contextResourceEnvRef.setType(string3);
            contextResourceEnvRef.setProperty(MAPPED_NAME_PROPERTY, (Object)resource.mappedName());
            contextResourceEnvRef.setDescription(resource.description());
            contextResourceEnvRef.setLookupName(resource.lookup());
            context.getNamingResources().addResourceEnvRef(contextResourceEnvRef);
        }
    }

    private static String getType(Resource resource, Class<?> clazz) {
        Class<Object> clazz2 = resource.type();
        if (clazz2 == null || clazz2.equals(Object.class)) {
            clazz2 = clazz != null ? clazz : Object.class;
        }
        return Introspection.convertPrimitiveType(clazz2).getCanonicalName();
    }

    private static String getName(Resource resource, String string) {
        String string2 = resource.name();
        if ((string2 == null || string2.equals("")) && string != null) {
            string2 = string;
        }
        return string2;
    }
}

