/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korio.util;

import com.soywiz.kmem.BitsKt;
import com.soywiz.korio.util.CharExtKt;
import com.soywiz.krypto.encoding.Hex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\f\u0010\t\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\r\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u000e"}, d2={"quoted", "", "getQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "unquoted", "getUnquoted", "escape", "isQuoted", "", "quote", "uescape", "unescape", "unquote", "uquote", "korio"})
public final class StringEscapeKt {
    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        StringBuilder out2 = new StringBuilder();
        int n = 0;
        int n2 = $this$escape.length();
        while (n < n2) {
            int n3;
            char c;
            char c2;
            if ((c2 = (c = $this$escape.charAt(n3 = n++))) == '\\') {
                out2.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                out2.append("\\\"");
                continue;
            }
            if (c2 == '\n') {
                out2.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                out2.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                out2.append("\\t");
                continue;
            }
            boolean bl = '\u0000' <= c2 ? c2 < ' ' : false;
            if (bl) {
                out2.append("\\x");
                out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 4, 4)));
                out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 0, 4)));
                continue;
            }
            out2.append(c);
        }
        String string = out2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "out.toString()");
        return string;
    }

    @NotNull
    public static final String uescape(@NotNull String $this$uescape) {
        StringBuilder out2 = new StringBuilder();
        int n = 0;
        int n2 = $this$uescape.length();
        while (n < n2) {
            int n3;
            char c;
            char c2;
            if ((c2 = (c = $this$uescape.charAt(n3 = n++))) == '\\') {
                out2.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                out2.append("\\\"");
                continue;
            }
            if (c2 == '\n') {
                out2.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                out2.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                out2.append("\\t");
                continue;
            }
            if (CharExtKt.isPrintable(c)) {
                out2.append(c);
                continue;
            }
            out2.append("\\u");
            out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 12, 4)));
            out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 8, 4)));
            out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 4, 4)));
            out2.append(Hex.INSTANCE.encodeCharLower(BitsKt.extract(c, 0, 4)));
        }
        String string = out2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "out.toString()");
        return string;
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        StringBuilder out2 = new StringBuilder();
        int n = 0;
        while (n < $this$unescape.length()) {
            int n2 = n;
            n = n2 + 1;
            char c = $this$unescape.charAt(n2);
            if (c == '\\') {
                int n3 = n;
                n = n3 + 1;
                char c2 = $this$unescape.charAt(n3);
                if ((n3 = (int)c2) == 92) {
                    out2.append('\\');
                    continue;
                }
                if (n3 == 34) {
                    out2.append('\"');
                    continue;
                }
                if (n3 == 110) {
                    out2.append('\n');
                    continue;
                }
                if (n3 == 114) {
                    out2.append('\r');
                    continue;
                }
                if (n3 == 116) {
                    out2.append('\t');
                    continue;
                }
                if (n3 == 117) {
                    String string = $this$unescape;
                    int n4 = n + 4;
                    String string2 = string.substring(n, n4);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String chars = string2;
                    n += 4;
                    string = chars;
                    n4 = 16;
                    out2.append((char)Integer.parseInt(string, CharsKt.checkRadix(n4)));
                    continue;
                }
                out2.append(Intrinsics.stringPlus("\\", Character.valueOf(c2)));
                continue;
            }
            out2.append(c);
        }
        String string = out2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "out.toString()");
        return string;
    }

    @NotNull
    public static final String uquote(@Nullable String $this$uquote) {
        return $this$uquote != null ? '\"' + StringEscapeKt.uescape($this$uquote) + '\"' : "null";
    }

    @NotNull
    public static final String quote(@Nullable String $this$quote) {
        return $this$quote != null ? '\"' + StringEscapeKt.escape($this$quote) + '\"' : "null";
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        return StringsKt.startsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null) && StringsKt.endsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null);
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote) {
        String string;
        if (StringEscapeKt.isQuoted($this$unquote)) {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = StringEscapeKt.unescape(string2);
        } else {
            string = $this$unquote;
        }
        return string;
    }

    @NotNull
    public static final String getQuoted(@Nullable String $this$quoted) {
        return StringEscapeKt.quote($this$quoted);
    }

    @NotNull
    public static final String getUnquoted(@NotNull String $this$unquoted) {
        return StringEscapeKt.unquote($this$unquoted);
    }
}

