/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class LevelController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView homeLevelView;
    private String name;
    private Boolean viewable;
    private Float elevation;
    private Integer elevationIndex;
    private Float floorThickness;
    private Float height;
    private Level[] levels;
    private Integer selectedLevelIndex;

    public LevelController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.homeLevelView == null) {
            this.homeLevelView = this.viewFactory.createLevelView(this.preferences, this);
        }
        return this.homeLevelView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        Level level = this.home.getSelectedLevel();
        this.setLevels(this.clone(this.home.getLevels().toArray(new Level[0])));
        if (level == null) {
            this.setSelectedLevelIndex(null);
            this.setName(null);
            this.setViewable(Boolean.TRUE);
            this.setElevation(null, false);
            this.setFloorThickness(null);
            this.setHeight(null);
            this.setElevationIndex(null, false);
        } else {
            this.setSelectedLevelIndex(this.home.getLevels().indexOf(level));
            this.setName(level.getName());
            this.setViewable(level.isViewable());
            this.setElevation(Float.valueOf(level.getElevation()), false);
            this.setFloorThickness(Float.valueOf(level.getFloorThickness()));
            this.setHeight(Float.valueOf(level.getHeight()));
            this.setElevationIndex(level.getElevationIndex(), false);
        }
    }

    private Level[] clone(Level[] levelArray) {
        for (int i = 0; i < levelArray.length; ++i) {
            levelArray[i] = levelArray[i].clone();
        }
        return levelArray;
    }

    public boolean isPropertyEditable(Property property) {
        return true;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
            if (this.selectedLevelIndex != null) {
                this.levels[this.selectedLevelIndex].setName(string);
                this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), null, this.levels);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setViewable(Boolean bl) {
        if (bl != this.viewable) {
            Boolean bl2 = bl;
            this.viewable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VIEWABLE.name(), bl2, bl);
            if (bl != null && this.selectedLevelIndex != null) {
                this.levels[this.selectedLevelIndex].setViewable(bl);
                this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), null, this.levels);
            }
        }
    }

    public Boolean getViewable() {
        return this.viewable;
    }

    public void setElevation(Float f) {
        this.setElevation(f, true);
    }

    private void setElevation(Float f, boolean bl) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
            if (bl && f != null && this.selectedLevelIndex != null) {
                int n = LevelController.updateLevelElevation(this.levels[this.selectedLevelIndex], f.floatValue(), Arrays.asList(this.levels));
                this.setElevationIndex(n, false);
                this.updateLevels();
            }
        }
    }

    private static int updateLevelElevation(Level level, float f, List<Level> list) {
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Level level2 = list.get(i);
            if (level2 == level) {
                n = i;
                continue;
            }
            if (level2.getElevation() == f) {
                n2 = level2.getElevationIndex() + 1;
                continue;
            }
            if (i <= n || level2.getElevation() != level.getElevation()) continue;
            level2.setElevationIndex(level2.getElevationIndex() - 1);
        }
        level.setElevation(f);
        level.setElevationIndex(n2);
        return n2;
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setElevationIndex(Integer n) {
        this.setElevationIndex(n, true);
    }

    private void setElevationIndex(Integer n, boolean bl) {
        if (n != this.elevationIndex) {
            Integer n2 = this.elevationIndex;
            this.elevationIndex = n;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION_INDEX.name(), n2, n);
            if (bl && n != null && this.selectedLevelIndex != null) {
                LevelController.updateLevelElevationIndex(this.levels[this.selectedLevelIndex], n, Arrays.asList(this.levels));
                this.updateLevels();
            }
        }
    }

    private static void updateLevelElevationIndex(Level level, int n, List<Level> list) {
        float f = Math.signum(n - level.getElevationIndex());
        for (Level level2 : list) {
            if (level2 != level && level2.getElevation() == level.getElevation() && Math.signum(level2.getElevationIndex() - level.getElevationIndex()) == f && Math.signum(level2.getElevationIndex() - n) != f) {
                level2.setElevationIndex(level2.getElevationIndex() - (int)f);
                continue;
            }
            if (!(level2.getElevation() > level.getElevation())) continue;
            break;
        }
        level.setElevationIndex(n);
    }

    private void updateLevels() {
        Home home = new Home();
        Level level = this.levels[this.selectedLevelIndex];
        for (Level level2 : this.levels) {
            home.addLevel(level2);
        }
        List<Level> list = home.getLevels();
        this.setLevels(list.toArray(new Level[list.size()]));
        this.setSelectedLevelIndex(list.indexOf(level));
    }

    public Integer getElevationIndex() {
        return this.elevationIndex;
    }

    public void setFloorThickness(Float f) {
        if (f != this.floorThickness) {
            Float f2 = this.floorThickness;
            this.floorThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_THICKNESS.name(), f2, f);
            if (f != null && this.selectedLevelIndex != null) {
                this.levels[this.selectedLevelIndex].setFloorThickness(f.floatValue());
                this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), null, this.levels);
            }
        }
    }

    public Float getFloorThickness() {
        return this.floorThickness;
    }

    public void setHeight(Float f) {
        if (f != this.height) {
            Float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f2, f);
            if (f != null && this.selectedLevelIndex != null) {
                this.levels[this.selectedLevelIndex].setHeight(f.floatValue());
                this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), null, this.levels);
            }
        }
    }

    public Float getHeight() {
        return this.height;
    }

    private void setLevels(Level[] levelArray) {
        if (levelArray != this.levels) {
            Level[] levelArray2 = this.levels;
            this.levels = levelArray;
            this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), levelArray2, levelArray);
        }
    }

    public Level[] getLevels() {
        return (Level[])this.levels.clone();
    }

    private void setSelectedLevelIndex(Integer n) {
        if (n != this.selectedLevelIndex) {
            Integer n2 = this.selectedLevelIndex;
            this.selectedLevelIndex = n;
            this.propertyChangeSupport.firePropertyChange(Property.SELECT_LEVEL_INDEX.name(), n2, n);
        }
    }

    public Integer getSelectedLevelIndex() {
        return this.selectedLevelIndex;
    }

    public void modifyLevels() {
        Level level = this.home.getSelectedLevel();
        if (level != null) {
            List<Selectable> list = this.home.getSelectedItems();
            String string = this.getName();
            Boolean bl = this.getViewable();
            Float f = this.getElevation();
            Float f2 = this.getFloorThickness();
            Float f3 = this.getHeight();
            Integer n = this.getElevationIndex();
            ModifiedLevel modifiedLevel = new ModifiedLevel(level);
            LevelController.doModifyLevel(this.home, modifiedLevel, string, bl, f, f2, f3, n);
            if (this.undoSupport != null) {
                LevelModificationUndoableEdit levelModificationUndoableEdit = new LevelModificationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), modifiedLevel, string, bl, f, f2, f3, n);
                this.undoSupport.postEdit(levelModificationUndoableEdit);
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("LevelName", string);
            }
        }
    }

    private static void doModifyLevel(Home home, ModifiedLevel modifiedLevel, String string, Boolean bl, Float f, Float f2, Float f3, Integer n) {
        Object object;
        Level level = modifiedLevel.getLevel();
        if (string != null) {
            level.setName(string);
        }
        if (bl != null) {
            object = home.getSelectedItems();
            level.setViewable(bl);
            home.setSelectedItems(LevelController.getViewableSublist(object));
        }
        if (f != null && f.floatValue() != level.getElevation()) {
            LevelController.updateLevelElevation(level, f.floatValue(), home.getLevels());
        }
        if (n != null) {
            LevelController.updateLevelElevationIndex(level, n, home.getLevels());
        }
        if (!home.getEnvironment().isAllLevelsVisible()) {
            object = home.getSelectedLevel();
            boolean bl2 = true;
            for (Level level2 : home.getLevels()) {
                level2.setVisible(bl2);
                if (level2 != object) continue;
                bl2 = false;
            }
        }
        if (f2 != null) {
            level.setFloorThickness(f2.floatValue());
        }
        if (f3 != null) {
            level.setHeight(f3.floatValue());
        }
    }

    private static List<Selectable> getViewableSublist(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable selectable : list) {
            if (selectable instanceof Elevatable && !((Elevatable)((Object)selectable)).getLevel().isViewable()) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    private static void undoModifyLevel(Home home, ModifiedLevel modifiedLevel) {
        modifiedLevel.reset();
        Level level = modifiedLevel.getLevel();
        if (modifiedLevel.getElevation() != level.getElevation()) {
            LevelController.updateLevelElevation(level, modifiedLevel.getElevation(), home.getLevels());
        }
        if (modifiedLevel.getElevationIndex() != level.getElevationIndex()) {
            LevelController.updateLevelElevationIndex(level, modifiedLevel.getElevationIndex(), home.getLevels());
        }
    }

    private static class ModifiedLevel {
        private final Level level;
        private final String name;
        private final boolean viewable;
        private final float elevation;
        private final float floorThickness;
        private final float height;
        private final int elevationIndex;

        public ModifiedLevel(Level level) {
            this.level = level;
            this.name = level.getName();
            this.viewable = level.isViewable();
            this.elevation = level.getElevation();
            this.floorThickness = level.getFloorThickness();
            this.height = level.getHeight();
            this.elevationIndex = level.getElevationIndex();
        }

        public Level getLevel() {
            return this.level;
        }

        public float getElevation() {
            return this.elevation;
        }

        public int getElevationIndex() {
            return this.elevationIndex;
        }

        public void reset() {
            this.level.setName(this.name);
            this.level.setViewable(this.viewable);
            this.level.setFloorThickness(this.floorThickness);
            this.level.setHeight(this.height);
        }
    }

    private static class LevelModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final ModifiedLevel modifiedLevel;
        private final String name;
        private final Boolean viewable;
        private final Float elevation;
        private final Float floorThickness;
        private final Float height;
        private final Integer elevationIndex;

        private LevelModificationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, ModifiedLevel modifiedLevel, String string, Boolean bl, Float f, Float f2, Float f3, Integer n) {
            super(userPreferences, LevelController.class, "undoModifyLevelName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.modifiedLevel = modifiedLevel;
            this.name = string;
            this.viewable = bl;
            this.elevation = f;
            this.floorThickness = f2;
            this.height = f3;
            this.elevationIndex = n;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            LevelController.undoModifyLevel(this.home, this.modifiedLevel);
            this.home.setSelectedLevel(this.modifiedLevel.getLevel());
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedLevel(this.modifiedLevel.getLevel());
            LevelController.doModifyLevel(this.home, this.modifiedLevel, this.name, this.viewable, this.elevation, this.floorThickness, this.height, this.elevationIndex);
        }
    }

    public static enum Property {
        VIEWABLE,
        NAME,
        ELEVATION,
        ELEVATION_INDEX,
        FLOOR_THICKNESS,
        HEIGHT,
        LEVELS,
        SELECT_LEVEL_INDEX;

    }
}

