/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.freehep.xml.io.XMLIOStreamManager;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XMLIOFileManager
extends XMLIOStreamManager {
    private File xmlFile;
    private boolean isZipped = false;

    public XMLIOFileManager(String fileName) {
        this.xmlFile = new File(fileName);
    }

    public Element getRootElement() throws JDOMException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(this.xmlFile));
        }
        catch (IOException ioe) {
            if (inputStream != null) {
                inputStream.close();
            }
            inputStream = new FileInputStream(this.xmlFile);
        }
        super.setXMLInputStream(inputStream, "file:" + this.xmlFile.getAbsolutePath());
        return super.getRootElement();
    }

    public void saveRootElement(Element rootEl, String docName, String sysId) throws IOException {
        if (this.isXMLFileZipped()) {
            super.setXMLOutputStream(new GZIPOutputStream(new FileOutputStream(this.xmlFile)));
        } else {
            super.setXMLOutputStream(new FileOutputStream(this.xmlFile));
        }
        if (!docName.equals("") && !sysId.equals("")) {
            super.saveRootElement(rootEl, new DocType(docName, sysId));
        } else {
            super.saveRootElement(rootEl);
        }
    }

    public void saveRootElement(Element rootEl) throws IOException {
        this.saveRootElement(rootEl, "", "");
    }

    public boolean isXMLFileZipped() {
        return this.isZipped;
    }

    public void setXMLFileZipped(boolean isZipped) {
        this.isZipped = isZipped;
    }
}

