/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.accel;

import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.math.BoundingBox;
import org.sunflow.system.Memory;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.util.IntArray;

public class BoundingIntervalHierarchy
implements AccelerationStructure {
    private int[] tree;
    private int[] objects;
    private PrimitiveList primitives;
    private BoundingBox bounds;
    private int maxPrims = 2;

    public void build(PrimitiveList primitiveList) {
        int n;
        this.primitives = primitiveList;
        int n2 = primitiveList.getNumPrimitives();
        UI.printDetailed(UI.Module.ACCEL, "Getting bounding box ...", new Object[0]);
        this.bounds = primitiveList.getWorldBounds(null);
        this.objects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.objects[n] = n;
        }
        UI.printDetailed(UI.Module.ACCEL, "Creating tree ...", new Object[0]);
        n = 3 * (12 * n2 + 1);
        IntArray intArray = new IntArray((n + 3) / 4);
        BuildStats buildStats = new BuildStats();
        Timer timer = new Timer();
        timer.start();
        this.buildHierarchy(intArray, this.objects, buildStats);
        timer.end();
        UI.printDetailed(UI.Module.ACCEL, "Trimming tree ...", new Object[0]);
        this.tree = intArray.trim();
        buildStats.printStats();
        UI.printDetailed(UI.Module.ACCEL, "  * Creation time:  %s", timer);
        UI.printDetailed(UI.Module.ACCEL, "  * Usage of init:  %6.2f%%", 100.0 * (double)this.tree.length / (double)n);
        UI.printDetailed(UI.Module.ACCEL, "  * Tree memory:    %s", Memory.sizeof(this.tree));
        UI.printDetailed(UI.Module.ACCEL, "  * Indices memory: %s", Memory.sizeof(this.objects));
    }

    private void buildHierarchy(IntArray intArray, int[] nArray, BuildStats buildStats) {
        intArray.add(-1073741824);
        intArray.add(0);
        intArray.add(0);
        if (this.objects.length == 0) {
            return;
        }
        float[] fArray = new float[]{this.bounds.getMinimum().x, this.bounds.getMaximum().x, this.bounds.getMinimum().y, this.bounds.getMaximum().y, this.bounds.getMinimum().z, this.bounds.getMaximum().z};
        float[] fArray2 = new float[]{this.bounds.getMinimum().x, this.bounds.getMaximum().x, this.bounds.getMinimum().y, this.bounds.getMaximum().y, this.bounds.getMinimum().z, this.bounds.getMaximum().z};
        this.subdivide(0, this.objects.length - 1, intArray, nArray, fArray, fArray2, 0, 1, buildStats);
    }

    private void createNode(IntArray intArray, int n, int n2, int n3) {
        intArray.set(n + 0, 0xC0000000 | n2);
        intArray.set(n + 1, n3 - n2 + 1);
    }

    private void subdivide(int n, int n2, IntArray intArray, int[] nArray, float[] fArray, float[] fArray2, int n3, int n4, BuildStats buildStats) {
        int n5;
        if (n2 - n + 1 <= this.maxPrims || n4 >= 64) {
            buildStats.updateLeaf(n4, n2 - n + 1);
            this.createNode(intArray, n3, n, n2);
            return;
        }
        int n6 = -1;
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        boolean bl = true;
        float[] fArray3 = (float[])fArray.clone();
        float[] fArray4 = (float[])fArray2.clone();
        int n7 = 0;
        do {
            float f5;
            float f6;
            int n8 = n6;
            float f7 = f4;
            float[] fArray5 = new float[]{fArray[1] - fArray[0], fArray[3] - fArray[2], fArray[5] - fArray[4]};
            if (fArray5[0] < 0.0f || fArray5[1] < 0.0f || fArray5[2] < 0.0f) {
                throw new IllegalStateException("negative node extents");
            }
            for (int i = 0; i < 3; ++i) {
                if (!(fArray2[2 * i + 1] < fArray[2 * i]) && !(fArray2[2 * i] > fArray[2 * i + 1])) continue;
                UI.printError(UI.Module.ACCEL, "Reached tree area in error - discarding node with: %d objects", n2 - n + 1);
                throw new IllegalStateException("invalid node overlap");
            }
            n6 = fArray5[0] > fArray5[1] && fArray5[0] > fArray5[2] ? 0 : (fArray5[1] > fArray5[2] ? 1 : 2);
            f4 = 0.5f * (fArray[2 * n6] + fArray[2 * n6 + 1]);
            f = Float.NEGATIVE_INFINITY;
            f2 = Float.POSITIVE_INFINITY;
            n5 = n2;
            float f8 = Float.POSITIVE_INFINITY;
            float f9 = Float.NEGATIVE_INFINITY;
            int n9 = n;
            while (n9 <= n2) {
                float f10;
                int n10 = nArray[n9];
                float f11 = this.primitives.getPrimitiveBound(n10, 2 * n6 + 0);
                float f12 = (f11 + (f10 = this.primitives.getPrimitiveBound(n10, 2 * n6 + 1))) * 0.5f;
                if (f12 <= f4) {
                    ++n9;
                    if (f < f10) {
                        f = f10;
                    }
                } else {
                    int n11 = nArray[n9];
                    nArray[n9] = nArray[n2];
                    nArray[n2] = n11;
                    --n2;
                    if (f2 > f11) {
                        f2 = f11;
                    }
                }
                if (f8 > f11) {
                    f8 = f11;
                }
                if (!(f9 < f10)) continue;
                f9 = f10;
            }
            if (f8 > fArray2[2 * n6 + 0] && f9 < fArray2[2 * n6 + 1] && 1.3f * (f6 = f9 - f8) < (f5 = fArray2[2 * n6 + 1] - fArray2[2 * n6 + 0])) {
                buildStats.updateBVH2();
                int n12 = intArray.getSize();
                intArray.add(0);
                intArray.add(0);
                intArray.add(0);
                buildStats.updateInner();
                intArray.set(n3 + 0, n6 << 30 | 0x20000000 | n12);
                intArray.set(n3 + 1, Float.floatToRawIntBits(f8));
                intArray.set(n3 + 2, Float.floatToRawIntBits(f9));
                fArray2[2 * n6 + 0] = f8;
                fArray2[2 * n6 + 1] = f9;
                this.subdivide(n, n5, intArray, nArray, fArray, fArray2, n12, n4 + 1, buildStats);
                return;
            }
            if (n2 == n5) {
                if (f < f4 || f == f4 && (n8 != n6 || f7 != f4)) {
                    fArray[2 * n6 + 1] = f4;
                    f3 = f;
                    bl = true;
                    continue;
                }
                if (n8 == n6 && f7 == f4) {
                    buildStats.updateLeaf(n4, n2 - n + 1);
                    this.createNode(intArray, n3, n, n2);
                    return;
                }
                fArray[2 * n6 + 1] = f4;
                f3 = Float.NaN;
                continue;
            }
            if (n > n2) {
                n2 = n5;
                if (f2 > f4 || f2 == f4 && (n8 != n6 || f7 != f4)) {
                    fArray[2 * n6 + 0] = f4;
                    f3 = f2;
                    bl = false;
                    continue;
                }
                if (n8 == n6 && f7 == f4) {
                    buildStats.updateLeaf(n4, n2 - n + 1);
                    this.createNode(intArray, n3, n, n2);
                    return;
                }
                fArray[2 * n6 + 0] = f4;
                f3 = Float.NaN;
                continue;
            }
            if (n8 == -1 || Float.isNaN(f3)) break;
            n9 = intArray.getSize();
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
            if (bl) {
                buildStats.updateInner();
                intArray.set(n3 + 0, n8 << 30 | n9);
                intArray.set(n3 + 1, Float.floatToRawIntBits(f3));
                intArray.set(n3 + 2, Float.floatToRawIntBits(Float.POSITIVE_INFINITY));
            } else {
                buildStats.updateInner();
                intArray.set(n3 + 0, n8 << 30 | n9 - 3);
                intArray.set(n3 + 1, Float.floatToRawIntBits(Float.NEGATIVE_INFINITY));
                intArray.set(n3 + 2, Float.floatToRawIntBits(f3));
            }
            buildStats.updateLeaf(++n4, 0);
            n3 = n9;
            break;
        } while (n7++ < 100);
        if (n7 > 100) {
            System.arraycopy(fArray3, 0, fArray, 0, fArray.length);
            System.arraycopy(fArray4, 0, fArray2, 0, fArray2.length);
            return;
        }
        int n13 = intArray.getSize();
        int n14 = n2 - n + 1;
        int n15 = n5 - (n2 + 1) + 1;
        if (n14 > 0) {
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
        } else {
            n13 -= 3;
        }
        if (n15 > 0) {
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
        }
        buildStats.updateInner();
        intArray.set(n3 + 0, n6 << 30 | n13);
        intArray.set(n3 + 1, Float.floatToRawIntBits(f));
        intArray.set(n3 + 2, Float.floatToRawIntBits(f2));
        float[] fArray6 = new float[6];
        float[] fArray7 = new float[6];
        float[] fArray8 = new float[6];
        float[] fArray9 = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray6[i] = fArray7[i] = fArray[i];
            fArray8[i] = fArray9[i] = fArray2[i];
        }
        float f13 = f4;
        fArray7[2 * n6] = f13;
        fArray6[2 * n6 + 1] = f13;
        fArray8[2 * n6 + 1] = f;
        fArray9[2 * n6 + 0] = f2;
        fArray2 = null;
        fArray = null;
        if (n14 > 0) {
            this.subdivide(n, n2, intArray, nArray, fArray6, fArray8, n13, n4 + 1, buildStats);
        } else {
            buildStats.updateLeaf(n4 + 1, 0);
        }
        if (n15 > 0) {
            this.subdivide(n2 + 1, n5, intArray, nArray, fArray7, fArray9, n13 + 3, n4 + 1, buildStats);
        } else {
            buildStats.updateLeaf(n4 + 1, 0);
        }
    }

    public void intersect(Ray ray, IntersectionState intersectionState) {
        float f = ray.getMin();
        float f2 = ray.getMax();
        float f3 = ray.ox;
        float f4 = ray.dx;
        float f5 = 1.0f / f4;
        float f6 = (this.bounds.getMinimum().x - f3) * f5;
        float f7 = (this.bounds.getMaximum().x - f3) * f5;
        if (f5 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f8 = ray.oy;
        float f9 = ray.dy;
        float f10 = 1.0f / f9;
        f6 = (this.bounds.getMinimum().y - f8) * f10;
        f7 = (this.bounds.getMaximum().y - f8) * f10;
        if (f10 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f11 = ray.oz;
        float f12 = ray.dz;
        float f13 = 1.0f / f12;
        f6 = (this.bounds.getMinimum().z - f11) * f13;
        f7 = (this.bounds.getMaximum().z - f11) * f13;
        if (f13 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        int n = Float.floatToRawIntBits(f4) >>> 31;
        int n2 = Float.floatToRawIntBits(f9) >>> 31;
        int n3 = Float.floatToRawIntBits(f12) >>> 31;
        int n4 = n ^ 1;
        int n5 = n2 ^ 1;
        int n6 = n3 ^ 1;
        int n7 = n * 3;
        int n8 = n2 * 3;
        int n9 = n3 * 3;
        int n10 = n4 * 3;
        int n11 = n5 * 3;
        int n12 = n6 * 3;
        ++n;
        ++n2;
        ++n3;
        ++n4;
        ++n5;
        ++n6;
        IntersectionState.StackNode[] stackNodeArray = intersectionState.getStack();
        int n13 = 0;
        int n14 = 0;
        block9: while (true) {
            int n15 = this.tree[n14];
            int n16 = n15 & 0xE0000000;
            int n17 = n15 & 0x1FFFFFFF;
            switch (n16) {
                case 0: {
                    int n18;
                    float f14 = (Float.intBitsToFloat(this.tree[n14 + n]) - f3) * f5;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n4]) - f3) * f5;
                    if (f14 < f && f15 > f2) break;
                    n14 = n18 = n17 + n10;
                    if (f14 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n14 = n17 + n7;
                    if (f15 > f2) {
                        f2 = f14 <= f2 ? f14 : f2;
                        continue block9;
                    }
                    if (n13 == stackNodeArray.length) break;
                    stackNodeArray[n13].node = n18;
                    stackNodeArray[n13].near = f15 >= f ? f15 : f;
                    stackNodeArray[n13].far = f2;
                    ++n13;
                    f2 = f14 <= f2 ? f14 : f2;
                    continue block9;
                }
                case 0x40000000: {
                    int n18;
                    float f16 = (Float.intBitsToFloat(this.tree[n14 + n2]) - f8) * f10;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n5]) - f8) * f10;
                    if (f16 < f && f15 > f2) break;
                    n14 = n18 = n17 + n11;
                    if (f16 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n14 = n17 + n8;
                    if (f15 > f2) {
                        f2 = f16 <= f2 ? f16 : f2;
                        continue block9;
                    }
                    if (n13 == stackNodeArray.length) break;
                    stackNodeArray[n13].node = n18;
                    stackNodeArray[n13].near = f15 >= f ? f15 : f;
                    stackNodeArray[n13].far = f2;
                    ++n13;
                    f2 = f16 <= f2 ? f16 : f2;
                    continue block9;
                }
                case -2147483648: {
                    int n18;
                    float f17 = (Float.intBitsToFloat(this.tree[n14 + n3]) - f11) * f13;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n6]) - f11) * f13;
                    if (f17 < f && f15 > f2) break;
                    n14 = n18 = n17 + n12;
                    if (f17 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n14 = n17 + n9;
                    if (f15 > f2) {
                        f2 = f17 <= f2 ? f17 : f2;
                        continue block9;
                    }
                    if (n13 == stackNodeArray.length) break;
                    stackNodeArray[n13].node = n18;
                    stackNodeArray[n13].near = f15 >= f ? f15 : f;
                    stackNodeArray[n13].far = f2;
                    ++n13;
                    f2 = f17 <= f2 ? f17 : f2;
                    continue block9;
                }
                case -1073741824: {
                    int n19 = this.tree[n14 + 1];
                    while (n19 > 0) {
                        this.primitives.intersectPrimitive(ray, this.objects[n17], intersectionState);
                        --n19;
                        ++n17;
                    }
                    break;
                }
                case 0x20000000: {
                    float f18 = (Float.intBitsToFloat(this.tree[n14 + n]) - f3) * f5;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n4]) - f3) * f5;
                    n14 = n17;
                    f = f18 >= f ? f18 : f;
                    float f19 = f15 <= f2 ? f15 : f2;
                    f2 = f19;
                    if (!(f > f2)) continue block9;
                    break;
                }
                case 0x60000000: {
                    float f20 = (Float.intBitsToFloat(this.tree[n14 + n2]) - f8) * f10;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n5]) - f8) * f10;
                    n14 = n17;
                    f = f20 >= f ? f20 : f;
                    float f21 = f15 <= f2 ? f15 : f2;
                    f2 = f21;
                    if (!(f > f2)) continue block9;
                    break;
                }
                case -1610612736: {
                    float f22 = (Float.intBitsToFloat(this.tree[n14 + n3]) - f11) * f13;
                    float f15 = (Float.intBitsToFloat(this.tree[n14 + n6]) - f11) * f13;
                    n14 = n17;
                    f = f22 >= f ? f22 : f;
                    float f23 = f15 <= f2 ? f15 : f2;
                    f2 = f23;
                    if (!(f > f2)) continue block9;
                    break;
                }
                default: {
                    return;
                }
            }
            do {
                if (n13 == 0 || Float.isNaN(ray.dx) || Float.isNaN(ray.dy) || Float.isNaN(ray.dz)) {
                    return;
                }
                f = stackNodeArray[--n13].near;
            } while (ray.getMax() < f);
            n14 = stackNodeArray[n13].node;
            f2 = stackNodeArray[n13].far;
        }
    }

    private static class BuildStats {
        private int numNodes = 0;
        private int numLeaves = 0;
        private int sumObjects = 0;
        private int minObjects = Integer.MAX_VALUE;
        private int maxObjects = Integer.MIN_VALUE;
        private int sumDepth = 0;
        private int minDepth = Integer.MAX_VALUE;
        private int maxDepth = Integer.MIN_VALUE;
        private int numLeaves0 = 0;
        private int numLeaves1 = 0;
        private int numLeaves2 = 0;
        private int numLeaves3 = 0;
        private int numLeaves4 = 0;
        private int numLeaves4p = 0;
        private int numBVH2 = 0;

        BuildStats() {
        }

        void updateInner() {
            ++this.numNodes;
        }

        void updateBVH2() {
            ++this.numBVH2;
        }

        void updateLeaf(int n, int n2) {
            ++this.numLeaves;
            this.minDepth = Math.min(n, this.minDepth);
            this.maxDepth = Math.max(n, this.maxDepth);
            this.sumDepth += n;
            this.minObjects = Math.min(n2, this.minObjects);
            this.maxObjects = Math.max(n2, this.maxObjects);
            this.sumObjects += n2;
            switch (n2) {
                case 0: {
                    ++this.numLeaves0;
                    break;
                }
                case 1: {
                    ++this.numLeaves1;
                    break;
                }
                case 2: {
                    ++this.numLeaves2;
                    break;
                }
                case 3: {
                    ++this.numLeaves3;
                    break;
                }
                case 4: {
                    ++this.numLeaves4;
                    break;
                }
                default: {
                    ++this.numLeaves4p;
                }
            }
        }

        void printStats() {
            UI.printDetailed(UI.Module.ACCEL, "Tree stats:", new Object[0]);
            UI.printDetailed(UI.Module.ACCEL, "  * Nodes:          %d", this.numNodes);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves:         %d", this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "  * Objects: min    %d", this.minObjects);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumObjects / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "           avg(n>0) %.2f", Float.valueOf((float)this.sumObjects / (float)(this.numLeaves - this.numLeaves0)));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxObjects);
            UI.printDetailed(UI.Module.ACCEL, "  * Depth:   min    %d", this.minDepth);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumDepth / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxDepth);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves w/: N=0  %3d%%", 100 * this.numLeaves0 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=1  %3d%%", 100 * this.numLeaves1 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=2  %3d%%", 100 * this.numLeaves2 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=3  %3d%%", 100 * this.numLeaves3 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=4  %3d%%", 100 * this.numLeaves4 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N>4  %3d%%", 100 * this.numLeaves4p / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "  * BVH2 nodes:     %d (%3d%%)", this.numBVH2, 100 * this.numBVH2 / (this.numNodes + this.numLeaves - 2 * this.numBVH2));
        }
    }
}

