/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AscensionChallenge;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SlimeSprite;

public class Slime
extends Mob {
    public Slime() {
        this.spriteClass = SlimeSprite.class;
        this.HT = 20;
        this.HP = 20;
        this.defenseSkill = 5;
        this.EXP = 4;
        this.maxLvl = 9;
        this.lootChance = 0.2f;
    }

    @Override
    public int damageRoll() {
        return Char.combatRoll(2, 5);
    }

    @Override
    public int attackSkill(Char target) {
        return 12;
    }

    @Override
    public void damage(int dmg, Object src) {
        float scaleFactor = AscensionChallenge.statModifier(this);
        int scaledDmg = Math.round((float)dmg / scaleFactor);
        if (scaledDmg >= 5) {
            scaledDmg = 4 + (int)(Math.sqrt(8 * (scaledDmg - 4) + 1) - 1.0) / 2;
        }
        dmg = (int)((float)scaledDmg * AscensionChallenge.statModifier(this));
        super.damage(dmg, src);
    }

    @Override
    public float lootChance() {
        return super.lootChance() * (float)Math.pow(0.3333333432674408, Dungeon.LimitedDrops.SLIME_WEP.count);
    }

    @Override
    public Item createLoot() {
        ++Dungeon.LimitedDrops.SLIME_WEP.count;
        Generator.Category c = Generator.Category.WEP_T2;
        MeleeWeapon w = (MeleeWeapon)Generator.randomUsingDefaults(Generator.Category.WEP_T2);
        w.level(0);
        return w;
    }
}

