# Property1UnitTest\[T: T\]
<span class="source-link">[[Source]](src/pony_check/property_unit_test.md#L-0-3)</span>

Provides plumbing for integration of PonyCheck
[Properties](pony_check-Property1.md) into [PonyTest](pony_test--index.md).

Wrap your properties into this class and use it in a
[TestList](pony_test-TestList.md):

```pony
use "pony_test"
use "pony_check"

class MyProperty is Property1[String]
  fun name(): String => "my_property"

  fun gen(): Generator[String] =>
    Generators.ascii_printable()

  fun property(arg1: String, h: PropertyHelper) =>
    h.assert_true(arg1.size() > 0)

actor Main is TestList
  new create(env: Env) => PonyTest(env, this)

  fun tag tests(test: PonyTest) =>
    test(Property1UnitTest[String](MyProperty))

```


```pony
class iso Property1UnitTest[T: T] is
  UnitTest ref
```

#### Implements

* [UnitTest](pony_test-UnitTest.md) ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/pony_check/property_unit_test.md#L-0-36)</span>


Wrap a [Property1](pony_check-Property1.md) to make it mimic the PonyTest
[UnitTest](pony_test-UnitTest.md).

If `name'` is given, use this as the test name.
If not, use the property's `name()`.


```pony
new iso create(
  p1: Property1[T] iso,
  name': (String val | None val) = reference)
: Property1UnitTest[T] iso^
```
#### Parameters

*   p1: [Property1](pony_check-Property1.md)\[T\] iso
*   name': ([String](builtin-String.md) val | [None](builtin-None.md) val) = reference

#### Returns

* [Property1UnitTest](pony_check-Property1UnitTest.md)\[T\] iso^

---

## Public Functions

### name
<span class="source-link">[[Source]](src/pony_check/property_unit_test.md#L-0-52)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### apply
<span class="source-link">[[Source]](src/pony_check/property_unit_test.md#L-0-54)</span>


```pony
fun ref apply(
  h: TestHelper val)
: None val ?
```
#### Parameters

*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### exclusion_group



```pony
fun box exclusion_group()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### timed_out



```pony
fun ref timed_out(
  h: TestHelper val)
: None val
```
#### Parameters

*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [None](builtin-None.md) val

---

### set_up



```pony
fun ref set_up(
  h: TestHelper val)
: None val ?
```
#### Parameters

*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### tear_down



```pony
fun ref tear_down(
  h: TestHelper val)
: None val
```
#### Parameters

*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [None](builtin-None.md) val

---

### label



```pony
fun box label()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

