# IsPrime\[A: ([UnsignedInteger](builtin-UnsignedInteger.md)\[A\] val & ([U8](builtin-U8.md) val | [U16](builtin-U16.md) val | [U32](builtin-U32.md) val | [U64](builtin-U64.md) val | [U128](builtin-U128.md) val | [ULong](builtin-ULong.md) val | [USize](builtin-USize.md) val))\]
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-1)</span>

Primality test using 6k ± 1 method.

All integers (excluding 2 and 3), can be expressed as (6k + i),
where i = −1, 0, 1, 2, 3, or 4. Since 2 divides (6k + 0), (6k + 2),
and (6k + 4), while 3 divides (6k + 3) that leaves only (6k - 1) and (6k + 1)
for expressing primes.


```pony
primitive val IsPrime[A: (UnsignedInteger[A] val & (U8 val | U16 val | U32 val | 
    U64 val | U128 val | ULong val | 
    USize val))]
```

## Constructors

### create
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-1)</span>


```pony
new val create()
: IsPrime[A] val^
```

#### Returns

* [IsPrime](math-IsPrime.md)\[A\] val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-74)</span>


```pony
fun box apply(
  n: A)
: Bool val
```
#### Parameters

*   n: A

#### Returns

* [Bool](builtin-Bool.md) val

---

### eq
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-13)</span>


```pony
fun box eq(
  that: IsPrime[A] val)
: Bool val
```
#### Parameters

*   that: [IsPrime](math-IsPrime.md)\[A\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-13)</span>


```pony
fun box ne(
  that: IsPrime[A] val)
: Bool val
```
#### Parameters

*   that: [IsPrime](math-IsPrime.md)\[A\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

## Private Functions

### _low_prime_table
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-13)</span>


```pony
fun box _low_prime_table(
  index: USize val)
: A
```
#### Parameters

*   index: [USize](builtin-USize.md) val

#### Returns

* A

---

### _low_prime_table_size
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-70)</span>


```pony
fun box _low_prime_table_size()
: USize val
```

#### Returns

* [USize](builtin-USize.md) val

---

### _u8_prime_table_size
<span class="source-link">[[Source]](src/math/is_prime.md#L-0-72)</span>


```pony
fun box _u8_prime_table_size()
: USize val
```

#### Returns

* [USize](builtin-USize.md) val

---

