# Bureaucracy package

It happens to almost every program. It starts small, tiny if you will, like a
village where every actor knows every other actor and shutdown is easy. One day
you realize your program is no longer a cute seaside hamlet, its a bustling
metropolis and you are doing way too much work to keep track of everything.
What do you do? Call for a little bureaucracy.

The bureaucracy contains objects designed to ease your bookkeeping burdens.
Need to shutdown a number of actors together? Check out `Custodian`. Need
to keep track of a lot of stuff and be able to look it up by name? Check out
`Registrar`.

Put bureaucracy to use today and before long, your sprawling metropolis of a
code base will be manageable again in no time.


## Public Types

* [actor Custodian](bureaucracy-Custodian.md)
* [actor Registrar](bureaucracy-Registrar.md)
