/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.io.JavascriptFunction;

public class DefaultJavascriptFunction
implements JavascriptFunction {
    private final ScriptSession session;
    private final String id;

    public DefaultJavascriptFunction(ScriptSession session, String id) {
        this.session = session;
        this.id = id;
    }

    @Override
    public void execute(Object ... params) {
        ScriptBuffer script = EnginePrivate.getRemoteExecuteFunctionScript(this.id, params);
        this.session.addScript(script);
    }

    @Override
    public void close() {
        ScriptBuffer script = EnginePrivate.getRemoteCloseFunctionScript(this.id);
        this.session.addScript(script);
    }

    @Override
    public void executeAndClose(Object ... params) {
        this.execute(params);
        this.close();
    }

    public String toString() {
        return "browser[" + this.session.getId() + "].functions[" + this.id + "](...)";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultJavascriptFunction that = (DefaultJavascriptFunction)obj;
        if (!this.session.equals(that.session)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int hash = 523;
        hash += this.id == null ? 392 : this.id.hashCode();
        return hash += this.session == null ? 894 : this.session.hashCode();
    }
}

