/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/sam/4l/irq.json
 */

#ifndef LIBOPENCM3_SAM4L_NVIC_H
#define LIBOPENCM3_SAM4L_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for Atmel SAM4L series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_HFLASHC_IRQ 0
#define NVIC_PDCA0_IRQ 1
#define NVIC_PDCA1_IRQ 2
#define NVIC_PDCA2_IRQ 3
#define NVIC_PDCA3_IRQ 4
#define NVIC_PDCA4_IRQ 5
#define NVIC_PDCA5_IRQ 6
#define NVIC_PDCA6_IRQ 7
#define NVIC_PDCA7_IRQ 8
#define NVIC_PDCA8_IRQ 9
#define NVIC_PDCA9_IRQ 10
#define NVIC_PDCA10_IRQ 11
#define NVIC_PDCA11_IRQ 12
#define NVIC_PDCA12_IRQ 13
#define NVIC_PDCA13_IRQ 14
#define NVIC_PDCA14_IRQ 15
#define NVIC_PDCA15_IRQ 16
#define NVIC_CRCCU_IRQ 17
#define NVIC_USBC_IRQ 18
#define NVIC_PEVC_TR_IRQ 19
#define NVIC_PEVC_OV_IRQ 20
#define NVIC_AESA_IRQ 21
#define NVIC_PM_IRQ 22
#define NVIC_SCIM_IRQ 23
#define NVIC_FREQM_IRQ 24
#define NVIC_GPIO0_IRQ 25
#define NVIC_GPIO1_IRQ 26
#define NVIC_GPIO2_IRQ 27
#define NVIC_GPIO3_IRQ 28
#define NVIC_GPIO4_IRQ 29
#define NVIC_GPIO5_IRQ 30
#define NVIC_GPIO6_IRQ 31
#define NVIC_GPIO7_IRQ 32
#define NVIC_GPIO8_IRQ 33
#define NVIC_GPIO9_IRQ 34
#define NVIC_GPIO10_IRQ 35
#define NVIC_GPIO11_IRQ 36
#define NVIC_BPM_IRQ 37
#define NVIC_BSCIF_IRQ 38
#define NVIC_AST_ALARM_IRQ 39
#define NVIC_AST_PER_IRQ 40
#define NVIC_AST_OVF_IRQ 41
#define NVIC_AST_READY_IRQ 42
#define NVIC_AST_CLKREADY_IRQ 43
#define NVIC_WDT_IRQ 44
#define NVIC_EIC1_IRQ 45
#define NVIC_EIC2_IRQ 46
#define NVIC_EIC3_IRQ 47
#define NVIC_EIC4_IRQ 48
#define NVIC_EIC5_IRQ 49
#define NVIC_EIC6_IRQ 50
#define NVIC_EIC7_IRQ 51
#define NVIC_EIC8_IRQ 52
#define NVIC_IISC_IRQ 53
#define NVIC_SPI_IRQ 54
#define NVIC_TC00_IRQ 55
#define NVIC_TC01_IRQ 56
#define NVIC_TC02_IRQ 57
#define NVIC_TC10_IRQ 58
#define NVIC_TC11_IRQ 59
#define NVIC_TC12_IRQ 60
#define NVIC_TWIM0_IRQ 61
#define NVIC_TWIS0_IRQ 62
#define NVIC_TWIM1_IRQ 63
#define NVIC_TWIS1_IRQ 64
#define NVIC_USART0_IRQ 65
#define NVIC_USART1_IRQ 66
#define NVIC_USART2_IRQ 67
#define NVIC_USART3_IRQ 68
#define NVIC_ADCIFE_IRQ 69
#define NVIC_DACC_IRQ 70
#define NVIC_ACIFC_IRQ 71
#define NVIC_ABDACB_IRQ 72
#define NVIC_TRNG_IRQ 73
#define NVIC_PARC_IRQ 74
#define NVIC_CATB_IRQ 75
#define NVIC_RESERVED0_IRQ 76
#define NVIC_TWIM2_IRQ 77
#define NVIC_TWIM3_IRQ 78
#define NVIC_LCDCA_IRQ 79

#define NVIC_IRQ_COUNT 80

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_SAM4L User interrupt service routines (ISR) prototypes for Atmel SAM4L series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void hflashc_isr(void);
void pdca0_isr(void);
void pdca1_isr(void);
void pdca2_isr(void);
void pdca3_isr(void);
void pdca4_isr(void);
void pdca5_isr(void);
void pdca6_isr(void);
void pdca7_isr(void);
void pdca8_isr(void);
void pdca9_isr(void);
void pdca10_isr(void);
void pdca11_isr(void);
void pdca12_isr(void);
void pdca13_isr(void);
void pdca14_isr(void);
void pdca15_isr(void);
void crccu_isr(void);
void usbc_isr(void);
void pevc_tr_isr(void);
void pevc_ov_isr(void);
void aesa_isr(void);
void pm_isr(void);
void scim_isr(void);
void freqm_isr(void);
void gpio0_isr(void);
void gpio1_isr(void);
void gpio2_isr(void);
void gpio3_isr(void);
void gpio4_isr(void);
void gpio5_isr(void);
void gpio6_isr(void);
void gpio7_isr(void);
void gpio8_isr(void);
void gpio9_isr(void);
void gpio10_isr(void);
void gpio11_isr(void);
void bpm_isr(void);
void bscif_isr(void);
void ast_alarm_isr(void);
void ast_per_isr(void);
void ast_ovf_isr(void);
void ast_ready_isr(void);
void ast_clkready_isr(void);
void wdt_isr(void);
void eic1_isr(void);
void eic2_isr(void);
void eic3_isr(void);
void eic4_isr(void);
void eic5_isr(void);
void eic6_isr(void);
void eic7_isr(void);
void eic8_isr(void);
void iisc_isr(void);
void spi_isr(void);
void tc00_isr(void);
void tc01_isr(void);
void tc02_isr(void);
void tc10_isr(void);
void tc11_isr(void);
void tc12_isr(void);
void twim0_isr(void);
void twis0_isr(void);
void twim1_isr(void);
void twis1_isr(void);
void usart0_isr(void);
void usart1_isr(void);
void usart2_isr(void);
void usart3_isr(void);
void adcife_isr(void);
void dacc_isr(void);
void acifc_isr(void);
void abdacb_isr(void);
void trng_isr(void);
void parc_isr(void);
void catb_isr(void);
void reserved0_isr(void);
void twim2_isr(void);
void twim3_isr(void);
void lcdca_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_SAM4L_NVIC_H */
