/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.mining.word2vec.AbstractVectorModel;
import com.hankcs.hanlp.mining.word2vec.Vector;
import com.hankcs.hanlp.mining.word2vec.WordVectorModel;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.NotionalTokenizer;
import java.util.List;
import java.util.Map;

public class DocVectorModel
extends AbstractVectorModel<Integer> {
    private final WordVectorModel wordVectorModel;
    private Segment segment;
    private boolean filter;

    public DocVectorModel(WordVectorModel wordVectorModel) {
        this(wordVectorModel, NotionalTokenizer.SEGMENT, true);
    }

    public DocVectorModel(WordVectorModel wordVectorModel, Segment segment, boolean filter) {
        this.wordVectorModel = wordVectorModel;
        this.segment = segment;
        this.filter = filter;
    }

    public Vector addDocument(int id, String content) {
        Vector result = this.query(content);
        if (result == null) {
            return null;
        }
        this.storage.put(id, result);
        return result;
    }

    @Override
    public List<Map.Entry<Integer, Float>> nearest(String query) {
        return this.queryNearest(query, 10);
    }

    @Override
    public List<Map.Entry<Integer, Float>> nearest(String query, int n) {
        return this.queryNearest(query, n);
    }

    @Override
    public Vector query(String content) {
        if (content == null || content.length() == 0) {
            return null;
        }
        List<Term> termList = this.segment.seg(content);
        if (this.filter) {
            CoreStopWordDictionary.apply(termList);
        }
        Vector result = new Vector(this.dimension());
        int n = 0;
        for (Term term : termList) {
            Vector vector = this.wordVectorModel.vector(term.word);
            if (vector == null) continue;
            ++n;
            result.addToSelf(vector);
        }
        if (n == 0) {
            return null;
        }
        result.normalize();
        return result;
    }

    @Override
    public int dimension() {
        return this.wordVectorModel.dimension();
    }

    @Override
    public float similarity(String what, String with) {
        Vector A = this.query(what);
        if (A == null) {
            return -1.0f;
        }
        Vector B = this.query(with);
        if (B == null) {
            return -1.0f;
        }
        return A.cosineForUnitVector(B);
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    public boolean isFilterEnabled() {
        return this.filter;
    }

    public void enableFilter(boolean filter) {
        this.filter = filter;
    }
}

