/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import net.java.sen.util.IOUtils;

public class CSVParser
implements Closeable {
    private BufferedReader reader = null;
    private InputStreamReader inputStreamReader = null;
    private StringReader stringReader = null;
    private String line = null;
    private int position = 0;

    public boolean nextRow() throws IOException {
        this.line = this.reader.readLine();
        if (this.line == null || this.line.length() == 0) {
            return false;
        }
        this.position = 0;
        return true;
    }

    public String nextToken() {
        boolean quote = false;
        if (this.line == null || this.position >= this.line.length()) {
            return null;
        }
        if (this.line.charAt(this.position) == '\"') {
            quote = true;
            ++this.position;
        }
        int start = this.position;
        while (this.position < this.line.length()) {
            if (this.line.charAt(this.position) == ',' && !quote) {
                return this.line.substring(start, this.position++);
            }
            if (this.line.charAt(this.position) == '\"' && quote) {
                if (this.position + 1 < this.line.length() && this.line.charAt(this.position + 1) == '\"') {
                    this.position += 2;
                    continue;
                }
                String ret = this.line.substring(start, this.position).replaceAll("\"\"", "\"");
                this.position += 2;
                return ret;
            }
            ++this.position;
        }
        return this.line.substring(start, this.position);
    }

    public String[] nextTokens() throws IOException {
        String input;
        ArrayList<String> list = new ArrayList<String>();
        if (!this.nextRow()) {
            return null;
        }
        while ((input = this.nextToken()) != null) {
            list.add(input);
        }
        String[] tokens = list.toArray(new String[0]);
        return tokens;
    }

    public String currentLine() {
        return this.line;
    }

    public CSVParser(InputStream inputStream, String charset) throws IOException {
        this.inputStreamReader = new InputStreamReader(inputStream, charset);
        this.reader = new BufferedReader(this.inputStreamReader);
    }

    public CSVParser(String string) {
        this.stringReader = new StringReader(string);
        this.reader = new BufferedReader(this.stringReader);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.reader, this.stringReader, this.inputStreamReader);
    }
}

