/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik.suggestions_ordering;

import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.DetailedDamerauLevenstheinDistance;
import org.languagetool.rules.spelling.symspell.implementation.EditDistance;

public class DetailedDamerauLevenstheinDistanceTest {
    private Pair<String, DetailedDamerauLevenstheinDistance.Distance> modifyString(String s, int distance) {
        String result = s;
        DetailedDamerauLevenstheinDistance.Distance history = new DetailedDamerauLevenstheinDistance.Distance();
        for (int i = 0; i < distance; ++i) {
            DetailedDamerauLevenstheinDistance.EditOperation op = DetailedDamerauLevenstheinDistance.randomEdit();
            String tmp = (String)op.apply((Object)result);
            if (tmp == null) {
                return null;
            }
            result = tmp;
            history = history.track(op);
        }
        return Pair.of((Object)result, (Object)history);
    }

    @Test
    @Ignore(value="Needs further debugging, but since this is only used as a feature in ML models errors are tolerable for now.")
    public void testDistanceComputation() {
        String text = "This is a test text. Random edits will occur here. Foo bar baz. Bla bla. Lorem ipsum dolor sit amet.";
        Random random = new Random(0L);
        int trials = 1000;
        int maxDist = 10;
        EditDistance reference = new EditDistance(text, EditDistance.DistanceAlgorithm.Damerau);
        for (int i = 0; i < trials; ++i) {
            int operations = random.nextInt(maxDist);
            Pair<String, DetailedDamerauLevenstheinDistance.Distance> modified = this.modifyString(text, operations);
            if (modified == null) continue;
            int actualDist = reference.compare((String)modified.getLeft(), -1);
            DetailedDamerauLevenstheinDistance.Distance computedDist = DetailedDamerauLevenstheinDistance.compare((String)text, (String)((String)modified.getLeft()));
            System.out.printf("Comparing '%s'; actual modifications: %s / computed modifications: %s / reference distance: %d.%n", modified.getLeft(), modified.getRight(), computedDist, actualDist);
            MatcherAssert.assertThat((Object)computedDist.value(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)((DetailedDamerauLevenstheinDistance.Distance)modified.getRight()).value()), (Matcher)CoreMatchers.equalTo((Object)actualDist)));
        }
    }

    @Test
    @Ignore(value="WIP")
    public void testDistanceDetails() {
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().delete(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Tet"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().insert(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Teste"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().transpose(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Tets"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().replace(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Tast"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().replace().insert(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Taste"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().delete().transpose(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Tts"));
        Assert.assertEquals((Object)new DetailedDamerauLevenstheinDistance.Distance().insert().insert(), (Object)DetailedDamerauLevenstheinDistance.compare((String)"Test", (String)"Teeste"));
    }
}

