/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.gui.LanguageToolEvent;
import org.languagetool.gui.LanguageToolListener;
import org.languagetool.gui.LanguageToolSupport;
import org.languagetool.gui.RetainLineBreakTransferHandler;
import org.languagetool.gui.RuleLink;
import org.languagetool.gui.Tools;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.ContextTools;

class ResultAreaHelper
implements LanguageToolListener,
HyperlinkListener {
    private static final String KEY = "org.languagetool.gui.ResultAreaHelper";
    private static final String EMPTY_PARA = "<p class=\"small\"></p>";
    private static final String HEADER = "header";
    private static final String MAIN = "maincontent";
    private static final String TEMPLATE = "<html>\n  <head>\n     <style type=\"text/css\">\n       #header {  }\n       #maincontent { }\n       p { font-family: Arial,Helvetica; padding: 1px; margin: 1px }\n       p.small { font-size: 1px; }\n       p.grayed { font-family: Arial,Helvetica; color: #666666 }\n     </style>\n  </head>\n  <body>\n    <div id=\"header\">\n    </div>\n    <div id=\"maincontent\">\n    </div>\n  </body>\n</html>";
    private static final String DEACTIVATE_URL = "http://languagetool.org/deactivate/";
    private static final String REACTIVATE_URL = "http://languagetool.org/reactivate/";
    private static final String LT_ERROR_MARKER_START = "<b><font bgcolor=\"#d7d7ff\">";
    private static final String SPELL_ERROR_MARKER_START = "<b><font bgcolor=\"#ffd7d7\">";
    private final ResourceBundle messages;
    private final JTextPane statusPane;
    private final LanguageToolSupport ltSupport;
    private long runTime;
    private final Object lock = new Object();
    private boolean enabled = false;

    static void install(ResourceBundle messages, LanguageToolSupport ltSupport, JTextPane pane) {
        Object prev = pane.getClientProperty(KEY);
        if (prev instanceof ResultAreaHelper) {
            ResultAreaHelper.enable(pane);
            return;
        }
        ResultAreaHelper helper = new ResultAreaHelper(messages, ltSupport, pane);
        pane.putClientProperty(KEY, helper);
    }

    static void enable(JTextPane pane) {
        Object helper = pane.getClientProperty(KEY);
        if (helper instanceof ResultAreaHelper) {
            ((ResultAreaHelper)helper).enable();
        }
    }

    static void disable(JTextPane pane) {
        Object helper = pane.getClientProperty(KEY);
        if (helper instanceof ResultAreaHelper) {
            ((ResultAreaHelper)helper).disable();
        }
    }

    private ResultAreaHelper(ResourceBundle messages, LanguageToolSupport ltSupport, JTextPane statusPane) {
        this.messages = messages;
        this.ltSupport = ltSupport;
        this.statusPane = statusPane;
        statusPane.setContentType("text/html");
        statusPane.setEditable(false);
        statusPane.setTransferHandler(new RetainLineBreakTransferHandler());
        this.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.enabled) {
                return;
            }
            this.enabled = true;
            this.statusPane.setText(TEMPLATE);
            this.setHeader(this.messages.getString("resultAreaText"));
            this.statusPane.addHyperlinkListener(this);
            this.ltSupport.addLanguageToolListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            this.statusPane.setText(TEMPLATE);
            this.statusPane.removeHyperlinkListener(this);
            this.ltSupport.removeLanguageToolListener(this);
        }
    }

    @Override
    public void languageToolEventOccurred(LanguageToolEvent event) {
        if (event.getType() == LanguageToolEvent.Type.CHECKING_STARTED) {
            Language lang = this.ltSupport.getLanguage();
            String langName = lang.isExternal() ? lang.getTranslatedName(this.messages) + " (ext.)" : lang.getTranslatedName(this.messages);
            String msg = org.languagetool.tools.Tools.i18n((ResourceBundle)this.messages, (String)"startChecking", (Object[])new Object[]{langName}) + "...";
            this.setHeader(msg);
            this.setMain(EMPTY_PARA);
            if (event.getCaller() == this) {
                this.statusPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else if (event.getType() == LanguageToolEvent.Type.CHECKING_FINISHED) {
            this.setRunTime(event.getElapsedTime());
            String inputText = event.getSource().getTextComponent().getText();
            this.displayResult(inputText, event.getSource().getMatches());
            if (event.getCaller() == this) {
                this.statusPane.setCursor(Cursor.getDefaultCursor());
            }
        } else if (event.getType() == LanguageToolEvent.Type.RULE_DISABLED || event.getType() == LanguageToolEvent.Type.RULE_ENABLED) {
            String inputText = event.getSource().getTextComponent().getText();
            this.displayResult(inputText, event.getSource().getMatches());
        }
    }

    private void setHeader(String txt) {
        HTMLDocument d = (HTMLDocument)this.statusPane.getDocument();
        Element e = d.getElement(HEADER);
        try {
            d.setInnerHTML(e, "<p class=\"grayed\">" + txt + "</p>");
        }
        catch (IOException | BadLocationException ex) {
            Tools.showError((Exception)ex);
        }
    }

    private void setMain(String html) {
        HTMLDocument d = (HTMLDocument)this.statusPane.getDocument();
        Element e = d.getElement(MAIN);
        try {
            d.setInnerHTML(e, html);
        }
        catch (IOException | BadLocationException ex) {
            Tools.showError((Exception)ex);
        }
    }

    private void appendMain(String html) {
        HTMLDocument d = (HTMLDocument)this.statusPane.getDocument();
        Element e = d.getElement(MAIN);
        try {
            d.insertBeforeEnd(e, html);
        }
        catch (IOException | BadLocationException ex) {
            Tools.showError((Exception)ex);
        }
    }

    private void getRuleMatchHtml(List<RuleMatch> ruleMatches, String text) {
        ContextTools contextTools = new ContextTools();
        StringBuilder sb = new StringBuilder(200);
        if (this.ltSupport.getLanguage().getMaintainedState() != LanguageMaintainedState.ActivelyMaintained) {
            sb.append("<p><b>").append(this.messages.getString("unsupportedWarning")).append("</b></p>\n");
        } else {
            sb.append(EMPTY_PARA);
        }
        this.setMain(sb.toString());
        sb.setLength(0);
        int i = 0;
        for (RuleMatch match : ruleMatches) {
            sb.append("<p>");
            String output = org.languagetool.tools.Tools.i18n((ResourceBundle)this.messages, (String)"result1", (Object[])new Object[]{i + 1, match.getLine() + 1, match.getColumn()});
            sb.append(output);
            String msg = match.getMessage().replaceAll("<suggestion>", "<b>").replaceAll("</suggestion>", "</b>").replaceAll("<old>", "<b>").replaceAll("</old>", "</b>");
            sb.append("<b>").append(this.messages.getString("errorMessage")).append("</b> ");
            sb.append(msg);
            RuleLink ruleLink = RuleLink.buildDeactivationLink(match.getRule());
            sb.append(" <a href=\"").append(ruleLink).append("\">").append(this.messages.getString("deactivateRule")).append("</a><br>\n");
            if (match.getSuggestedReplacements().size() > 0) {
                String replacement = String.join((CharSequence)"; ", match.getSuggestedReplacements());
                sb.append("<b>").append(this.messages.getString("correctionMessage")).append("</b> ").append(replacement).append("<br>\n");
            }
            if (ITSIssueType.Misspelling == match.getRule().getLocQualityIssueType()) {
                contextTools.setErrorMarkerStart(SPELL_ERROR_MARKER_START);
            } else {
                contextTools.setErrorMarkerStart(LT_ERROR_MARKER_START);
            }
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
            sb.append("<b>").append(this.messages.getString("errorContext")).append("</b> ").append(context);
            if ((match.getRule().getUrl() != null || match.getUrl() != null) && Desktop.isDesktopSupported()) {
                sb.append("<br>\n");
                sb.append("<b>").append(this.messages.getString("moreInfo")).append("</b> <a href=\"");
                String url = match.getUrl() != null ? match.getUrl().toString() : match.getRule().getUrl().toString();
                sb.append(url);
                String shortUrl = StringUtils.abbreviate((String)url, (int)60);
                sb.append("\">").append(shortUrl).append("</a>\n");
            }
            sb.append("</p>");
            ++i;
            this.appendMain(sb.toString());
            sb.setLength(0);
        }
        sb.append("<p class=\"grayed\">");
        sb.append(this.getDisabledRulesHtml());
        String checkDone = org.languagetool.tools.Tools.i18n((ResourceBundle)this.messages, (String)"checkDone", (Object[])new Object[]{ruleMatches.size(), this.runTime});
        sb.append("<br>\n").append(checkDone);
        sb.append("</p>");
        this.appendMain(sb.toString());
    }

    private String getDisabledRulesHtml() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.messages.getString("deactivatedRulesText"));
        int i = 0;
        int deactivatedRuleCount = 0;
        for (String ruleId : this.ltSupport.getConfig().getDisabledRuleIds()) {
            Rule rule;
            if (ruleId.trim().isEmpty() || (rule = this.ltSupport.getRuleForId(ruleId)) == null || rule.isDefaultOff()) continue;
            if (i++ > 0) {
                sb.append(',');
            }
            RuleLink reactivationLink = RuleLink.buildReactivationLink(rule);
            sb.append(" <a href=\"").append(reactivationLink).append("\">").append(rule.getDescription()).append("</a>");
            ++deactivatedRuleCount;
        }
        sb.append("<br>");
        if (deactivatedRuleCount == 0) {
            return "";
        }
        return sb.toString();
    }

    private void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    private void displayResult(String inputText, List<RuleMatch> matches) {
        List<RuleMatch> filtered = this.filterRuleMatches(matches);
        this.getRuleMatchHtml(filtered, inputText);
        this.statusPane.setCaretPosition(0);
    }

    private List<RuleMatch> filterRuleMatches(List<RuleMatch> matches) {
        ArrayList<RuleMatch> filtered = new ArrayList<RuleMatch>();
        Set disabledRuleIds = this.ltSupport.getConfig().getDisabledRuleIds();
        for (RuleMatch ruleMatch : matches) {
            if (disabledRuleIds.contains(ruleMatch.getRule().getId())) continue;
            filtered.add(ruleMatch);
        }
        return filtered;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            try {
                String uri = url.toURI().toString();
                if (uri.startsWith(DEACTIVATE_URL) || uri.startsWith(REACTIVATE_URL)) {
                    this.handleRuleLinkClick(uri);
                } else {
                    Tools.openURL((URL)url);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not handle URL click: " + url, ex);
            }
        }
    }

    private void handleRuleLinkClick(String uri) throws IOException {
        RuleLink ruleLink = RuleLink.getFromString(uri);
        String ruleId = ruleLink.getId();
        if (uri.startsWith(DEACTIVATE_URL)) {
            this.ltSupport.disableRule(ruleId);
        } else {
            this.ltSupport.enableRule(ruleId);
        }
        this.ltSupport.getConfig().saveConfiguration(this.ltSupport.getLanguage());
        this.ltSupport.checkImmediately(this);
    }
}

