/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import io.opentelemetry.api.common.Attributes;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.PremiumOff;
import org.languagetool.ResultCache;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.DictionaryMatchFilter;
import org.languagetool.rules.DictionarySpellMatchFilter;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.Pipeline;
import org.languagetool.server.PipelineSettings;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.tools.TelemetryProvider;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinePool
implements KeyedPooledObjectFactory<PipelineSettings, Pipeline> {
    private static final Logger logger = LoggerFactory.getLogger(PipelinePool.class);
    private final KeyedObjectPool<PipelineSettings, Pipeline> pool;
    private final HTTPServerConfig config;
    private final ResultCache cache;
    private final boolean internalServer;

    PipelinePool(HTTPServerConfig config, ResultCache cache, boolean internalServer) {
        this.internalServer = internalServer;
        this.config = config;
        this.cache = cache;
        int maxPoolSize = config.getMaxPipelinePoolSize();
        if (config.isPipelineCachingEnabled()) {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMaxTotal(maxPoolSize);
            poolConfig.setMaxIdlePerKey(maxPoolSize);
            poolConfig.setMaxTotalPerKey(maxPoolSize);
            poolConfig.setMinIdlePerKey(0);
            poolConfig.setBlockWhenExhausted(false);
            this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)this, poolConfig);
        } else {
            this.pool = null;
        }
    }

    Pipeline getPipeline(PipelineSettings settings) throws Exception {
        if (this.pool == null) {
            return this.createPipeline(settings.lang, settings.motherTongue, settings.query, settings.globalConfig, settings.userConfig, this.config.getDisabledRuleIds());
        }
        try {
            long time = System.currentTimeMillis();
            logger.debug("Requesting pipeline; pool has {} active objects, {} idle; pipeline settings: {}", new Object[]{this.pool.getNumActive(), this.pool.getNumIdle(), settings});
            Pipeline p = (Pipeline)((Object)this.pool.borrowObject((Object)settings));
            logger.debug("Fetching pipeline took {}ms; pool has {} active objects, {} idle; pipeline settings: {}", new Object[]{System.currentTimeMillis() - time, this.pool.getNumActive(), this.pool.getNumIdle(), settings});
            return p;
        }
        catch (NoSuchElementException ignored) {
            logger.info("Pipeline pool capacity reached: {} active objects, {} idle", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
            return this.createPipeline(settings.lang, settings.motherTongue, settings.query, settings.globalConfig, settings.userConfig, this.config.getDisabledRuleIds());
        }
    }

    void returnPipeline(PipelineSettings settings, Pipeline pipeline) throws Exception {
        if (this.pool == null) {
            return;
        }
        try {
            this.pool.returnObject((Object)settings, (Object)pipeline);
        }
        catch (IllegalStateException e) {
            logger.info("Exception while trying to return pipeline to pool; this is expected when pipeline capacity is reached", (Throwable)e);
        }
    }

    Pipeline createPipeline(Language lang, Language motherTongue, TextChecker.QueryParams params, GlobalConfig globalConfig, UserConfig userConfig, List<String> disabledRuleIds) throws Exception {
        Attributes attributes = Attributes.builder().put("text.language", lang.getShortCode()).put("check.premium", params.premium).put("check.mode", params.mode.name()).put("check.level", params.level.name()).build();
        return (Pipeline)((Object)TelemetryProvider.INSTANCE.createSpan("createPipeline", attributes, () -> {
            Pipeline lt = new Pipeline(lang, params.altLanguages, motherTongue, this.cache, globalConfig, userConfig, params.inputLogging);
            lt.setMaxErrorsPerWordRate(this.config.getMaxErrorsPerWordRate());
            lt.disableRules(disabledRuleIds);
            if (this.config.getLanguageModelDir() != null) {
                lt.activateLanguageModelRules(this.config.getLanguageModelDir());
            }
            if (this.config.getRulesConfigFile() != null) {
                this.configureFromRulesFile(lt, lang);
            } else {
                this.configureFromGUI(lt, lang);
            }
            if (params.regressionTestMode) {
                List<RemoteRuleConfig> rules = Collections.emptyList();
                try {
                    if (this.config.getRemoteRulesConfigFile() != null) {
                        rules = RemoteRuleConfig.load((File)this.config.getRemoteRulesConfigFile());
                    }
                }
                catch (Exception e) {
                    logger.error("Could not load remote rule configuration", (Throwable)e);
                }
                long timeout = Math.max(this.config.getMaxCheckTimeMillisAnonymous() - 1L, 0L);
                rules = rules.stream().map(c -> {
                    RemoteRuleConfig config = new RemoteRuleConfig(c);
                    config.baseTimeoutMilliseconds = timeout;
                    config.timeoutPerCharacterMilliseconds = 0.0f;
                    return config;
                }).collect(Collectors.toList());
                lt.activateRemoteRules(rules);
            } else {
                lt.activateRemoteRules(this.config.getRemoteRulesConfigFile());
            }
            if (params.useQuerySettings) {
                Tools.selectRules((JLanguageTool)lt, new HashSet<CategoryId>(params.disabledCategories), new HashSet<CategoryId>(params.enabledCategories), new HashSet<String>(params.disabledRules), new HashSet<String>(params.enabledRules), (boolean)params.useEnabledOnly, (boolean)params.enableTempOffRules);
            }
            if (userConfig.filterDictionaryMatches()) {
                lt.addMatchFilter((RuleMatchFilter)new DictionaryMatchFilter(userConfig));
            }
            lt.addMatchFilter((RuleMatchFilter)new DictionarySpellMatchFilter(userConfig));
            Premium premium = Premium.get();
            if (this.config.isPremiumOnly()) {
                int premiumEnabled = 0;
                int otherDisabled = 0;
                for (Rule rule : lt.getAllActiveRules()) {
                    if (premium.isPremiumRule(rule)) {
                        lt.enableRule(rule.getFullId());
                        ++premiumEnabled;
                        continue;
                    }
                    lt.disableRule(rule.getFullId());
                    ++otherDisabled;
                }
            } else if (!(params.premium || params.enableHiddenRules || premium instanceof PremiumOff)) {
                for (Rule rule : lt.getAllActiveRules()) {
                    if (!premium.isPremiumRule(rule)) continue;
                    lt.disableRule(rule.getFullId());
                }
            }
            if (this.pool != null) {
                lt.setupFinished();
            }
            return lt;
        }));
    }

    private void configureFromRulesFile(JLanguageTool lt, Language lang) throws IOException {
        ServerTools.print("Using options configured in " + this.config.getRulesConfigFile());
        if (this.config.getRulesConfigFile() == null) {
            throw new RuntimeException("config.getRulesConfigFile() is null");
        }
        org.languagetool.gui.Tools.configureFromRules((JLanguageTool)lt, (Configuration)new Configuration(this.config.getRulesConfigFile().getCanonicalFile().getParentFile(), this.config.getRulesConfigFile().getName(), lang));
    }

    private void configureFromGUI(JLanguageTool lt, Language lang) throws IOException {
        Configuration config = new Configuration(lang);
        if (this.internalServer && config.getUseGUIConfig()) {
            ServerTools.print("Using options configured in the GUI");
            org.languagetool.gui.Tools.configureFromRules((JLanguageTool)lt, (Configuration)config);
        }
    }

    public PooledObject<Pipeline> makeObject(PipelineSettings pipelineSettings) throws Exception {
        return new DefaultPooledObject((Object)this.createPipeline(pipelineSettings.lang, pipelineSettings.motherTongue, pipelineSettings.query, pipelineSettings.globalConfig, pipelineSettings.userConfig, this.config.getDisabledRuleIds()));
    }

    public void destroyObject(PipelineSettings pipelineSettings, PooledObject<Pipeline> pooledObject) throws Exception {
    }

    public boolean validateObject(PipelineSettings pipelineSettings, PooledObject<Pipeline> pooledObject) {
        return true;
    }

    public void activateObject(PipelineSettings pipelineSettings, PooledObject<Pipeline> pooledObject) throws Exception {
    }

    public void passivateObject(PipelineSettings pipelineSettings, PooledObject<Pipeline> pooledObject) throws Exception {
    }
}

