/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.codec.CRC16;
import io.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotHash {
    public static final byte SUBKEY_START = 123;
    public static final byte SUBKEY_END = 125;
    public static final int SLOT_COUNT = 16384;

    private SlotHash() {
    }

    public static int getSlot(String key) {
        return SlotHash.getSlot(key.getBytes());
    }

    public static int getSlot(byte[] key) {
        return SlotHash.getSlot(ByteBuffer.wrap(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSlot(ByteBuffer key) {
        int end;
        int limit = key.limit();
        int position = key.position();
        int start = SlotHash.indexOf(key, (byte)123);
        if (start != -1 && (end = SlotHash.indexOf(key, start + 1, (byte)125)) != -1 && end != start + 1) {
            key.position(start + 1).limit(end);
        }
        try {
            int n;
            if (key.hasArray()) {
                n = CRC16.crc16(key.array(), key.position(), key.limit() - key.position()) % 16384;
                return n;
            }
            n = CRC16.crc16(key) % 16384;
            return n;
        }
        finally {
            key.position(position).limit(limit);
        }
    }

    private static int indexOf(ByteBuffer haystack, byte needle) {
        return SlotHash.indexOf(haystack, haystack.position(), needle);
    }

    private static int indexOf(ByteBuffer haystack, int start, byte needle) {
        for (int i = start; i < haystack.remaining(); ++i) {
            if (haystack.get(i) != needle) continue;
            return i;
        }
        return -1;
    }

    public static <K, V> Map<Integer, List<K>> partition(RedisCodec<K, V> codec, Iterable<K> keys) {
        HashMap<Integer, List<Integer>> partitioned = new HashMap<Integer, List<Integer>>();
        for (K key : keys) {
            int slot = SlotHash.getSlot(codec.encodeKey(key));
            if (!partitioned.containsKey(slot)) {
                partitioned.put(slot, new ArrayList());
            }
            Collection list = (Collection)partitioned.get(slot);
            list.add(key);
        }
        return partitioned;
    }

    public static <S extends Number, K> Map<K, S> getSlots(Map<S, ? extends Iterable<K>> partitioned) {
        HashMap<K, S> result = new HashMap<K, S>();
        for (Map.Entry<S, Iterable<K>> entry : partitioned.entrySet()) {
            for (K key : entry.getValue()) {
                result.put(key, entry.getKey());
            }
        }
        return result;
    }
}

