/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.lifetime;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeToken;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0019R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRL\u0010\u0010\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0013*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00120\u0012 \u0013*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0013*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeTokenFactory;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "<init>", "()V", "identifier", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getIdentifier", "()Lkotlin/reflect/KClass;", "create", "project", "Lcom/intellij/openapi/project/Project;", "beforeEnteringAnalysisContext", "", "token", "afterLeavingAnalysisContext", "lifetimeOwnersStack", "Ljava/lang/ThreadLocal;", "Lkotlinx/collections/immutable/PersistentList;", "kotlin.jvm.PlatformType", "Ljava/lang/ThreadLocal;", "isInsideAnalysisContext", "", "isInsideAnalysisContext$analysis_api", "currentToken", "currentToken$analysis_api", "analysis-api"})
public final class KtReadActionConfinementLifetimeTokenFactory
extends KtLifetimeTokenFactory {
    @NotNull
    public static final KtReadActionConfinementLifetimeTokenFactory INSTANCE = new KtReadActionConfinementLifetimeTokenFactory();
    @NotNull
    private static final KClass<? extends KtLifetimeToken> identifier = Reflection.getOrCreateKotlinClass(KtReadActionConfinementLifetimeToken.class);
    private static final ThreadLocal<PersistentList<KtLifetimeToken>> lifetimeOwnersStack = ThreadLocal.withInitial(KtReadActionConfinementLifetimeTokenFactory::lifetimeOwnersStack$lambda$0);

    private KtReadActionConfinementLifetimeTokenFactory() {
    }

    @Override
    @NotNull
    public KClass<? extends KtLifetimeToken> getIdentifier() {
        return identifier;
    }

    @Override
    @NotNull
    public KtLifetimeToken create(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KtReadActionConfinementLifetimeToken(project);
    }

    @Override
    public void beforeEnteringAnalysisContext(@NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        lifetimeOwnersStack.set((PersistentList<KtLifetimeToken>)lifetimeOwnersStack.get().add((Object)token));
    }

    @Override
    public void afterLeavingAnalysisContext(@NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        PersistentList<KtLifetimeToken> stack = lifetimeOwnersStack.get();
        Intrinsics.checkNotNull(stack);
        KtLifetimeToken last = (KtLifetimeToken)CollectionsKt.last((List)((List)stack));
        if (!Intrinsics.areEqual((Object)last, (Object)token)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        lifetimeOwnersStack.set((PersistentList<KtLifetimeToken>)stack.removeAt(CollectionsKt.getLastIndex((List)((List)stack))));
    }

    public final boolean isInsideAnalysisContext$analysis_api() {
        PersistentList<KtLifetimeToken> persistentList = lifetimeOwnersStack.get();
        Intrinsics.checkNotNullExpressionValue(persistentList, (String)"get(...)");
        return !((Collection)persistentList).isEmpty();
    }

    @NotNull
    public final KtLifetimeToken currentToken$analysis_api() {
        PersistentList<KtLifetimeToken> persistentList = lifetimeOwnersStack.get();
        Intrinsics.checkNotNullExpressionValue(persistentList, (String)"get(...)");
        return (KtLifetimeToken)CollectionsKt.last((List)((List)persistentList));
    }

    private static final PersistentList lifetimeOwnersStack$lambda$0() {
        return ExtensionsKt.persistentListOf();
    }
}

