/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class DeltaCertificateRequestAttribute {
    private final X500Name subject;
    private final SubjectPublicKeyInfo subjectPKInfo;
    private final Extensions extensions;
    private final AlgorithmIdentifier signatureAlgorithm;

    public DeltaCertificateRequestAttribute(Attribute attribute) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.subject = X500Name.getInstance((ASN1TaggedObject)ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(0)), (boolean)true);
            ++n;
        } else {
            this.subject = null;
        }
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1Sequence.getObjectAt(n));
        Extensions extensions = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        if (++n != aSN1Sequence.size()) {
            while (n < aSN1Sequence.size()) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(n));
                if (aSN1TaggedObject.getTagNo() == 1) {
                    extensions = Extensions.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                } else if (aSN1TaggedObject.getTagNo() == 2) {
                    algorithmIdentifier = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                } else {
                    throw new IllegalArgumentException("unknown tag");
                }
                ++n;
            }
        }
        this.extensions = extensions;
        this.signatureAlgorithm = algorithmIdentifier;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPKInfo() {
        return this.subjectPKInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }
}

