/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.IOException;
import java.net.URL;
import org.jruby.Ruby;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class JarredScript
implements Library {
    private final LoadServiceResource resource;
    private final String searchName;

    public JarredScript(LoadServiceResource resource, String searchName) {
        this.resource = resource;
        this.searchName = searchName;
    }

    public LoadServiceResource getResource() {
        return this.resource;
    }

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        try {
            URL jarFile = this.resource.getURL();
            runtime2.getJRubyClassLoader().addURL(jarFile);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        ClassExtensionLibrary serviceExtension = ClassExtensionLibrary.tryFind(runtime2, this.searchName);
        if (serviceExtension != null) {
            serviceExtension.load(runtime2, wrap2);
        }
    }
}

