/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import jakarta.json.JsonException;
import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Parameters;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class JosmPreferencesCredentialAgent
extends AbstractCredentialsAgent {
    @Override
    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String host) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String password;
                String user;
                if (Objects.equals(OsmApi.getOsmApi().getHost(), host)) {
                    user = Config.getPref().get("osm-server.username", null);
                    password = Config.getPref().get("osm-server.password", null);
                } else if (host != null) {
                    user = Config.getPref().get("server.username." + host, null);
                    password = Config.getPref().get("server.password." + host, null);
                } else {
                    user = null;
                    password = null;
                }
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
            case PROXY: {
                String user = Config.getPref().get("proxy.user", null);
                String password = Config.getPref().get("proxy.pass", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
        }
        return null;
    }

    @Override
    public void store(Authenticator.RequestorType requestorType, String host, PasswordAuthentication credentials) throws CredentialsAgentException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                if (Objects.equals(OsmApi.getOsmApi().getHost(), host)) {
                    Config.getPref().put("osm-server.username", credentials.getUserName());
                    if (credentials.getPassword().length == 0) {
                        Config.getPref().put("osm-server.password", null);
                        break;
                    }
                    Config.getPref().put("osm-server.password", String.valueOf(credentials.getPassword()));
                    break;
                }
                if (host == null) break;
                Config.getPref().put("server.username." + host, credentials.getUserName());
                if (credentials.getPassword().length == 0) {
                    Config.getPref().put("server.password." + host, null);
                    break;
                }
                Config.getPref().put("server.password." + host, String.valueOf(credentials.getPassword()));
                break;
            }
            case PROXY: {
                Config.getPref().put("proxy.user", credentials.getUserName());
                if (credentials.getPassword().length == 0) {
                    Config.getPref().put("proxy.pass", null);
                    break;
                }
                Config.getPref().put("proxy.pass", String.valueOf(credentials.getPassword()));
            }
        }
    }

    @Override
    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        String accessTokenKey = Config.getPref().get("oauth.access-token.key", null);
        String accessTokenSecret = Config.getPref().get("oauth.access-token.secret", null);
        if (accessTokenKey == null && accessTokenSecret == null) {
            return null;
        }
        return new OAuthToken(accessTokenKey, accessTokenSecret);
    }

    @Override
    public IOAuthToken lookupOAuthAccessToken(String host) throws CredentialsAgentException {
        HashSet<String> keySet = new HashSet<String>(Config.getPref().getKeySet());
        keySet.addAll(Config.getPref().getSensitive());
        for (OAuthVersion oauthType : OAuthVersion.values()) {
            String hostKey = "oauth.access-token.object." + (Object)((Object)oauthType) + "." + host;
            String parametersKey = "oauth.access-token.parameters." + (Object)((Object)oauthType) + "." + host;
            if (!keySet.contains(hostKey) || !keySet.contains(parametersKey)) continue;
            String token = Config.getPref().get(hostKey, null);
            String parameters = Config.getPref().get(parametersKey, null);
            if (Utils.isBlank(token) || Utils.isBlank(parameters) || OAuthVersion.OAuth20 != oauthType) continue;
            try {
                OAuth20Parameters oAuth20Parameters = new OAuth20Parameters(parameters);
                return new OAuth20Token((IOAuthParameters)oAuth20Parameters, token);
            }
            catch (JsonException | OAuth20Exception e) {
                throw new CredentialsAgentException(e);
            }
        }
        return null;
    }

    @Override
    public void storeOAuthAccessToken(OAuthToken accessToken) throws CredentialsAgentException {
        if (accessToken == null) {
            Config.getPref().put("oauth.access-token.key", null);
            Config.getPref().put("oauth.access-token.secret", null);
        } else {
            Config.getPref().put("oauth.access-token.key", accessToken.getKey());
            Config.getPref().put("oauth.access-token.secret", accessToken.getSecret());
        }
    }

    @Override
    public void storeOAuthAccessToken(String host, IOAuthToken accessToken) throws CredentialsAgentException {
        Objects.requireNonNull(host, "host");
        if (accessToken == null) {
            HashSet<String> keySet = new HashSet<String>(Config.getPref().getKeySet());
            keySet.addAll(Config.getPref().getSensitive());
            for (OAuthVersion oauthType : OAuthVersion.values()) {
                String hostKey = "oauth.access-token.parameters." + (Object)((Object)oauthType) + "." + host;
                String parametersKey = "oauth.access-token.parameters." + (Object)((Object)oauthType) + "." + host;
                if (keySet.contains(hostKey)) {
                    Config.getPref().removeSensitive(hostKey);
                }
                if (!keySet.contains(parametersKey)) continue;
                Config.getPref().removeSensitive(parametersKey);
            }
        } else {
            String hostKey = "oauth.access-token.object." + (Object)((Object)accessToken.getOAuthType()) + "." + host;
            String parametersKey = "oauth.access-token.parameters." + (Object)((Object)accessToken.getOAuthType()) + "." + host;
            Config.getPref().put(hostKey, accessToken.toPreferencesString());
            Config.getPref().put(parametersKey, accessToken.getParameters().toPreferencesString());
            Config.getPref().addSensitive(this, hostKey);
            Config.getPref().addSensitive(this, parametersKey);
        }
    }

    @Override
    public Component getPreferencesDecorationPanel() {
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        pnlMessage.setText(I18n.tr("<html><body><p class=\"warning-body\"><strong>Note:</strong> The password is stored in plain text in the JOSM preferences file on your computer. </p></body></html>", new Object[0]));
        return pnlMessage;
    }

    @Override
    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr("Save user and password (unencrypted)", new Object[0]);
    }
}

