# NOTE: Derived from blib/lib/Text/Vpp.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Text::Vpp;

#line 1064 "blib/lib/Text/Vpp.pm (autosplit into blib/lib/auto/Text/Vpp/setActionChar.al)"
sub setActionChar
  {
    my ($self,$action) = @_ ;
    
    $self->{action} 	= $action ;
    $self->{ifPat} 		= qr/^\s*\Q$action\Eif(?=\W)\s*/i;
    $self->{elsePat} 	= qr/^\s*\Q$action\Eelse\s*/i;
    $self->{elsifPat} 	= qr/^\s*\Q$action\Eelsif(?=\W)\s*/i;
    $self->{endifPat} 	= qr/^\s*\Q$action\Eendif\s*/i;
    $self->{includePat} 	= qr/^\s*\Q$action\Einclude(?=\W)\s*/i;
    $self->{evalPat} 	= qr/^\s*\Q$action\Eeval(?=\W)\s*/i;
    $self->{quotePat} 	= qr/^\s*\Q$action\Equote\s*/i;
    $self->{endquotePat} 	= qr/^\Q$action\Eendquote\s*/i;
    $self->{foreachPat} 	= qr/^\s*\Q$action\Eforeach(?=\W)\s*/i;
    $self->{endforPat} 	= qr/^\s*\Q$action\Eendfor\s*/i;
    $self->{perlPat}        = qr/^\s*\Q$action\Eperl\s+<<\s*/i;
    $self->{shellPat}        = qr/^\s*\Q$action\Eshell\s*/i;
    $self->{actionPat} 	= qr/^\s*\Q$action\E\w/; # unknown action
    $self->setSubstitute(undef)  unless defined $self->{substitute}
  }


# end of Text::Vpp::setActionChar
1;
