/*
 * Decompiled with CFR 0.152.
 */
package groovy.toml;

import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.groovy.lang.annotation.Incubating;
import org.apache.groovy.toml.util.TomlConverter;

@Incubating
public class TomlSlurper {
    private final JsonSlurper jsonSlurper = new JsonSlurper();

    public Object parseText(String toml) {
        return this.parse(new StringReader(toml));
    }

    public Object parse(Reader reader) {
        return this.jsonSlurper.parse((Reader)new StringReader(TomlConverter.convertTomlToJson(reader)));
    }

    public Object parse(InputStream stream) {
        return this.parse(new InputStreamReader(stream));
    }

    public Object parse(File file) throws IOException {
        return this.parse(file.toPath());
    }

    public Object parse(Path path) throws IOException {
        return this.parse(Files.newInputStream(path, new OpenOption[0]));
    }
}

