/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.J2SEAppController;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import gps.GpsEvent;
import gps.convert.ExternalUtils;
import gps.convert.FileUtil;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import net.sf.bt747.j2se.app.filefilters.BinFileFilter;
import net.sf.bt747.j2se.app.filefilters.CSVFileFilter;
import net.sf.bt747.j2se.app.filefilters.GPXFileFilter;
import net.sf.bt747.j2se.app.filefilters.HoluxTRLFileFilter;
import net.sf.bt747.j2se.app.filefilters.KnownFileFilter;
import net.sf.bt747.j2se.app.filefilters.NMEAFileFilter;
import net.sf.bt747.j2se.app.filefilters.ResultFileFilter;
import net.sf.bt747.j2se.app.filefilters.WPFileFilter;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;

public final class LogOperationsPanel
extends JPanel
implements ModelListener {
    private Model m;
    private J2SEAppController c;
    private static final ComboBoxModel modelGpsType = new DefaultComboBoxModel<String>(new String[]{""});
    private long conversionStartTime;
    private JPanel GPSDecodePanel;
    private JButton btCSV;
    private JButton btConvert;
    private JButton btDownload;
    private JButton btGPX;
    private JButton btGUI;
    private JButton btHTML;
    private JButton btKML;
    private JButton btKMZ;
    private JButton btNMEA;
    private JButton btOSMUp;
    private JButton btOTHERFmt;
    private JButton btOutputFile;
    private JButton btRawLogFile;
    private JButton btWorkingDirectory;
    private JCheckBox cbDisableLoggingDuringDownload;
    private JComboBox cbDownloadMethod;
    private JComboBox cbFormat;
    private JComboBox cbGPSType;
    private JCheckBox cbLoggingActive;
    private JXDatePicker endDate;
    private JXBusyLabel lbBusySpinner;
    private JLabel lbConversionTime;
    private JLabel lbDeviceType;
    private JLabel lbFirmWare;
    private JLabel lbFlashInfo;
    private JLabel lbFromDate;
    private JLabel lbGeoid;
    private JLabel lbHour;
    private JLabel lbLatitude;
    private JLabel lbLoggerSWversion;
    private JLabel lbLongitude;
    private JLabel lbMemoryUsed;
    private JLabel lbMinutes;
    private JLabel lbModel;
    private JLabel lbNoFileExt;
    private JLabel lbTime;
    private JLabel lbToDate;
    private JPanel pnConvButtons;
    private JPanel pnConvert;
    private JPanel pnDateFilter;
    private JPanel pnDownload;
    private JPanel pnDownloadMethod;
    private JPanel pnFiles;
    private JPanel pnLeftConversion;
    private JSpinner spTimeSplitHours;
    private JSpinner spTimeSplitMinutes;
    private JXDatePicker startDate;
    private JTextField tfOutputFileBaseName;
    private JTextField tfRawLogFilePath;
    private JTextField tfWorkDirectory;
    private JLabel txtFirmWare;
    private JLabel txtFlashInfo;
    private JLabel txtGeoid;
    private JLabel txtLatitude;
    private JLabel txtLoggerSWVersion;
    private JLabel txtLongitude;
    private JLabel txtMemoryUsed;
    private JLabel txtModel;
    private JLabel txtTime;
    private JLabel txtTimeSplit;

    public LogOperationsPanel() {
        LogOperationsPanel logOperationsPanel = this;
        this.pnFiles = new JPanel();
        logOperationsPanel.tfWorkDirectory = new JTextField();
        logOperationsPanel.tfRawLogFilePath = new JTextField();
        logOperationsPanel.tfOutputFileBaseName = new JTextField();
        logOperationsPanel.btWorkingDirectory = new JButton();
        logOperationsPanel.btRawLogFile = new JButton();
        logOperationsPanel.btOutputFile = new JButton();
        logOperationsPanel.lbNoFileExt = new JLabel();
        logOperationsPanel.pnDownload = new JPanel();
        logOperationsPanel.pnDownloadMethod = new JPanel();
        logOperationsPanel.cbDisableLoggingDuringDownload = new JCheckBox();
        logOperationsPanel.cbDownloadMethod = new JComboBox();
        logOperationsPanel.btDownload = new JButton();
        logOperationsPanel.pnConvert = new JPanel();
        logOperationsPanel.pnLeftConversion = new JPanel();
        logOperationsPanel.lbConversionTime = new JLabel();
        logOperationsPanel.lbDeviceType = new JLabel();
        logOperationsPanel.btConvert = new JButton();
        logOperationsPanel.pnDateFilter = new JPanel();
        logOperationsPanel.lbToDate = new JLabel();
        logOperationsPanel.lbFromDate = new JLabel();
        logOperationsPanel.lbHour = new JLabel();
        logOperationsPanel.txtTimeSplit = new JLabel();
        logOperationsPanel.lbMinutes = new JLabel();
        logOperationsPanel.startDate = new JXDatePicker();
        logOperationsPanel.endDate = new JXDatePicker();
        logOperationsPanel.spTimeSplitHours = new JSpinner();
        logOperationsPanel.spTimeSplitMinutes = new JSpinner();
        logOperationsPanel.cbFormat = new JComboBox();
        logOperationsPanel.lbBusySpinner = new JXBusyLabel();
        logOperationsPanel.cbGPSType = new JComboBox();
        logOperationsPanel.pnConvButtons = new JPanel();
        logOperationsPanel.btGPX = new JButton();
        logOperationsPanel.btKML = new JButton();
        logOperationsPanel.btKMZ = new JButton();
        logOperationsPanel.btNMEA = new JButton();
        logOperationsPanel.btHTML = new JButton();
        logOperationsPanel.btCSV = new JButton();
        logOperationsPanel.btGUI = new JButton();
        logOperationsPanel.btOTHERFmt = new JButton();
        logOperationsPanel.btOSMUp = new JButton();
        logOperationsPanel.GPSDecodePanel = new JPanel();
        logOperationsPanel.lbLatitude = new JLabel();
        logOperationsPanel.lbLongitude = new JLabel();
        logOperationsPanel.lbTime = new JLabel();
        logOperationsPanel.txtLatitude = new JLabel();
        logOperationsPanel.txtLongitude = new JLabel();
        logOperationsPanel.txtTime = new JLabel();
        logOperationsPanel.lbGeoid = new JLabel();
        logOperationsPanel.txtGeoid = new JLabel();
        logOperationsPanel.lbFlashInfo = new JLabel();
        logOperationsPanel.txtFlashInfo = new JLabel();
        logOperationsPanel.lbModel = new JLabel();
        logOperationsPanel.txtModel = new JLabel();
        logOperationsPanel.lbFirmWare = new JLabel();
        logOperationsPanel.txtFirmWare = new JLabel();
        logOperationsPanel.lbLoggerSWversion = new JLabel();
        logOperationsPanel.lbMemoryUsed = new JLabel();
        logOperationsPanel.txtLoggerSWVersion = new JLabel();
        logOperationsPanel.txtMemoryUsed = new JLabel();
        logOperationsPanel.cbLoggingActive = new JCheckBox();
        logOperationsPanel.setName("BT747Frame");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("bt747/j2se_view/Bundle");
        logOperationsPanel.pnFiles.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.pnFiles.border.title")));
        logOperationsPanel.tfWorkDirectory.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.c.setStringOpt(9, new File(this.this$0.tfWorkDirectory.getText()).getPath());
            }
        });
        logOperationsPanel.tfRawLogFilePath.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.c.setStringOpt(12, this.this$0.tfRawLogFilePath.getText());
            }
        });
        logOperationsPanel.tfOutputFileBaseName.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.c.setOutputFileRelPath(this.this$0.tfOutputFileBaseName.getText());
            }
        });
        logOperationsPanel.btWorkingDirectory.setText(resourceBundle.getString("BT747Main.btWorkingDirectory.text"));
        logOperationsPanel.btWorkingDirectory.setToolTipText(resourceBundle.getString("BT747Main.btWorkingDirectory.toolTipText"));
        logOperationsPanel.btWorkingDirectory.setHorizontalAlignment(4);
        logOperationsPanel.btWorkingDirectory.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$300$31487302(this.this$0);
            }
        });
        logOperationsPanel.btRawLogFile.setText(resourceBundle.getString("BT747Main.btRawLogFile.text"));
        logOperationsPanel.btRawLogFile.setToolTipText(resourceBundle.getString("BT747Main.btRawLogFile.toolTipText"));
        logOperationsPanel.btRawLogFile.setHorizontalAlignment(4);
        logOperationsPanel.btRawLogFile.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$400$31487302(this.this$0);
            }
        });
        logOperationsPanel.btOutputFile.setText(resourceBundle.getString("BT747Main.btOutputFile.text"));
        logOperationsPanel.btOutputFile.setToolTipText(resourceBundle.getString("BT747Main.btOutputFile.toolTipText"));
        logOperationsPanel.btOutputFile.setHorizontalAlignment(4);
        logOperationsPanel.btOutputFile.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$500$31487302(this.this$0);
            }
        });
        logOperationsPanel.lbNoFileExt.setText(resourceBundle.getString("BT747Main.lbNoFileExt.text"));
        GroupLayout groupLayout = new GroupLayout((Container)logOperationsPanel.pnFiles);
        logOperationsPanel.pnFiles.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)logOperationsPanel.btRawLogFile).add((Component)logOperationsPanel.btWorkingDirectory).add((Component)logOperationsPanel.btOutputFile)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)logOperationsPanel.tfRawLogFilePath, -1, 335, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.tfOutputFileBaseName, -1, 209, Short.MAX_VALUE).addPreferredGap(0).add((Component)logOperationsPanel.lbNoFileExt)).add((Component)logOperationsPanel.tfWorkDirectory, -1, 335, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)logOperationsPanel.tfRawLogFilePath, -2, -1, -2).add((Component)logOperationsPanel.btRawLogFile)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)logOperationsPanel.btWorkingDirectory).add((Component)logOperationsPanel.tfWorkDirectory, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)logOperationsPanel.lbNoFileExt).add((Component)logOperationsPanel.btOutputFile).add((Component)logOperationsPanel.tfOutputFileBaseName, -2, -1, -2)).addContainerGap()));
        logOperationsPanel.pnDownload.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.pnDownload.border.title")));
        logOperationsPanel.pnDownloadMethod.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.pnDownloadMethod.border.title")));
        logOperationsPanel.cbDisableLoggingDuringDownload.setText(resourceBundle.getString("BT747Main.cbDisableLoggingDuringDownload.text"));
        logOperationsPanel.cbDisableLoggingDuringDownload.setToolTipText(resourceBundle.getString("BT747Main.cbDisableLoggingDuringDownload.toolTipText"));
        logOperationsPanel.cbDisableLoggingDuringDownload.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.c.setBooleanOpt(24, this.this$0.cbDisableLoggingDuringDownload.isSelected());
            }
        });
        logOperationsPanel.cbDownloadMethod.setToolTipText(resourceBundle.getString("BT747Main.cbDownloadMethod.toolTipText"));
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnDownloadMethod);
        logOperationsPanel.pnDownloadMethod.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)logOperationsPanel.cbDisableLoggingDuringDownload).add((Component)logOperationsPanel.cbDownloadMethod, -2, -1, -2));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.cbDownloadMethod, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)logOperationsPanel.cbDisableLoggingDuringDownload)));
        logOperationsPanel.btDownload.setText(resourceBundle.getString("LogOperationsPanel.btDownload.text"));
        logOperationsPanel.btDownload.setToolTipText(resourceBundle.getString("LogOperationsPanel.btDownload.toolTipText"));
        logOperationsPanel.btDownload.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$700$31487302(this.this$0);
            }
        });
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnDownload);
        logOperationsPanel.pnDownload.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.pnDownloadMethod, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.btDownload)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)logOperationsPanel.pnDownloadMethod, -2, -1, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)logOperationsPanel.btDownload)));
        logOperationsPanel.pnConvert.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.pnConvert.border.title")));
        logOperationsPanel.lbConversionTime.setText(resourceBundle.getString("BT747Main.lbConversionTime.text"));
        logOperationsPanel.lbConversionTime.setToolTipText(resourceBundle.getString("BT747Main.lbConversionTime.toolTipText"));
        logOperationsPanel.lbDeviceType.setText(resourceBundle.getString("BT747Main.lbDeviceType.text"));
        logOperationsPanel.btConvert.setText(resourceBundle.getString("BT747Main.btConvert.text"));
        logOperationsPanel.btConvert.setToolTipText(resourceBundle.getString("BT747Main.btConvert.toolTipText"));
        logOperationsPanel.btConvert.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$800$31487302(this.this$0);
            }
        });
        logOperationsPanel.pnDateFilter.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.pnDateFilter.border.title")));
        logOperationsPanel.lbToDate.setText(resourceBundle.getString("BT747Main.lbToDate.text"));
        logOperationsPanel.lbFromDate.setText(resourceBundle.getString("BT747Main.lbFromDate.text"));
        logOperationsPanel.lbHour.setText(resourceBundle.getString("BT747Main.lbHour.text"));
        logOperationsPanel.txtTimeSplit.setText(resourceBundle.getString("BT747Main.txtTimeSplit.text"));
        logOperationsPanel.txtTimeSplit.setToolTipText(resourceBundle.getString("BT747Main.txtTimeSplit.toolTipText"));
        logOperationsPanel.lbMinutes.setText(resourceBundle.getString("BT747Main.lbMinutes.text"));
        logOperationsPanel.startDate.setToolTipText(resourceBundle.getString("BT747Main.startDate.toolTipText"));
        logOperationsPanel.startDate.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$900(this.this$0, actionEvent);
            }
        });
        logOperationsPanel.endDate.setToolTipText(resourceBundle.getString("BT747Main.endDate.toolTipText"));
        logOperationsPanel.endDate.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                LogOperationsPanel.access$1000(this.this$0, actionEvent);
            }
        });
        logOperationsPanel.spTimeSplitHours.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        logOperationsPanel.spTimeSplitHours.setToolTipText(resourceBundle.getString("BT747Main.spTimeSplitHours.toolTipText"));
        logOperationsPanel.spTimeSplitHours.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.setTimeSplit();
            }
        });
        logOperationsPanel.spTimeSplitMinutes.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        logOperationsPanel.spTimeSplitMinutes.setToolTipText(resourceBundle.getString("BT747Main.spTimeSplitMinutes.toolTipText"));
        logOperationsPanel.spTimeSplitMinutes.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.setTimeSplit();
            }
        });
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnDateFilter);
        logOperationsPanel.pnDateFilter.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.lbFromDate).addPreferredGap(0).add((Component)logOperationsPanel.startDate, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.lbToDate).add(4, 4, 4).add((Component)logOperationsPanel.endDate, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.txtTimeSplit).add(4, 4, 4).add((Component)logOperationsPanel.spTimeSplitHours, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.lbHour, -2, 12, -2).addPreferredGap(0).add((Component)logOperationsPanel.spTimeSplitMinutes, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.lbMinutes)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)logOperationsPanel.lbFromDate).add((Component)logOperationsPanel.startDate, -2, -1, -2).add((Component)logOperationsPanel.lbToDate).add((Component)logOperationsPanel.endDate, -2, -1, -2).add((Component)logOperationsPanel.txtTimeSplit).add((Component)logOperationsPanel.spTimeSplitHours, -2, -1, -2).add((Component)logOperationsPanel.lbHour).add((Component)logOperationsPanel.spTimeSplitMinutes, -2, -1, -2).add((Component)logOperationsPanel.lbMinutes)));
        logOperationsPanel.cbFormat.setToolTipText(resourceBundle.getString("BT747Main.cbFormat.toolTipText"));
        logOperationsPanel.cbFormat.addItemListener(new ItemListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void itemStateChanged(ItemEvent itemEvent) {
                itemEvent.getStateChange();
            }
        });
        logOperationsPanel.lbBusySpinner.setText(resourceBundle.getString("BT747Main.lbBusySpinner.text"));
        logOperationsPanel.lbBusySpinner.setOpaque(true);
        logOperationsPanel.cbGPSType.setModel(modelGpsType);
        logOperationsPanel.cbGPSType.setToolTipText(resourceBundle.getString("BT747Main.cbGPSType.toolTipText"));
        logOperationsPanel.cbGPSType.addFocusListener(new FocusAdapter(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                LogOperationsPanel.access$1400$e7e0e68(this.this$0);
            }
        });
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnLeftConversion);
        logOperationsPanel.pnLeftConversion.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.lbBusySpinner, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.btConvert).addPreferredGap(0).add((Component)logOperationsPanel.cbFormat, -2, -1, -2).addPreferredGap(1).add((Component)logOperationsPanel.lbDeviceType).addPreferredGap(0).add((Component)logOperationsPanel.cbGPSType, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.lbConversionTime)).add((Component)logOperationsPanel.pnDateFilter, -2, -1, -2));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.pnDateFilter, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)logOperationsPanel.btConvert).add((Component)logOperationsPanel.cbFormat, -2, -1, -2).add((Component)logOperationsPanel.lbDeviceType).add((Component)logOperationsPanel.cbGPSType, -2, -1, -2).add((Component)logOperationsPanel.lbConversionTime)).add((Component)logOperationsPanel.lbBusySpinner, -2, -1, -2))));
        logOperationsPanel.btGPX.setText(resourceBundle.getString("BT747Main.btGPX.text"));
        logOperationsPanel.btGPX.setToolTipText(resourceBundle.getString("BT747Main.btGPX.toolTipText"));
        logOperationsPanel.btGPX.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(3);
            }
        });
        logOperationsPanel.btKML.setText(resourceBundle.getString("BT747Main.btKML.text"));
        logOperationsPanel.btKML.setToolTipText(resourceBundle.getString("BT747Main.btKML.toolTipText"));
        logOperationsPanel.btKML.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(4);
            }
        });
        logOperationsPanel.btKMZ.setText(resourceBundle.getString("BT747Main.btKMZ.text"));
        logOperationsPanel.btKMZ.setToolTipText(resourceBundle.getString("BT747Main.btKMZ.toolTipText"));
        logOperationsPanel.btKMZ.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(11);
            }
        });
        logOperationsPanel.btNMEA.setText(resourceBundle.getString("BT747Main.btNMEA.text"));
        logOperationsPanel.btNMEA.setToolTipText(resourceBundle.getString("BT747Main.btNMEA.toolTipText"));
        logOperationsPanel.btNMEA.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(5);
            }
        });
        logOperationsPanel.btHTML.setText(resourceBundle.getString("BT747Main.btHTML.text"));
        logOperationsPanel.btHTML.setToolTipText(resourceBundle.getString("BT747Main.btHTML.toolTipText"));
        logOperationsPanel.btHTML.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(2);
            }
        });
        logOperationsPanel.btCSV.setText(resourceBundle.getString("BT747Main.btCSV.text"));
        logOperationsPanel.btCSV.setToolTipText(resourceBundle.getString("BT747Main.btCSV.toolTipText"));
        logOperationsPanel.btCSV.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(1);
            }
        });
        logOperationsPanel.btGUI.setText(resourceBundle.getString("LogOperationsPanel.btGUI.text"));
        logOperationsPanel.btGUI.setToolTipText(resourceBundle.getString("LogOperationsPanel.btGUI.toolTipText"));
        logOperationsPanel.btGUI.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(12);
            }
        });
        logOperationsPanel.btOTHERFmt.setText(resourceBundle.getString("LogOperationsPanel.btOTHERFmt.text"));
        logOperationsPanel.btOTHERFmt.setToolTipText(resourceBundle.getString("LogOperationsPanel.btOTHERFmt.toolTipText"));
        logOperationsPanel.btOTHERFmt.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(16);
            }
        });
        logOperationsPanel.btOSMUp.setText(resourceBundle.getString("LogOperationsPanel.btOSMUp.text"));
        logOperationsPanel.btOSMUp.setToolTipText(resourceBundle.getString("LogOperationsPanel.btOSMUp.toolTipText"));
        logOperationsPanel.btOSMUp.addActionListener(new ActionListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doLogConversion(15);
            }
        });
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnConvButtons);
        logOperationsPanel.pnConvButtons.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)logOperationsPanel.btGPX).add((Component)logOperationsPanel.btKML).add((Component)logOperationsPanel.btKMZ)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)logOperationsPanel.btCSV).add((Component)logOperationsPanel.btHTML).add((Component)logOperationsPanel.btNMEA)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)logOperationsPanel.btOSMUp).add(2, (Component)logOperationsPanel.btGUI).add(2, (Component)logOperationsPanel.btOTHERFmt)).add(0, 0, 0)));
        groupLayout.linkSize(new Component[]{logOperationsPanel.btCSV, logOperationsPanel.btGPX, logOperationsPanel.btHTML, logOperationsPanel.btKML, logOperationsPanel.btKMZ, logOperationsPanel.btNMEA}, 1);
        groupLayout.linkSize(new Component[]{logOperationsPanel.btGUI, logOperationsPanel.btOSMUp, logOperationsPanel.btOTHERFmt}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.btGPX).add(0, 0, 0).add((Component)logOperationsPanel.btKML).add(0, 0, 0).add((Component)logOperationsPanel.btKMZ)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.btCSV).add(0, 0, 0).add((Component)logOperationsPanel.btHTML).add(0, 0, 0).add((Component)logOperationsPanel.btNMEA)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.btOSMUp).add(0, 0, 0).add((Component)logOperationsPanel.btGUI).add(0, 0, 0).add((Component)logOperationsPanel.btOTHERFmt)));
        groupLayout = new GroupLayout((Container)logOperationsPanel.pnConvert);
        logOperationsPanel.pnConvert.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)logOperationsPanel.pnConvButtons, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.pnLeftConversion, -2, -1, -2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)logOperationsPanel.pnConvButtons, -2, -1, -2).add((Component)logOperationsPanel.pnLeftConversion, -2, -1, -2)).add(0, 0, 0)));
        logOperationsPanel.GPSDecodePanel.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("BT747Main.GPSDecodePanel.border.title")));
        logOperationsPanel.lbLatitude.setText(resourceBundle.getString("BT747Main.lbLatitude.text"));
        logOperationsPanel.lbLongitude.setText(resourceBundle.getString("BT747Main.lbLongitude.text"));
        logOperationsPanel.lbTime.setText(resourceBundle.getString("BT747Main.lbTime.text"));
        logOperationsPanel.txtLatitude.setText(resourceBundle.getString("BT747Main.txtLatitude.text"));
        logOperationsPanel.txtLongitude.setText(resourceBundle.getString("BT747Main.txtLongitude.text"));
        logOperationsPanel.txtTime.setText(resourceBundle.getString("BT747Main.txtTime.text"));
        logOperationsPanel.lbGeoid.setText(resourceBundle.getString("BT747Main.lbGeoid.text"));
        logOperationsPanel.txtGeoid.setText(resourceBundle.getString("BT747Main.txtGeoid.text"));
        logOperationsPanel.lbFlashInfo.setText(resourceBundle.getString("BT747Main.lbFlashInfo.text"));
        logOperationsPanel.txtFlashInfo.setText(resourceBundle.getString("BT747Main.txtFlashInfo.text"));
        logOperationsPanel.txtFlashInfo.setToolTipText(resourceBundle.getString("BT747Main.txtFlashInfo.toolTipText"));
        logOperationsPanel.lbModel.setText(resourceBundle.getString("BT747Main.lbModel.text"));
        logOperationsPanel.txtModel.setText(resourceBundle.getString("BT747Main.txtModel.text"));
        logOperationsPanel.lbFirmWare.setText(resourceBundle.getString("BT747Main.lbFirmWare.text"));
        logOperationsPanel.txtFirmWare.setText(resourceBundle.getString("BT747Main.txtFirmWare.text"));
        logOperationsPanel.lbLoggerSWversion.setText(resourceBundle.getString("BT747Main.lbLoggerSWversion.text"));
        logOperationsPanel.lbMemoryUsed.setText(resourceBundle.getString("BT747Main.lbMemoryUsed.text"));
        logOperationsPanel.txtLoggerSWVersion.setText(resourceBundle.getString("BT747Main.txtLoggerSWVersion.text"));
        logOperationsPanel.txtLoggerSWVersion.setToolTipText(resourceBundle.getString("BT747Main.txtLoggerSWVersion.toolTipText"));
        logOperationsPanel.txtMemoryUsed.setText(resourceBundle.getString("BT747Main.txtMemoryUsed.text"));
        logOperationsPanel.cbLoggingActive.setText(resourceBundle.getString("BT747Main.cbLoggingActive.text"));
        logOperationsPanel.cbLoggingActive.setToolTipText(resourceBundle.getString("BT747Main.cbLoggingActive.toolTipText"));
        logOperationsPanel.cbLoggingActive.addItemListener(new ItemListener(logOperationsPanel){
            private /* synthetic */ LogOperationsPanel this$0;
            {
                this.this$0 = logOperationsPanel;
            }

            @Override
            public final void itemStateChanged(ItemEvent itemEvent) {
                LogOperationsPanel.access$2400(this.this$0, itemEvent);
            }
        });
        resourceBundle = new GroupLayout((Container)logOperationsPanel.GPSDecodePanel);
        logOperationsPanel.GPSDecodePanel.setLayout((LayoutManager)((Object)resourceBundle));
        resourceBundle.setHorizontalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().addContainerGap().add((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((Component)logOperationsPanel.lbFlashInfo).add((Component)logOperationsPanel.lbModel).add((Component)logOperationsPanel.lbFirmWare).add((Component)logOperationsPanel.lbMemoryUsed).add((Component)logOperationsPanel.lbLoggerSWversion).add((Component)logOperationsPanel.lbLatitude).add((Component)logOperationsPanel.lbLongitude).add((Component)logOperationsPanel.lbTime).add((Component)logOperationsPanel.lbGeoid)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(2).add(1, (Component)logOperationsPanel.txtMemoryUsed).add(1, (Component)logOperationsPanel.txtLoggerSWVersion).add(1, (Component)logOperationsPanel.txtFirmWare).add(1, (Component)logOperationsPanel.txtModel).add(1, (Component)logOperationsPanel.txtFlashInfo).add(1, (Component)logOperationsPanel.txtGeoid).add(1, (Component)logOperationsPanel.txtTime).add(1, (Component)logOperationsPanel.txtLongitude).add(1, (Component)logOperationsPanel.txtLatitude))).add((Component)logOperationsPanel.cbLoggingActive)).addContainerGap(-1, Short.MAX_VALUE)));
        resourceBundle.setVerticalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbLatitude).add((Component)logOperationsPanel.txtLatitude)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbLongitude).add((Component)logOperationsPanel.txtLongitude)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbTime).add((Component)logOperationsPanel.txtTime)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbGeoid).add((Component)logOperationsPanel.txtGeoid)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbFlashInfo).add((Component)logOperationsPanel.txtFlashInfo)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbModel).add((Component)logOperationsPanel.txtModel)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbFirmWare).add((Component)logOperationsPanel.txtFirmWare)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbLoggerSWversion).add((Component)logOperationsPanel.txtLoggerSWVersion)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)logOperationsPanel.lbMemoryUsed).add((Component)logOperationsPanel.txtMemoryUsed)).addPreferredGap(0).add((Component)logOperationsPanel.cbLoggingActive)));
        resourceBundle = new GroupLayout((Container)logOperationsPanel);
        logOperationsPanel.setLayout((LayoutManager)((Object)resourceBundle));
        resourceBundle.setHorizontalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((Component)logOperationsPanel.pnFiles, -2, -1, -2).add((Component)logOperationsPanel.pnDownload, -2, -1, -2)).addPreferredGap(0).add((Component)logOperationsPanel.GPSDecodePanel, -2, -1, -2)).add((Component)logOperationsPanel.pnConvert, -2, -1, -2));
        resourceBundle.setVerticalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((Component)logOperationsPanel.pnFiles, -2, -1, -2).addPreferredGap(0).add((Component)logOperationsPanel.pnDownload, -2, -1, -2)).add((Component)logOperationsPanel.GPSDecodePanel, -2, -1, -2)).add(0, 0, 0).add((Component)logOperationsPanel.pnConvert, -2, -1, -2)));
        logOperationsPanel.getAccessibleContext().setAccessibleName("MTK Datalogger Control (BT747)");
        this.lbBusySpinner.setVisible(false);
    }

    public final void init(J2SEAppController modelListener) {
        this.c = modelListener;
        this.m = this.c.getModel();
        this.m.addListener(this);
        modelListener = this;
        Object object = modelListener;
        ((LogOperationsPanel)modelListener).cbGPSType.setModel(new DefaultComboBoxModel<String>(new String[]{J2SEAppController.getString("DEFAULT_DEVICE"), "Holux M-241/M1000C", "iTrackU-Nemerix", "PhotoTrackr", "iTrackU-SIRFIII", "Holux GPSport 245/RCV3000", "Skytraq"}));
        ((LogOperationsPanel)object).cbFormat.setModel(new DefaultComboBoxModel<String>(new String[]{J2SEAppController.getString("TABLE_Description"), J2SEAppController.getString("GPX_Description"), J2SEAppController.getString("GPX_ForOSMDescription"), J2SEAppController.getString("GMAP_Description"), J2SEAppController.getString("CSV_Description"), J2SEAppController.getString("KML_Description"), J2SEAppController.getString("KMZ_Description"), J2SEAppController.getString("NMEA_Description"), J2SEAppController.getString("OZI_Description"), J2SEAppController.getString("Compe_Description"), J2SEAppController.getString("SQL_Description"), J2SEAppController.getString("GoogleStaticURL_Description"), J2SEAppController.getString("POSTGIS_Description"), J2SEAppController.getString("C_GPS2KML_Description")}));
        ((LogOperationsPanel)object).cbDownloadMethod.setModel(new DefaultComboBoxModel<String>(new String[]{J2SEAppController.getString("DOWNLOAD_INCREMENTAL"), J2SEAppController.getString("DOWNLOAD_FULL"), J2SEAppController.getString("DOWNLOAD_FILLED")}));
        super.getWorkDirPath();
        super.getRawLogFilePath();
        super.getOutputFilePath();
        super.getDownloadMethod();
        ((LogOperationsPanel)modelListener).cbLoggingActive.setSelected(((LogOperationsPanel)modelListener).m.isLoggingActive());
        ((LogOperationsPanel)modelListener).lbConversionTime.setVisible(false);
        object = modelListener;
        int n = 0;
        switch (((LogOperationsPanel)object).m.getIntOpt(23)) {
            case 0: {
                n = 0;
                break;
            }
            case 5: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
            }
        }
        ((LogOperationsPanel)object).cbGPSType.setSelectedIndex(n);
        ((LogOperationsPanel)modelListener).cbDisableLoggingDuringDownload.setSelected(((LogOperationsPanel)modelListener).m.getBooleanOpt(24));
        object = JavaLibBridge.getTimeInstance();
        object.setUTCTime(((LogOperationsPanel)modelListener).m.getFilterStartTime());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(object.getYear(), object.getMonth() - 1, object.getDay(), 0, 0, 0);
        ((LogOperationsPanel)modelListener).startDate.setDate(calendar.getTime());
        super.updateStartDate();
        object.setUTCTime(((LogOperationsPanel)modelListener).m.getFilterEndTime());
        calendar = Calendar.getInstance();
        calendar.set(object.getYear(), object.getMonth() - 1, object.getDay(), 0, 0, 0);
        ((LogOperationsPanel)modelListener).endDate.setDate(calendar.getTime());
        super.updateEndDate();
        super.setTimeSplit();
        super.updateConnected(((LogOperationsPanel)modelListener).m.isConnected());
    }

    private final void updateConnected(boolean bl) {
        JPanel[] jPanelArray = new JPanel[]{this.GPSDecodePanel};
        if (!bl) {
            LogOperationsPanel logOperationsPanel = this;
            logOperationsPanel.txtLatitude.setText(J2SEAppController.getString("BT747Main.txtLatitude.text"));
            logOperationsPanel.txtLongitude.setText(J2SEAppController.getString("BT747Main.txtLongitude.text"));
            logOperationsPanel.txtTime.setText(J2SEAppController.getString("BT747Main.txtTime.text"));
            logOperationsPanel.txtGeoid.setText(J2SEAppController.getString("BT747Main.txtGeoid.text"));
        }
        this.btDownload.setEnabled(bl);
        for (int i = 0; i <= 0; ++i) {
            J2SEAppController.enableComponentHierarchy(jPanelArray[0], bl);
        }
    }

    private final void updateGPSData(GPSRecord gPSRecord) {
        if (this.m.isConnected() && gPSRecord.hasPosition()) {
            this.txtLatitude.setText(TaggedFilePathFactory.format("%.8f", gPSRecord.latitude));
            this.txtLongitude.setText(TaggedFilePathFactory.format("%.8f", gPSRecord.longitude));
            if (gPSRecord.hasHeight()) {
                this.txtGeoid.setText(TaggedFilePathFactory.format("%.1f", Float.valueOf(gPSRecord.geoid)) + J2SEAppController.getString("m") + " " + J2SEAppController.getString("(calc:") + TaggedFilePathFactory.format("%.1f", ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude)) + J2SEAppController.getString("m") + ")");
            }
        }
    }

    private final void doLogConversion(int n) {
        this.c.setChangeToMap(true);
        this.c.setLogConversionParameters();
        this.c.doLogConversion(n);
    }

    @Override
    public final void modelEvent(ModelEvent object) {
        try {
            switch (((GpsEvent)object).getType()) {
                case 269: {
                    return;
                }
                case 3: {
                    GPSRecord gPSRecord = (GPSRecord)((GpsEvent)object).getArg();
                    object = this;
                    if (gPSRecord.hasUtc()) {
                        ((LogOperationsPanel)object).txtTime.setText(CommonOut.getTimeStr(gPSRecord.utc));
                        ((LogOperationsPanel)object).txtTime.setToolTipText(CommonOut.getDateStr(gPSRecord.utc));
                    }
                    super.updateGPSData(gPSRecord);
                    return;
                }
                case 22: 
                case 24: {
                    this.txtMemoryUsed.setToolTipText(this.m.logMemUsed() + " " + J2SEAppController.getString("bytesused"));
                    this.txtMemoryUsed.setText(this.m.logMemUsed() + " (" + this.m.logMemUsedPercent() + "%)");
                    this.txtMemoryUsed.setText(this.m.logNbrLogPts() + " " + J2SEAppController.getString("pts") + " (" + this.m.logMemUsedPercent() + "%)");
                    return;
                }
                case 23: {
                    this.txtFlashInfo.setText(this.m.getFlashManuProdID() != 0 ? JavaLibBridge.unsigned2hex(this.m.getFlashManuProdID(), 8) + " " + this.m.getFlashDesc() : "");
                    return;
                }
                case 35: 
                case 36: {
                    this.txtModel.setText(this.m.getModelStr());
                    object = "";
                    this.lbFirmWare.setToolTipText("");
                    if (this.m.getMainVersion().length() + this.m.getFirmwareVersion().length() != 0) {
                        if (this.m.getMainVersion().length() + this.m.getFirmwareVersion().length() > 17) {
                            object = "<html>";
                            if (this.m.getMainVersion().length() > 17) {
                                object = (String)object + this.m.getMainVersion().substring(0, 14) + "...";
                                this.lbFirmWare.setToolTipText(this.m.getMainVersion());
                            } else {
                                object = (String)object + this.m.getMainVersion();
                            }
                            object = (String)object + (this.m.getMainVersion().length() != 0 ? "<br>" : "") + this.m.getFirmwareVersion();
                        } else {
                            object = this.m.getMainVersion() + " " + this.m.getFirmwareVersion();
                        }
                    }
                    this.txtFirmWare.setText((String)object);
                    return;
                }
                case 26: {
                    this.txtLoggerSWVersion.setText(this.m.getMtkLogVersion());
                    return;
                }
                case 4: {
                    this.updateGPSData((GPSRecord)((GpsEvent)object).getArg());
                    return;
                }
                case 28: {
                    this.cbLoggingActive.setSelected(this.m.isLoggingActive());
                    return;
                }
                case 266: 
                case 267: {
                    this.updateConnected(this.m.isConnected());
                    return;
                }
                case 270: {
                    this.getDownloadMethod();
                    return;
                }
                case 256: {
                    this.conversionStartTime = System.currentTimeMillis();
                    this.lbConversionTime.setVisible(false);
                    this.lbBusySpinner.setVisible(true);
                    this.lbBusySpinner.setEnabled(true);
                    this.lbBusySpinner.setBusy(true);
                    this.lbBusySpinner.repaint();
                    this.btConvert.setText(J2SEAppController.getString("Stop_Convert.text"));
                    return;
                }
                case 257: {
                    Generic.debug(J2SEAppController.getString("Time_to_convert:_") + (int)(System.currentTimeMillis() - this.conversionStartTime) + J2SEAppController.getString("_ms"));
                    this.lbBusySpinner.setVisible(false);
                    this.lbBusySpinner.setBusy(false);
                    this.lbBusySpinner.repaint();
                    this.btConvert.setText(J2SEAppController.getString("BT747Main.btConvert.text"));
                    return;
                }
                case 8: {
                    this.c.replyToOkToOverwrite(J2SEAppController.getRequestToOverwriteFromDialog());
                    return;
                }
                case 11: {
                    J2SEAppController.couldNotOpenFileMessage((String)((GpsEvent)object).getArg());
                }
            }
            return;
        }
        catch (BT747Exception bT747Exception) {
            J2SEAppController.notifyBT747Exception(bT747Exception);
            return;
        }
    }

    private File getOutputFilePath() {
        File file = new File(this.m.getPath(-1).getPath());
        this.tfOutputFileBaseName.setText(this.m.getStringOpt(10));
        return file;
    }

    private File getRawLogFilePath() {
        File file = new File(this.m.getStringOpt(12));
        this.tfRawLogFilePath.setText(this.m.getStringOpt(12));
        return file;
    }

    private File getWorkDirPath() {
        File file = new File(this.m.getStringOpt(9));
        this.tfWorkDirectory.setText(file.getPath());
        return file;
    }

    private void getDownloadMethod() {
        switch (this.m.getDownloadMethod()) {
            case 0: {
                this.cbDownloadMethod.setSelectedItem(J2SEAppController.getString("DOWNLOAD_FILLED"));
                return;
            }
            case 2: {
                this.cbDownloadMethod.setSelectedItem(J2SEAppController.getString("DOWNLOAD_FULL"));
                return;
            }
            case 1: {
                this.cbDownloadMethod.setSelectedItem(J2SEAppController.getString("DOWNLOAD_INCREMENTAL"));
            }
        }
    }

    private void updateStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.startDate.getDate());
        int n = JavaLibBridge.getDateInstance(calendar.get(5), calendar.get(2) + 1, calendar.get(1)).dateToUTCepoch1970();
        this.c.setStartTimeNoOffset(n);
    }

    private void updateEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.endDate.getDate());
        int n = JavaLibBridge.getDateInstance(calendar.get(5), calendar.get(2) + 1, calendar.get(1)).dateToUTCepoch1970() + 86399;
        this.c.setEndTimeNoOffset(n);
    }

    private void setTimeSplit() {
        int n = 60 * ((Integer)this.spTimeSplitHours.getValue() * 60 + (Integer)this.spTimeSplitMinutes.getValue());
        this.c.setTimeOffset(n);
    }

    static /* synthetic */ void access$300$31487302(LogOperationsPanel logOperationsPanel) {
        Serializable serializable = logOperationsPanel.getWorkDirPath();
        serializable = new JFileChooser((File)serializable);
        ((JFileChooser)serializable).setDialogTitle(J2SEAppController.getString("Choose_Working_Directory"));
        ((JFileChooser)serializable).setFileSelectionMode(1);
        if (((JFileChooser)serializable).showDialog(logOperationsPanel, J2SEAppController.getString("SetWorkDir")) == 0) {
            try {
                logOperationsPanel.c.setStringOpt(9, ((JFileChooser)serializable).getSelectedFile().getCanonicalPath());
            }
            catch (Exception exception) {
                Generic.debug(J2SEAppController.getString("WorkingDirChooser"), exception);
            }
            logOperationsPanel.tfWorkDirectory.setText(logOperationsPanel.m.getStringOpt(9));
            logOperationsPanel.tfWorkDirectory.setCaretPosition(logOperationsPanel.tfWorkDirectory.getText().length());
        }
    }

    static /* synthetic */ void access$400$31487302(LogOperationsPanel logOperationsPanel) {
        Object object = logOperationsPanel.getRawLogFilePath();
        JFileChooser jFileChooser = new JFileChooser(((File)object).getParent());
        jFileChooser.setSelectedFile((File)object);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.addChoosableFileFilter(new BinFileFilter());
        jFileChooser.addChoosableFileFilter(new GPXFileFilter());
        jFileChooser.addChoosableFileFilter(new CSVFileFilter());
        jFileChooser.addChoosableFileFilter(new HoluxTRLFileFilter());
        jFileChooser.addChoosableFileFilter(new NMEAFileFilter());
        jFileChooser.addChoosableFileFilter(new WPFileFilter());
        jFileChooser.addChoosableFileFilter(new ResultFileFilter());
        object = new KnownFileFilter();
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.setFileFilter((FileFilter)object);
        if (jFileChooser.showDialog(logOperationsPanel, J2SEAppController.getString("SetRawLogFile")) == 0) {
            try {
                logOperationsPanel.c.setStringOpt(12, jFileChooser.getSelectedFile().getCanonicalPath());
            }
            catch (Exception exception) {
                Generic.debug(J2SEAppController.getString("RawFileChooser"), exception);
            }
            logOperationsPanel.tfRawLogFilePath.setText(logOperationsPanel.m.getStringOpt(12));
            logOperationsPanel.tfRawLogFilePath.setCaretPosition(logOperationsPanel.tfRawLogFilePath.getText().length());
        }
    }

    static /* synthetic */ void access$500$31487302(LogOperationsPanel logOperationsPanel) {
        File file = logOperationsPanel.getOutputFilePath();
        Object object = new JFileChooser(file.getParent());
        ((JFileChooser)object).setSelectedFile(file);
        ((JComponent)object).setToolTipText(J2SEAppController.getString("Select_the_basename_of_the_output_file."));
        if (((JFileChooser)object).showDialog(logOperationsPanel, J2SEAppController.getString("Set_basename")) == 0) {
            try {
                object = FileUtil.getRelativePath(new File(logOperationsPanel.m.getStringOpt(9)).getCanonicalPath(), ((JFileChooser)object).getSelectedFile().getCanonicalPath(), File.separatorChar);
                if (((String)object).lastIndexOf(46) == ((String)object).length() - 4) {
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                }
                logOperationsPanel.c.setOutputFileRelPath((String)object);
                logOperationsPanel.getOutputFilePath();
                logOperationsPanel.tfOutputFileBaseName.setCaretPosition(logOperationsPanel.tfOutputFileBaseName.getText().length());
                return;
            }
            catch (Exception exception) {
                Generic.debug(J2SEAppController.getString("OutputFileChooser"), exception);
            }
        }
    }

    static /* synthetic */ void access$700$31487302(LogOperationsPanel logOperationsPanel) {
        switch (logOperationsPanel.m.getIntOpt(51)) {
            default: {
                LogOperationsPanel logOperationsPanel2 = logOperationsPanel;
                String string = (String)logOperationsPanel2.cbDownloadMethod.getSelectedItem();
                if (string.equals(J2SEAppController.getString("DOWNLOAD_FILLED"))) {
                    logOperationsPanel2.c.setDownloadMethod(0);
                } else if (string.equals(J2SEAppController.getString("DOWNLOAD_FULL"))) {
                    logOperationsPanel2.c.setDownloadMethod(2);
                } else if (string.equals(J2SEAppController.getString("DOWNLOAD_INCREMENTAL"))) {
                    logOperationsPanel2.c.setDownloadMethod(1);
                }
                logOperationsPanel.c.startDefaultDownload();
                return;
            }
            case 1: 
        }
        logOperationsPanel.c.startWPDownload();
    }

    static /* synthetic */ void access$800$31487302(LogOperationsPanel object) {
        if (((LogOperationsPanel)object).btConvert.getText().equals(J2SEAppController.getString("Stop_Convert.text"))) {
            ((LogOperationsPanel)object).c.stopLogConvert();
            return;
        }
        LogOperationsPanel logOperationsPanel = object;
        object = ((LogOperationsPanel)object).cbFormat.getSelectedItem().toString();
        int n = ((String)object).equals(J2SEAppController.getString("CSV_Description")) ? 1 : (((String)object).equals(J2SEAppController.getString("GMAP_Description")) ? 2 : (((String)object).equals(J2SEAppController.getString("GPX_Description")) ? 3 : (((String)object).equals(J2SEAppController.getString("GPX_ForOSMDescription")) ? 14 : (((String)object).equals(J2SEAppController.getString("KML_Description")) ? 4 : (((String)object).equals(J2SEAppController.getString("NMEA_Description")) ? 5 : (((String)object).equals(J2SEAppController.getString("OZI_Description")) ? 6 : (((String)object).equals(J2SEAppController.getString("Compe_Description")) ? 7 : (((String)object).equals(J2SEAppController.getString("KMZ_Description")) ? 11 : (((String)object).equals(J2SEAppController.getString("TABLE_Description")) ? 12 : (((String)object).equals(J2SEAppController.getString("POSTGIS_Description")) ? 19 : (((String)object).equals(J2SEAppController.getString("SQL_Description")) ? 18 : (((String)object).equals(J2SEAppController.getString("GoogleStaticURL_Description")) ? 17 : (((String)object).equals(J2SEAppController.getString("C_GPS2KML_Description")) ? 22 : 0)))))))))))));
        logOperationsPanel.doLogConversion(n);
    }

    static /* synthetic */ void access$900(LogOperationsPanel logOperationsPanel, ActionEvent actionEvent) {
        if ("datePickerCommit".equals(actionEvent.getActionCommand())) {
            logOperationsPanel.updateStartDate();
        }
    }

    static /* synthetic */ void access$1000(LogOperationsPanel logOperationsPanel, ActionEvent actionEvent) {
        if ("datePickerCommit".equals(actionEvent.getActionCommand())) {
            logOperationsPanel.updateEndDate();
        }
    }

    static /* synthetic */ void access$1400$e7e0e68(LogOperationsPanel logOperationsPanel) {
        int n;
        switch (logOperationsPanel.cbGPSType.getSelectedIndex()) {
            case 1: {
                n = 5;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        logOperationsPanel.c.setIntOpt(23, n);
    }

    static /* synthetic */ void access$2400(LogOperationsPanel logOperationsPanel, ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (logOperationsPanel.m.isLoggingActive() != bl) {
            logOperationsPanel.c.setLoggingActive(bl);
        }
    }
}

