﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace imagebuilder
{
namespace Model
{

  /**
   * <p>Amazon Inspector generates a risk score for each finding. This score helps
   * you to prioritize findings, to focus on the most critical findings and the most
   * vulnerable resources. The score uses the Common Vulnerability Scoring System
   * (CVSS) format. This format is a modification of the base CVSS score that the
   * National Vulnerability Database (NVD) provides. For more information about
   * severity levels, see <a
   * href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity
   * levels for Amazon Inspector findings</a> in the <i>Amazon Inspector User
   * Guide</i>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CvssScore">AWS
   * API Reference</a></p>
   */
  class CvssScore
  {
  public:
    AWS_IMAGEBUILDER_API CvssScore();
    AWS_IMAGEBUILDER_API CvssScore(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API CvssScore& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The CVSS base score.</p>
     */
    inline double GetBaseScore() const{ return m_baseScore; }

    /**
     * <p>The CVSS base score.</p>
     */
    inline bool BaseScoreHasBeenSet() const { return m_baseScoreHasBeenSet; }

    /**
     * <p>The CVSS base score.</p>
     */
    inline void SetBaseScore(double value) { m_baseScoreHasBeenSet = true; m_baseScore = value; }

    /**
     * <p>The CVSS base score.</p>
     */
    inline CvssScore& WithBaseScore(double value) { SetBaseScore(value); return *this;}


    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline const Aws::String& GetScoringVector() const{ return m_scoringVector; }

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline bool ScoringVectorHasBeenSet() const { return m_scoringVectorHasBeenSet; }

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline void SetScoringVector(const Aws::String& value) { m_scoringVectorHasBeenSet = true; m_scoringVector = value; }

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline void SetScoringVector(Aws::String&& value) { m_scoringVectorHasBeenSet = true; m_scoringVector = std::move(value); }

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline void SetScoringVector(const char* value) { m_scoringVectorHasBeenSet = true; m_scoringVector.assign(value); }

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline CvssScore& WithScoringVector(const Aws::String& value) { SetScoringVector(value); return *this;}

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline CvssScore& WithScoringVector(Aws::String&& value) { SetScoringVector(std::move(value)); return *this;}

    /**
     * <p>The vector string of the CVSS score.</p>
     */
    inline CvssScore& WithScoringVector(const char* value) { SetScoringVector(value); return *this;}


    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline const Aws::String& GetVersion() const{ return m_version; }

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline void SetVersion(const Aws::String& value) { m_versionHasBeenSet = true; m_version = value; }

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline void SetVersion(Aws::String&& value) { m_versionHasBeenSet = true; m_version = std::move(value); }

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline void SetVersion(const char* value) { m_versionHasBeenSet = true; m_version.assign(value); }

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline CvssScore& WithVersion(const Aws::String& value) { SetVersion(value); return *this;}

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline CvssScore& WithVersion(Aws::String&& value) { SetVersion(std::move(value)); return *this;}

    /**
     * <p>The CVSS version that generated the score.</p>
     */
    inline CvssScore& WithVersion(const char* value) { SetVersion(value); return *this;}


    /**
     * <p>The source of the CVSS score.</p>
     */
    inline const Aws::String& GetSource() const{ return m_source; }

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline void SetSource(const Aws::String& value) { m_sourceHasBeenSet = true; m_source = value; }

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline void SetSource(Aws::String&& value) { m_sourceHasBeenSet = true; m_source = std::move(value); }

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline void SetSource(const char* value) { m_sourceHasBeenSet = true; m_source.assign(value); }

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline CvssScore& WithSource(const Aws::String& value) { SetSource(value); return *this;}

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline CvssScore& WithSource(Aws::String&& value) { SetSource(std::move(value)); return *this;}

    /**
     * <p>The source of the CVSS score.</p>
     */
    inline CvssScore& WithSource(const char* value) { SetSource(value); return *this;}

  private:

    double m_baseScore;
    bool m_baseScoreHasBeenSet = false;

    Aws::String m_scoringVector;
    bool m_scoringVectorHasBeenSet = false;

    Aws::String m_version;
    bool m_versionHasBeenSet = false;

    Aws::String m_source;
    bool m_sourceHasBeenSet = false;
  };

} // namespace Model
} // namespace imagebuilder
} // namespace Aws
