﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backupstorage/BackupStorage_EXPORTS.h>
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <aws/backupstorage/BackupStorageEndpointRules.h>


namespace Aws
{
namespace BackupStorage
{
namespace Endpoint
{
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::EndpointProviderBase;
using Aws::Endpoint::DefaultEndpointProvider;

using BackupStorageClientContextParameters = Aws::Endpoint::ClientContextParameters;

using BackupStorageClientConfiguration = Aws::Client::GenericClientConfiguration<false>;
using BackupStorageBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the BackupStorage Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using BackupStorageEndpointProviderBase =
    EndpointProviderBase<BackupStorageClientConfiguration, BackupStorageBuiltInParameters, BackupStorageClientContextParameters>;

using BackupStorageDefaultEpProviderBase =
    DefaultEndpointProvider<BackupStorageClientConfiguration, BackupStorageBuiltInParameters, BackupStorageClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_BACKUPSTORAGE_API BackupStorageEndpointProvider : public BackupStorageDefaultEpProviderBase
{
public:
    using BackupStorageResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

    BackupStorageEndpointProvider()
      : BackupStorageDefaultEpProviderBase(Aws::BackupStorage::BackupStorageEndpointRules::GetRulesBlob(), Aws::BackupStorage::BackupStorageEndpointRules::RulesBlobSize)
    {}

    ~BackupStorageEndpointProvider()
    {
    }
};
} // namespace Endpoint
} // namespace BackupStorage
} // namespace Aws
