/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_1;

import java.util.List;
import org.virtualbox_7_1.CPUArchitecture;
import org.virtualbox_7_1.Helper;
import org.virtualbox_7_1.Holder;
import org.virtualbox_7_1.IHostAudioDevice;
import org.virtualbox_7_1.IHostDrive;
import org.virtualbox_7_1.IHostNetworkInterface;
import org.virtualbox_7_1.IHostUSBDevice;
import org.virtualbox_7_1.IHostUSBDeviceFilter;
import org.virtualbox_7_1.IHostVideoInputDevice;
import org.virtualbox_7_1.IHostX86;
import org.virtualbox_7_1.IMedium;
import org.virtualbox_7_1.IProgress;
import org.virtualbox_7_1.IUnknown;
import org.virtualbox_7_1.IUpdateAgent;
import org.virtualbox_7_1.ObjectRefManager;
import org.virtualbox_7_1.ProcessorFeature;
import org.virtualbox_7_1.VBoxException;
import org.virtualbox_7_1.VMExecutionEngine;
import org.virtualbox_7_1.jaxws.HostNetworkInterfaceType;
import org.virtualbox_7_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_1.jaxws.PlatformArchitecture;
import org.virtualbox_7_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IHost
extends IUnknown {
    public IHost(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public org.virtualbox_7_1.PlatformArchitecture getArchitecture() {
        try {
            PlatformArchitecture platformArchitecture = this.port.iHostGetArchitecture(this.obj);
            return org.virtualbox_7_1.PlatformArchitecture.fromValue(platformArchitecture.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IHostX86 getX86() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iHostGetX86(this.obj);
            IHostX86 iHostX86 = string.length() > 0 ? new IHostX86(string, this.getObjMgr(), this.port) : null;
            return iHostX86;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMedium> getDVDDrives() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetDVDDrives(this.obj);
            List<IMedium> list2 = Helper.wrap(IMedium.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMedium> getFloppyDrives() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetFloppyDrives(this.obj);
            List<IMedium> list2 = Helper.wrap(IMedium.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IHostAudioDevice> getAudioDevices() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetAudioDevices(this.obj);
            List<IHostAudioDevice> list2 = Helper.wrap(IHostAudioDevice.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IHostUSBDevice> getUSBDevices() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetUSBDevices(this.obj);
            List<IHostUSBDevice> list2 = Helper.wrap(IHostUSBDevice.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IHostUSBDeviceFilter> getUSBDeviceFilters() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetUSBDeviceFilters(this.obj);
            List<IHostUSBDeviceFilter> list2 = Helper.wrap(IHostUSBDeviceFilter.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IHostNetworkInterface> getNetworkInterfaces() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetNetworkInterfaces(this.obj);
            List<IHostNetworkInterface> list2 = Helper.wrap(IHostNetworkInterface.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<String> getNameServers() {
        try {
            List<String> list = this.port.iHostGetNameServers(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getDomainName() {
        try {
            String string = this.port.iHostGetDomainName(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<String> getSearchStrings() {
        try {
            List<String> list = this.port.iHostGetSearchStrings(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getProcessorCount() {
        try {
            Long l = this.port.iHostGetProcessorCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getProcessorOnlineCount() {
        try {
            Long l = this.port.iHostGetProcessorOnlineCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getProcessorCoreCount() {
        try {
            Long l = this.port.iHostGetProcessorCoreCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getProcessorOnlineCoreCount() {
        try {
            Long l = this.port.iHostGetProcessorOnlineCoreCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<IHostDrive> getHostDrives() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetHostDrives(this.obj);
            List<IHostDrive> list2 = Helper.wrap(IHostDrive.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public Long getMemorySize() {
        try {
            Long l = this.port.iHostGetMemorySize(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMemoryAvailable() {
        try {
            Long l = this.port.iHostGetMemoryAvailable(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getOperatingSystem() {
        try {
            String string = this.port.iHostGetOperatingSystem(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getOSVersion() {
        try {
            String string = this.port.iHostGetOSVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getUTCTime() {
        try {
            Long l = this.port.iHostGetUTCTime(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<IHostVideoInputDevice> getVideoInputDevices() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostGetVideoInputDevices(this.obj);
            List<IHostVideoInputDevice> list2 = Helper.wrap(IHostVideoInputDevice.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IUpdateAgent getUpdateHost() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iHostGetUpdateHost(this.obj);
            IUpdateAgent iUpdateAgent = string.length() > 0 ? new IUpdateAgent(string, this.getObjMgr(), this.port) : null;
            return iUpdateAgent;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IUpdateAgent getUpdateExtPack() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iHostGetUpdateExtPack(this.obj);
            IUpdateAgent iUpdateAgent = string.length() > 0 ? new IUpdateAgent(string, this.getObjMgr(), this.port) : null;
            return iUpdateAgent;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IUpdateAgent getUpdateGuestAdditions() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iHostGetUpdateGuestAdditions(this.obj);
            IUpdateAgent iUpdateAgent = string.length() > 0 ? new IUpdateAgent(string, this.getObjMgr(), this.port) : null;
            return iUpdateAgent;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static IHost queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IHost(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public Long getProcessorSpeed(Long l) {
        try {
            Long l2 = this.port.iHostGetProcessorSpeed(this.obj, l);
            return l2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean getProcessorFeature(ProcessorFeature processorFeature) {
        try {
            Boolean bl = this.port.iHostGetProcessorFeature(this.obj, org.virtualbox_7_1.jaxws.ProcessorFeature.fromValue(processorFeature.name()));
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getProcessorDescription(Long l) {
        try {
            String string = this.port.iHostGetProcessorDescription(this.obj, l);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IProgress createHostOnlyNetworkInterface(Holder<IHostNetworkInterface> holder) {
        this.getObjMgr().preventObjRelease();
        try {
            javax.xml.ws.Holder holder2 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            this.port.iHostCreateHostOnlyNetworkInterface(this.obj, (javax.xml.ws.Holder<String>)holder2, (javax.xml.ws.Holder<String>)holder3);
            holder.value = ((String)holder2.value).length() > 0 ? new IHostNetworkInterface((String)holder2.value, this.getObjMgr(), this.port) : null;
            IProgress iProgress = ((String)holder3.value).length() > 0 ? new IProgress((String)holder3.value, this.getObjMgr(), this.port) : null;
            return iProgress;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IProgress removeHostOnlyNetworkInterface(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostRemoveHostOnlyNetworkInterface(this.obj, string);
            IProgress iProgress = string2.length() > 0 ? new IProgress(string2, this.getObjMgr(), this.port) : null;
            return iProgress;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IHostUSBDeviceFilter createUSBDeviceFilter(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostCreateUSBDeviceFilter(this.obj, string);
            IHostUSBDeviceFilter iHostUSBDeviceFilter = string2.length() > 0 ? new IHostUSBDeviceFilter(string2, this.getObjMgr(), this.port) : null;
            return iHostUSBDeviceFilter;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void insertUSBDeviceFilter(Long l, IHostUSBDeviceFilter iHostUSBDeviceFilter) {
        try {
            this.port.iHostInsertUSBDeviceFilter(this.obj, l, iHostUSBDeviceFilter == null ? null : iHostUSBDeviceFilter.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void removeUSBDeviceFilter(Long l) {
        try {
            this.port.iHostRemoveUSBDeviceFilter(this.obj, l);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IMedium findHostDVDDrive(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindHostDVDDrive(this.obj, string);
            IMedium iMedium = string2.length() > 0 ? new IMedium(string2, this.getObjMgr(), this.port) : null;
            return iMedium;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IMedium findHostFloppyDrive(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindHostFloppyDrive(this.obj, string);
            IMedium iMedium = string2.length() > 0 ? new IMedium(string2, this.getObjMgr(), this.port) : null;
            return iMedium;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceByName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceByName(this.obj, string);
            IHostNetworkInterface iHostNetworkInterface = string2.length() > 0 ? new IHostNetworkInterface(string2, this.getObjMgr(), this.port) : null;
            return iHostNetworkInterface;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceById(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceById(this.obj, string);
            IHostNetworkInterface iHostNetworkInterface = string2.length() > 0 ? new IHostNetworkInterface(string2, this.getObjMgr(), this.port) : null;
            return iHostNetworkInterface;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IHostNetworkInterface> findHostNetworkInterfacesOfType(org.virtualbox_7_1.HostNetworkInterfaceType hostNetworkInterfaceType) {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iHostFindHostNetworkInterfacesOfType(this.obj, HostNetworkInterfaceType.fromValue(hostNetworkInterfaceType.name()));
            List<IHostNetworkInterface> list2 = Helper.wrap(IHostNetworkInterface.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IHostUSBDevice findUSBDeviceById(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindUSBDeviceById(this.obj, string);
            IHostUSBDevice iHostUSBDevice = string2.length() > 0 ? new IHostUSBDevice(string2, this.getObjMgr(), this.port) : null;
            return iHostUSBDevice;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IHostUSBDevice findUSBDeviceByAddress(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iHostFindUSBDeviceByAddress(this.obj, string);
            IHostUSBDevice iHostUSBDevice = string2.length() > 0 ? new IHostUSBDevice(string2, this.getObjMgr(), this.port) : null;
            return iHostUSBDevice;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public String generateMACAddress() {
        try {
            String string = this.port.iHostGenerateMACAddress(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void addUSBDeviceSource(String string, String string2, String string3, List<String> list, List<String> list2) {
        try {
            this.port.iHostAddUSBDeviceSource(this.obj, string, string2, string3, list, list2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void removeUSBDeviceSource(String string) {
        try {
            this.port.iHostRemoveUSBDeviceSource(this.obj, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean isExecutionEngineSupported(CPUArchitecture cPUArchitecture, VMExecutionEngine vMExecutionEngine) {
        try {
            Boolean bl = this.port.iHostIsExecutionEngineSupported(this.obj, org.virtualbox_7_1.jaxws.CPUArchitecture.fromValue(cPUArchitecture.name()), org.virtualbox_7_1.jaxws.VMExecutionEngine.fromValue(vMExecutionEngine.name()));
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

