
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * VMExecutionEngine.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
The main execution engine of a VM.
Interface ID: <tt>{56029577-31F7-44D2-3334-7ECBF95294B6}</tt>
*/
public enum VMExecutionEngine
{

/**
Has not yet been set (try again later).
*/
    NotSet(0),

/**
Raw-mode.
*/
    RawMode(1),

/**
Hardware assisted virtualization thru HM.
*/
    HwVirt(2),

/**
Hardware assisted virtualization thru native API (NEM).
*/
    NativeApi(3);

    private final int value;

    VMExecutionEngine(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static VMExecutionEngine fromValue(long v)
    {
        for (VMExecutionEngine c: VMExecutionEngine.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static VMExecutionEngine fromValue(String v)
    {
        return valueOf(VMExecutionEngine.class, v);
    }
}

