/**
 * CIMReferenceNamesOp.java
 *
 * (C) Copyright IBM Corp. 2005, 2006
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Roberto Pineiro, IBM, roberto.pineiro@us.ibm.com  
 * @author: Chung-hao Tan, IBM ,chungtan@us.ibm.com
 * 
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1535756    2006-08-07  lupusalex    Make code warning free
 *
 */

package org.sblim.wbem.client.operations;

import org.sblim.wbem.cim.CIMObjectPath;

public class CIMReferenceNamesOp extends CIMOperation {

	protected String iResultClass;

	protected String iResultRole;

	public CIMReferenceNamesOp(CIMObjectPath pObjectName, String pResultClass, String pRole) {
		iMethodCall = "ReferenceNames";
		iObjectName = pObjectName;
		iResultClass = pResultClass;
		iResultRole = pRole;
	}

	
	/**
	 * Returns resultClass
	 * @return The value of resultClass.
	 */
	public String getResultClass() {
		return iResultClass;
	}

	
	/**
	 * Returns resultRole
	 * @return The value of resultRole.
	 */
	public String getResultRole() {
		return iResultRole;
	}


}
