/**
 * SLPLimits.java
 *
 * (C) Copyright IBM Corp. 2006, 2007
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Alexander Wolf-Reber, IBM a.wolf-reber@de.ibm.com
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1535793    2006-09-14  lupusalex    Fix&Integrate CIM&SLP configuration classes
 */
package org.sblim.slp.internal;

/**
 * SLPLimits
 *
 */
public interface SLPLimits {

	/**
	 * MAX_DISCOVERY_GRANULARITY
	 */
	public static final int MAX_DISCOVERY_GRANULARITY = 800;

	/**
	 * MAX_DISCOVERY_INTERVAL
	 */
	public static final int MAX_DISCOVERY_INTERVAL = 3 * 60 * 60; // 3h

	/**
	 * MAX_MTU
	 */
	public static final int MAX_MTU = 8192;

	/**
	 * MAX_MULTICAST_MAXIMUM_WAIT
	 */
	public static final int MAX_MULTICAST_MAXIMUM_WAIT = 60000;

	/**
	 * MAX_MULTICAST_RADIUS
	 */
	public static final int MAX_MULTICAST_RADIUS = 255;

	/**
	 * MAX_SERVER_SOCKET_QUEUE_LENGTH
	 */
	public static final int MAX_SERVER_SOCKET_QUEUE_LENGTH = 0x7fffffff;

	/**
	 * MAX_TCP_TIMEOUT
	 */
	public static final int MAX_TCP_TIMEOUT = 360000;

	/**
	 * MIN_DISCOVERY_GRANULARITY
	 */
	public static final int MIN_DISCOVERY_GRANULARITY = 0;

	/**
	 * MIN_DISCOVERY_INTERVAL
	 */
	public static final int MIN_DISCOVERY_INTERVAL = 0;

	/**
	 * MIN_MTU
	 */
	public static final int MIN_MTU = 128;

	/**
	 * MIN_MULTICAST_MAXIMUM_WAIT
	 */
	public static final int MIN_MULTICAST_MAXIMUM_WAIT = 1000;

	/**
	 * MIN_MULTICAST_RADIUS
	 */
	public static final int MIN_MULTICAST_RADIUS = 1;

	/**
	 * MIN_SERVER_SOCKET_QUEUE_LENGTH
	 */
	public static final int MIN_SERVER_SOCKET_QUEUE_LENGTH = 0;

	/**
	 * MIN_TCP_TIMEOUT
	 */
	public static final int MIN_TCP_TIMEOUT = 100;

}
