/*
 *	sam/sys_types.h - SAM-FS system types.
 *
 *	System type definitions for the SAM-FS filesystem and daemons.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef	_SAM_SYS_TYPES_H
#define	_SAM_SYS_TYPES_H

#ifdef sun
#pragma ident "$Revision$"
#endif


#ifdef linux

#include <sam/linux_types.h>
#include <sam/osversion.h>

#ifndef __KERNEL__
#include <sys/fcntl.h>
#include <sam/linux_types.h>	/* struct statvfs */
#include <sys/time.h>
#endif	/* __KERNEL__ */

#else	/* linux */

#include <sam/osversion.h>
#include <sys/fcntl.h>

#include <sys/dirent.h>
#include <sys/statvfs.h>
#include <sys/time.h>

#endif	/* linux */


#ifdef sun
#include <sys/types32.h>

typedef int64_t		sam_tr_t;
typedef size_t		sam_size_t;
typedef ssize_t		sam_ssize_t;
typedef intptr_t	sam_intptr_t;
typedef uintptr_t	sam_uintptr_t;

typedef uint32_t	sam_mode_t;

#endif

#ifdef linux

typedef int64_t		sam_tr_t;
#ifdef _LP64
typedef int64_t		sam_intptr_t;
typedef uint64_t	sam_uintptr_t;
typedef int64_t		sam_ssize_t;
typedef uint64_t 	sam_size_t;
#else
typedef int		sam_intptr_t;
typedef uint_t		sam_uintptr_t;
typedef int		sam_ssize_t;
typedef uint_t		sam_size_t;
#endif
typedef int32_t		time32_t;

typedef uint32_t	sam_mode_t;

struct timeval32 {
	time32_t	tv_sec;		/* seconds */
	int32_t		tv_usec;	/* and microseconds */
};
#endif /* linux */

#define	SAM_MAXOFFSET_T	MAXOFFSET_T

typedef offset_t	sam_offset_t;
typedef u_offset_t	sam_u_offset_t;
typedef uint32_t	sam_bn_t;
typedef u_offset_t	sam_daddr_t;
typedef flock64_t	sam_flock_t;
typedef dirent64_t	sam_dirent64_t;
typedef statvfs64_t	sam_statvfs_t;


#endif	/* _SAM_SYS_TYPES_H */
