/*
 * custmsg.h - Customer message processor definitions.
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#if !defined(CUSTMSG_H)
#define	CUSTMSG_H

#ifdef sun
#pragma ident "$Revision$"
#endif

#include "sam/types.h"

/*
 * Generate customer message arguments.
 */
#define	CustMsg(n) n
#define	HERE _SrcFile, __LINE__
#define	LibFatal(f, a) _LibFatal(_SrcFile, __LINE__, #f, a)

/*
 * Users can be notified of an problems via Email, SNMP or fault log
 */
#define	NOTIFY_AS_FAULT		0x00000001
#define	NOTIFY_AS_TRAP		0x00000002
#define	NOTIFY_AS_EMAIL		0x00000004

/*
 * Classification of the components as required by sysevent
 */
#define	FSD_CLASS			"Fsd"   	/* sam-fsd class name used by sysevent */
#define	FS_CLASS			"FS"		/* Filesystem Class name used by sysevent */
#define	MISC_CLASS			"Misc"		/* Misc Class name used by sysevent */
#define	DUMP_CLASS			"Dump"		/* for events related to samfsdump */
#define	ACSLS_CLASS			"Acsls"		/* for events related to acsls */
#define	ACSLS_ERROR_SUBCLASS		"Err"		/* for errors */
#define	ACSLS_INFO_SUBCLASS		"Warn"		/* for info */
#define	DUMP_WARN_SUBCLASS		"Warn"		/* for warnings */
#define	DUMP_INTERRUPTED_SUBCLASS	"Interrupted"	/* for errors */
#define	MAX_MSGBUF_SIZE			1024

/*
 * Public functions
 */
void _LibFatal(const char *SrcFile, const int SrcLine, const char *FunctionName,
		const char *arg);
void CustmsgInit(int log_mode,
		void(*Notify)(int priority, int MsgNum, char *msg));
void CustmsgTerm(void);
char *GetCustMsg(int MsgNum);
void LibError(void(*MsgFunc)(int code, char *msg), int code, int MsgNum, ...);
void Nomem(const char *FunctionName, char *ObjectName, size_t size);
void SendCustMsg(const char *SrcFile, const int SrcLine, int MsgNum, ...);
void SysError(const char *SrcFile, const int SrcLine, const char *fmt, ...);

/*
 * PostEvent
 * Post the system event to syseventd. In sysevent.conf, a handler exists for
 * ach posted event. The action to be taken (send email, send trap or persist as * fault) is given as input in action. The class, subclass, msgnum, errortype
 * and message describe the event
 * This has replaced the PostSysevent() api
 */
int PostEvent(char *class, char *subclass, int msgnum, int errortype, char *msg, uint32_t action);

/*
 * Public data.
 */
extern int ErrorExitStatus;

#endif /* CUSTMSG_H */
