#ifndef _GEN_INP_H
#define _GEN_INP_H

#define True        1
#define False       0
#define N_ASCII_KEY 95      /* Num of printable ASCII char (module.h)*/ 

/* -------------------- module.h ---------------------------*/
#define SELECT_KEY_LENGTH 15
#define  N_KEYCODE      50  /* # of valid keys 0-9, a-z, .... */


/* ------------------ /util/cin2tab/gencin.h ---------------*/
#define VERLEN		20
#define ENCLEN		15
#define CIN_ENAME_LENGTH	20
#define CIN_CNAME_LENGTH	20

#define END_KEY_LENGTH     10 /* max # of end keys */

typedef struct
{
    char version[VERLEN];	     /* version number  */
    char encoding[ENCLEN];           /* table encoding  */
    char ename[CIN_ENAME_LENGTH];    /* English name    */
    char cname[CIN_CNAME_LENGTH];    /* Chinese name    */

    wch_t keyname[N_KEYCODE];        /* key name define */ // [wct_t @ xcintool.h] [N_KEYCODE @ module.h]
    char selkey[SELECT_KEY_LENGTH + 1]; /* select keys */
    char endkey[END_KEY_LENGTH + 1]; /* end keys */

    unsigned int n_ichar;        /* # of total chars */
    unsigned int n_icode;        /* # of total keystroke code */
    unsigned char n_keyname;     /* # of keyname needed */
    unsigned char n_selkey;      /* # of select keys */
    unsigned char n_endkey;      /* # of end keys */
    unsigned char n_max_keystroke; /* max # of keystoke for each char */
    char icode_mode;
} cintab_head_t; 
/* --------- cin2tab/gencin.h -------------- */
#define  INP_CODE_LENGTH        10      /* max # of keys in a keystroke */

/* --------- gen_inp.h ------------ */
typedef struct
{
    char keystroke[INP_CODE_LENGTH+1];
    wch_t wch;      /* section 1 */
} kremap_t;
/*=============== gen_inp_iccf_t =====================*/
typedef struct
{
    char keystroke[INP_CODE_LENGTH+1];
    unsigned short mode;
    wch_t *mcch_list;
    int *mkey_list;
    unsigned int n_mcch_list, mcch_hidx, mcch_eidx, n_mkey_list;
} gen_inp_iccf_t;


/* --------------- cin2tab/gencin.h -------------- */
#define ICODE_MODE1             1       /* one icode & one icode_idx */
#define ICODE_MODE2             2       /* two icode & one icode_idx */

/* For input-code char definition. */
typedef unsigned int    icode_t;
typedef unsigned int  icode_idx_t;
typedef icode_idx_t     ichar_t;

/***************************************************/
typedef struct
{
    char* inp_cname;
    char* inp_ename;
    char* tabfn;
    unsigned int mode;
    cintab_head_t header;   /* section 1 */
    ccode_info_t ccinfo;    /* section 2 */
    ubyte_t modesc;
    char* disable_sel_list;
    int n_kremap;
    kremap_t *kremap;       /* section 3 */

    icode_t* ic1;           /* section 4 */
    icode_t* ic2;
    icode_idx_t* icidx;
    ichar_t* ichar;
} gen_inp_conf_t;

/*=============== inpinfo_t (module.h) ============================*/ 
/*  Structure for IM in IC.  */
typedef struct {
    int imid;               /* ID of current IM Context */
    void *iccf;             /* Internal data of IM for each IC */
    
    char *inp_cname;            /* IM Chinese name */
    char *inp_ename;            /* IM English name */
    ubyte_t area3_len;          /* Length of area 3 of window (n_char)*/
    ubyte_t zh_ascii;           /* The zh_ascii mode */
    unsigned short xcin_wlen;       /* xcin window length */
//    xmode_t guimode;            /* GUI mode flag */
    
    ubyte_t keystroke_len;      /* # chars of keystroke */
    wch_t *s_keystroke;         /* keystroke printed in area 3 */
    wch_t *suggest_skeystroke;      /* keystroke printed in area 3 */
    
    ubyte_t n_selkey;           /* # of selection keys */
    wch_t *s_selkey;            /* the displayed select keys */
    unsigned short n_mcch;      /* # of chars with the same keystroke */
    wch_t *mcch;            /* multi-char list */
    ubyte_t *mcch_grouping;     /* grouping of mcch list */
    byte_t mcch_pgstate;        /* page state of multi-char */
    
    unsigned short n_lcch;      /* # of composed cch list. */
    wch_t *lcch;            /* composed cch list. */
    unsigned short edit_pos;        /* editing position in lcch list. */
    ubyte_t *lcch_grouping;     /* grouping of lcch list */
    
    wch_t cch_publish;          /* A published cch. */
    char *cch;              /* the string for commit. */
} inpinfo_t;

int loadtab( gen_inp_conf_t*, FILE*, char* );
int gen_inp_xim_init( gen_inp_conf_t*, gen_inp_iccf_t*, inpinfo_t* );
int gen_inp_xim_end( gen_inp_conf_t*, inpinfo_t *);
inpinfo_t* match_keystroke( gen_inp_conf_t*, inpinfo_t*, gen_inp_iccf_t* );

/*
static int bsearch_char(icode_t*, icode_t*, icode_t, icode_t, int, int, int );
static int cmp_icvalue( icode_t*, icode_t*, unsigned int, icode_t, icode_t, int );
*/

#endif
