/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "xcin.h"

extern int keys2codes(unsigned int *, int, char *);

int loadtab( gen_inp_conf_t* cf, FILE* fp, char* encoding )
{
    int n, nn, ret = 1;
    char modID[MODULE_ID_SIZE];


    if (fread(modID, sizeof(char), MODULE_ID_SIZE, fp) != MODULE_ID_SIZE ||
       (strcmp( modID, "gencin" )) )
    {
        printf("gen_inp: invalid tab file.\n");
        return False; 
    }
    if (fread(&(cf->header), sizeof(cintab_head_t), 1, fp) != 1)
    {
        printf("gen_inp: reading error.\n");
        return False;
    }

printConfInfo( "loadtab() conf", cf );

    if (strcmp(encoding, cf->header.encoding) != 0 )
    {
        printf("Invalid encoding\n");
        return False;
    }

    if (! cf->inp_cname)
        cf->inp_cname = cf->header.cname;

    n = cf->header.n_icode;
    nn = cf->ccinfo.total_char;
    
    cf->icidx = calloc(1, sizeof(icode_idx_t) * n);
    cf->ichar = calloc(1, sizeof(ichar_t) * nn );
    cf->ic1 = calloc(1, sizeof(icode_t) * n );

    if (!n || !nn ||
        fread(cf->icidx, sizeof(icode_idx_t), n, fp) != n ||
        fread(cf->ichar, sizeof(ichar_t), nn, fp) != nn ||
        fread(cf->ic1, sizeof(icode_t), n, fp) != n)
    {
        if (n)
        {
            free(cf->icidx);
            free(cf->ic1);
        }    
        if (nn){
            free(cf->ichar);
        }
        ret = 0; 
    }

printICInfo( "loadtab() before ic2 read", cf );

    if (ret && cf->header.icode_mode == ICODE_MODE2)
    {
        cf->ic2 = calloc(1, sizeof(icode_t) * n );
        if (fread(cf->ic2, sizeof(icode_t), n, fp) != n )
        {    
            if (n){
                free(cf->ic2);
            }
            ret = 0; printf("set zero here(2)\n");
        }
    }

printICInfo( "loadtab() after ic2 read", cf );

    if (! ret)
    {
        printf("gen_inp: reading error %d\n", ret);
        return False;
    }
    else
    {
        return True;
    }
}

inpinfo_t*  match_keystroke( gen_inp_conf_t *cf, inpinfo_t* inpinfo, gen_inp_iccf_t* iccf )
{
    icode_t icode[2];
    unsigned int size, md, n_ich=0, mcch_size;
    int idx;
    wch_t *mcch;

    size = cf->header.n_icode;
    md = (cf->header.icode_mode == ICODE_MODE2) ? 1 : 0;
    icode[0] = icode[1] = 0;

    printICInfo( "match_keystroke()", cf );   
    debug("file: %s, line: %d, match_keystroke(), size:<%u> \t md:<%u> \t iccf->keystroke:<%s>\n", __FILE__, __LINE__, size, md, iccf->keystroke);

    keys2codes(icode, 2, iccf->keystroke);

    if ((idx = bsearch_char(cf->ic1, cf->ic2, icode[0], icode[1], size, md, 0)) == -1)
    {
        printf("\n\n*** WATCH: match_keystroke(): Binary Search Fail\n\n");
        inpinfo->mcch[0].wch = 0;
        inpinfo->n_mcch = 0;
        return inpinfo;    
    }

    inpinfo->n_selkey = cf->header.n_selkey;
    mcch_size = inpinfo->n_selkey;  
    mcch = calloc(mcch_size, sizeof(wch_t));
    inpinfo->mcch = realloc( inpinfo->mcch, mcch_size * sizeof(wch_t) );

    do
    {
        if (mcch_size <= n_ich)
        {
            mcch_size *= 2;
            mcch = realloc( mcch, mcch_size * sizeof(wch_t) );       
            inpinfo->mcch = realloc( inpinfo->mcch, mcch_size * sizeof(wch_t) );
        }

        if (! ccode_to_char( cf->icidx[idx], mcch[n_ich].s, WCH_SIZE ))
            return inpinfo;    
        
        n_ich++; 
        idx++;
    }
    while (idx < size && 
           ! cmp_icvalue(cf->ic1, cf->ic2, idx, icode[0], icode[1], md ));

/*  ---ignore rule idx < inpinfo->n_selkey && */
    for ( idx=0; idx < n_ich ; idx++ )
        memcpy((void *)&inpinfo->mcch[idx], (void *)&mcch[idx], sizeof(wch_t));
        /*inpinfo->mcch[idx].wch = mcch[idx].wch;*/
    inpinfo->n_mcch = idx;

/* cannot free the mcch as it assigned to inpinfo->mcch (fix for seg fault)? */
/*    if ( idx >= n_ich )
    {
        free(mcch);
    }*/
/*    else
    {
        if (iccf->n_mcch_list){
            free(iccf->mcch_list);
        }

        iccf->mcch_list = mcch;
        iccf->n_mcch_list = n_ich;
        iccf->mcch_hidx = 0;
    }*/

    free(mcch);
    return inpinfo;
}

/*
 * conf: a memory block
 * conf is dependent on the struct of the 'module'. in this case gen_inp
 */
int gen_inp_xim_init( gen_inp_conf_t* cf, gen_inp_iccf_t* iccf, inpinfo_t* inpinfo )
{
    int i;

    inpinfo->inp_cname = cf->inp_cname;
    inpinfo->inp_ename = cf->inp_ename;
    inpinfo->area3_len = cf->header.n_max_keystroke * 2 + 1;
    inpinfo->keystroke_len = 0;
    inpinfo->s_keystroke = calloc(INP_CODE_LENGTH + 1, sizeof(wch_t)); /* NOTE: smart_keystroke I presumed? */
    inpinfo->suggest_skeystroke = calloc(INP_CODE_LENGTH + 1, sizeof(wch_t));
    
    if (! (cf->mode & INP_MODE_SELKEYSHIFT) )
    {
        inpinfo->n_selkey = cf->header.n_selkey;
        inpinfo->s_selkey = calloc(inpinfo->n_selkey, sizeof(wch_t));
    
        for( i=0; i < SELECT_KEY_LENGTH && i < cf->header.n_selkey; i++ )
            inpinfo->s_selkey[i].s[0] = cf->header.selkey[i];
    } 
    else
    {
        inpinfo->n_selkey = cf->header.n_selkey+1;
        inpinfo->s_selkey = calloc(inpinfo->n_selkey, sizeof(wch_t));
        
        for( i = 0; i < SELECT_KEY_LENGTH && i < cf->header.n_selkey; i++ )
            inpinfo->s_selkey[i+1].s[0] = cf->header.selkey[i];
    }
    
    inpinfo->n_mcch = 0;
    inpinfo->mcch = calloc(inpinfo->n_selkey, sizeof(wch_t));
    inpinfo->mcch_grouping = NULL;
    inpinfo->mcch_pgstate = MCCH_ONEPG;

    inpinfo->n_lcch = 0;
    inpinfo->lcch = NULL;
    inpinfo->lcch_grouping= NULL;
    inpinfo->lcch_grouping = NULL;
    inpinfo->cch_publish.wch = (wchar_t)0;

    return True;
}


int
gen_inp_xim_end(gen_inp_conf_t* cf, inpinfo_t *inpinfo)
{
    gen_inp_iccf_t *iccf = (gen_inp_iccf_t *)inpinfo->iccf;

    /* free the memory from calloc in loadtab() */
    free(cf->icidx);
    free(cf->ichar);
    free(cf->ic1);
    if(cf->header.icode_mode == ICODE_MODE2)
        free(cf->ic2);

    /*if (iccf->n_mcch_list)
	free(iccf->mcch_list);
    if (iccf->n_mkey_list)
	free(iccf->mkey_list);*/

    
    /*free(inpinfo->iccf);*/
    free(inpinfo->s_keystroke);
    free(inpinfo->suggest_skeystroke);
    free(inpinfo->s_selkey);
    free(inpinfo->mcch);
    /*inpinfo->iccf = NULL;*/
    inpinfo->s_keystroke = NULL;
    inpinfo->suggest_skeystroke = NULL;
    inpinfo->s_selkey = NULL;
    inpinfo->mcch = NULL;
    return True;
}

static int bsearch_char(icode_t *ic1, icode_t *ic2,
                        icode_t icode1, icode_t icode2, int size, int mode, int wild)
{
    int head, middle, end, ret;
                                                                                                                            
    head   = 0;
    middle = size / 2;
    end    = size;
    while ((ret=cmp_icvalue(ic1, ic2, middle, icode1, icode2, mode))) 
    {
        if (ret > 0)
            end = middle;
        else
            head = middle + 1;
        middle = (end + head) / 2;
        if (middle == head && middle == end)
            break;
    }
    if (ret == 0) 
    {
        while(middle > 0 &&
              ! cmp_icvalue(ic1, ic2, middle-1, icode1, icode2, mode))
            middle --;

        return middle;
    }
    else
        return (wild) ? middle : -1;
}

static int cmp_icvalue(icode_t *ic1, icode_t *ic2, unsigned int idx,
                       icode_t icode1, icode_t icode2, int mode)
{
    if (ic1[idx] > icode1)
        return 1;
    else if (ic1[idx] < icode1)
        return -1;
    else 
    {
        if (! mode)
            return 0;
        else if (ic2[idx] > icode2)
            return 1;
        else if (ic2[idx] < icode2)
            return -1;
        else
            return 0;
    }
}
