/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * get user's iiim preferences from gconf registry and set them
 * into root windows property at window system start up.
 */

#include <locale.h>
#include <config.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gconf/gconf-client.h>
#include "iiim-properties.h"

void setget_fetch_gconf_settings (IIIMProps *);
void setget_write_back_to_gconf_and_x_props (IIIMProps *);
gboolean cf_initialize (Display *);
void setget_set_no_cf ();
void send_user_layout ();

int
main (int argc, char *argv[])
{
  IIIMProps *iiim_props;
  int i;
  gboolean send_layout_only = FALSE;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif
  gdk_init (&argc, &argv);

  setlocale (LC_ALL, "");
  
  for (i = 0; i < argc; i++) {
    if (!strcmp (argv[i], "-sendlayout")) {
      send_layout_only = TRUE;
      break;
    }
  }

  if (!cf_initialize (GDK_DISPLAY()))
    {
      setget_set_no_cf ();
    }
  else
    {
      send_user_layout ();
    }
  
  if (send_layout_only) {
    gdk_exit (0);
  }

  iiim_props = g_new0 (IIIMProps, 1);
  /* get user's preference and default values */
  setget_fetch_gconf_settings (iiim_props);

  /* set those values to gconf and root window's property */
  setget_write_back_to_gconf_and_x_props (iiim_props);

  g_free (iiim_props);
  gdk_flush ();

  gdk_exit (0);
}
