/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * gconf keys which relate with iiim
 */
#ifndef _IIIM_PROPERTIES_H
#define _IIIM_PROPERTIES_H

#include <glib.h>
#include <X11/Xlib.h>
#include "iiimcf.h"

#define IIIM_KEY_DIR "/desktop/input_methods"
#define IIIM_GNOME_KEY_DIR "/desktop/gnome/input_methods"
#define IIIM_GIMLET_KEY_DIR "/apps/gimlet/preference"

/** General properties
 *
 *	format:
 *		KEY_ENAGLE_IM : Boolean
 *		KEY_STATUS_DISPLAY : Boolean
 *		KEY_STATUS_PLACEMENT : String
 *			"DESKTOP_DEFAULT", "PANEL" or "ATTACH_FRAME"
 */
#define KEY_ENABLE_IM IIIM_KEY_DIR "/enable"
#define KEY_ENABLE_IM_GIMLET IIIM_GNOME_KEY_DIR "/support"
#define KEY_ENABLE_GIMLET_AUTOSTART IIIM_KEY_DIR "/switcher_autostart"
#define KEY_SYNC_ACTIVATION IIIM_KEY_DIR "/sync_activation"
#define KEY_STATUS_DISPLAY IIIM_KEY_DIR "/status"
#define KEY_STATUS_DISPLAY_GIMLET IIIM_GNOME_KEY_DIR "/status"
#define KEY_STATUS_PLACEMENT IIIM_KEY_DIR "/status_placement"
#define KEY_STATUS_PLACEMENT_GIMLET IIIM_GNOME_KEY_DIR "/status_placement"
#define KEY_STATUS_STYLE_GIMLET "/desktop/gnome/interface/gtk-im-status-style"
#define KEY_INPUT_LANG_POLICY_GIMLET IIIM_GIMLET_KEY_DIR "/input_language_policy"
#define KEY_CONVERSION_ON_GIMLET IIIM_GIMLET_KEY_DIR "/conversion_on_start"
#define KEY_REMEMBER_LAST_LE IIIM_KEY_DIR "/remember_last_le"
#define KEY_LANG_LAST_SELECTION IIIM_KEY_DIR "/language_last_selection"

/**
 * Languages / Scrips properties
 *
 *	format:
 *		This key value would be generated from KEY_LANG_TO_SAVE_LIST and
 *		available language list from iiimd server.
 *		KEY_LANG_TO_USE_LIST : String List
 *		<lang_id>;<lang_ui>;<engine_id>:<engine_ui>;<engine_id>:<engine_ui>...
 *
 *		KEY_LANG_TO_SAVE_LIST : String List
 *		<lang id>;<lang id>...
 *		
 *		This key value would be generated from KEY_LANG_ENGINE_TO_SAVE_LIST
 *		and available language list from iiimd server.
 *		KEY_LANG_ENGINE_TO_USE_LIST : String List
 *		<lang_id>;<engine_id>:<engine_ui>:<hotkeys>;...
 *
 *		KEY_LANG_ENGINE_TO_SAVE_LIST : String List
 *		<lang id>:<engine id>[<hotkeys>]:<engine id>:...
 */
#define KEY_LANG_TO_USE_LIST IIIM_KEY_DIR "/languages_use"
#define KEY_LANG_TO_SAVE_LIST IIIM_KEY_DIR "/languages_save"
#define KEY_LANG_ENGINE_TO_USE_LIST IIIM_KEY_DIR "/language_engines_use"
#define KEY_LANG_ENGINE_TO_SAVE_LIST IIIM_KEY_DIR "/language_engines_save"
#define KEY_USER_DEFINED_NON_USE_LIST IIIM_KEY_DIR "/user_define_non_use"

/**
 *  Trigger keys properties
 *
 *	format:
 *		KEY_TRIGGER : String
 *		KEY_USER_HOTKEYS_TO_DEACTIVATE : String
 *		KEY_USE_SAME_KEYS_TO_DEACTIVATE : Boolean
 *		KEY_TRIGGER_TO_DEACTIVATE : String
 */
#define KEY_TRIGGER IIIM_KEY_DIR "/trigger_keys"
#define KEY_USE_HOTKEYS_TO_DEACTIVATE IIIM_KEY_DIR "/use_trigger_keys_to_deactivate"
#define KEY_USE_SAME_KEYS_TO_DEACTIVATE IIIM_KEY_DIR "/use_same_keys_to_deactivate"
#define KEY_TRIGGER_TO_DEACTIVATE IIIM_KEY_DIR "/deactivate_trigger_keys"

/**
 *  Keyboard properties
 *
 *     format:
 *             KEY_KBD_CKECH : Boolean
 *             KEY_KBD_LAYOUT : Integer
 */
#define KEY_KBD_CHECK IIIM_KEY_DIR "/kbd_check"
#define KEY_KBD_LAYOUT IIIM_KEY_DIR "/kbd_layout"

/**
 * Misc properites
 *
 *	format:
 *		KEY_LANG_SWITCH_POLICY : String
 *			"PER_IC" or "PER_DESKTOP" 
 *		KEY_ON_OFF_POLICY : String
 *			"ACTIVATE" or "NOT_CHANGE"
 *		KEY_ENABLE_LOOKUP : Boolean
 *		KEY_ENABLE_LANG_LIST : Boolean
 *		KEY_LANG_LIST_PLACEMENT : String
 *			"INPUT_LOCATION", "PANEL", "STATUS"
 *		KEY_LANG_LIST_HOTKEY : String
 *			"<Key><Key>...
 *		KEY_ENABLE_MISC_HOTKEY : Boolean
 *		KEY_CYCLE_LANG_HOTKEY : String
 *		KEY_REVERSE_CYCLE_LANG_HOTKEY : String
 *
 */
#define KEY_LANG_SWITCH_POLICY IIIM_KEY_DIR "/lang_switch_policy"
#define KEY_ON_OFF_POLICY IIIM_KEY_DIR  "/on_off_policy"
#define KEY_ENABLE_LOOKUP IIIM_KEY_DIR "/lookup"
#define KEY_ENABLE_LANG_LIST IIIM_KEY_DIR "/lang_list"
#define KEY_LANG_LIST_PLACEMENT IIIM_KEY_DIR "/lang_list_placement"
#define KEY_LANG_LIST_HOTKEY IIIM_KEY_DIR "/lang_list_hotkey"
#define KEY_ENABLE_MISC_HOTKEY IIIM_KEY_DIR "/misc_hotkey"
#define KEY_CYCLE_LANG_HOTKEY IIIM_KEY_DIR "/cycle_lang_hotkey"
#define KEY_REVERSE_CYCLE_LANG_HOTKEY IIIM_KEY_DIR "/reverse_cycle_lang_hotkey"

/*
 * value string in gconf registry
 */
#define V_TRUE "True"
#define V_FALSE "False"

#define V_DESKTOP_DEFAULT "DesktopDefault"
#define V_PANEL "Panel"
#define V_ATTACH_FRAME "AttachFrame"
#define V_NONE "None"
typedef enum {
  S_DESKTOP_DEFAULT,
  S_PANEL,
  S_ATTACH_FRAME,
  S_NONE
} StatusPlacement;

typedef struct {
  GSList *langs;
} LanguageList;

typedef struct {
  gchar *id;
  gchar *ui;
  gboolean kbl;
  gboolean user_defined;
  GSList *engines; /* This list contains EngineDesc */
} LanguageID;

typedef struct {
  GHashTable *engine_table;
} EngineList;

typedef struct {
  gchar *name;
  gchar *source;
  gchar *source_id;
  gchar *id;
  GSList *key_list;
} CustomLayout;

#define USER_DEFINED_ID_SUFFIX "custom"

typedef struct {
  gint mod;
  gint keycode;
} Hotkey;

typedef struct {
  GSList *hotkeys;
} Hotkeys;

typedef struct {
  gchar *id;
  gchar *ui;
  gchar *long_name;
  IIIMCF_input_method iiimcf_im;
  Hotkeys *hotkeys;
} EngineDesc;

#define V_IC "InputContext"
#define V_DESKTOP "Desktop"
typedef enum {
  LS_IC,
  LS_DESKTOP
} LangSwitchPolicy;

#define V_ACTIVATE "Activate"
#define V_DONOT_CHANGE "DonotChange"
typedef enum {
  OO_ACTIVATE,
  OO_DONOT_CHANGE
} OnOffPolicy;

#define V_INPUT_LOCATION "InputLocation"
#define V_STATUS "Status"
typedef enum {
  LL_INPUT_LOCATION,
  LL_PANEL,
  LL_STATUS
} LangListPlacement;

typedef enum {
  FOLLOW_APPLICATION,
  FOLLOW_QUICK_ACCESS_MENU
} GimletInputLanguagePolicy;

typedef struct {
  gboolean b_im_enabled;
  gboolean b_switcher_autostart;
  gboolean b_status_enabled;
  StatusPlacement e_status_placement;
  gboolean b_sync_activation;
  LanguageList *l_languages;
  GSList *l_saved_languages;
  GSList *l_user_defined_non_use;
  EngineList *l_language_engine;
  GSList *l_saved_language_engines;
  Hotkeys *l_trigger_keys;
  Hotkeys *l_secondary_trigger_keys;
  gboolean b_use_trigger_keys_to_deactivate;
  gboolean b_use_same_keys_to_deactivate;
  Hotkeys *l_deactivate_trigger_keys;
  LangSwitchPolicy e_lang_switch_policy;
  OnOffPolicy e_on_off_policy;
  gboolean b_lookup_enabled;
  gboolean b_lang_list_enabled;
  LangListPlacement e_lang_list_placement;
  Hotkeys *l_lang_list_hotkey;
  gboolean b_misc_hotkey_enabled;
  Hotkeys *l_cycle_lang_hotkey;
  Hotkeys *l_reverse_cycle_lang_hotkey;
  gboolean b_kbd_check;
  gchar *s_kbd_layout;
  gint i_kbd_layout;
  gboolean b_remember_last_le;
} IIIMProps;

#define MAX_LANG_LIST_LEN 4096

/*** gimlet compatibility section ***/
typedef enum {
  ON_DESKTOP_PANEL,
  ATTACH_TO_APP_FRAME,
  NONE
} IMStatusPlacement;

typedef enum {
  CONV_OFF = 0,
  CONV_ON = 1
} ICConversionMode;

typedef enum {
  IM_OFF = 0,
  IM_ON
} IMEnabled;

typedef struct {
  IMEnabled im_enabled;
  IMEnabled status_enabled;
  IMEnabled lookup_enabled;
  IMStatusPlacement status_placement;
  IMEnabled switcher_autostart;
} IMSettings;

typedef struct {
  LangSwitchPolicy lang_switch_policy;
  OnOffPolicy on_off_policy;
  int kbd_layout;
  IMEnabled sync_activation;
  IMEnabled remember_last_le;
} IIIMSettings;

#endif
