/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "support.h"
#include "iiim-properties.h"

void general_update_properties (IIIMProps *);
void lang_update_properties (IIIMProps *);
void trigger_update_properties (IIIMProps *);
void misc_update_properties (IIIMProps *);
void keyboard_update_properties (IIIMProps *);
void setget_write_back_to_gconf_and_x_props (IIIMProps *);

static gchar* page_link_ids[] = {
  "page-general",
  "page-lang",
  "page-trigger",
  "page-keyboard",
  "page-misc",
  "intro",
};

static gchar *pageid;

static void update_iiim_props (IIIMProps *iiim_props)
{
  /* Generic section */
  general_update_properties (iiim_props);
  /* Language/Scripts section */
  lang_update_properties (iiim_props);
  /* Trigger Keys section */
  trigger_update_properties (iiim_props);
  /* Keyboard section */
  keyboard_update_properties (iiim_props);
  /* Misc section */
  misc_update_properties (iiim_props);
}

#define IIIM_PANEL_DIR "/usr/bin"
#define IIIM_PANEL_NAME "iiim-panel"

static gboolean
is_panel_running ()
{
  Display *xdisplay;
  Atom switcher_atom;

  xdisplay = gdk_x11_get_default_xdisplay ();
  switcher_atom = XInternAtom (xdisplay, "_IIIM_SWITCHER", FALSE);

  return None != XGetSelectionOwner(xdisplay, switcher_atom);
}

static void start_iiim_panel ()
{
  if (!is_panel_running ())
    {
      int pid = fork ();
      if (pid == 0)
	{
	  char *argv[2];
	  argv[0] = IIIM_PANEL_NAME;
	  argv[1] = NULL;
	  execv (IIIM_PANEL_DIR "/" IIIM_PANEL_NAME, argv);
	  _exit (1);
	}
    }
}

/*-----------------------------------------------------------*/
IIIMProps *util_get_iiimprops ();

void exec_initialize ()
{
  pageid = page_link_ids[5];
}

void exec_help (GtkButton *button, gpointer user_data)
{
  GError *error = NULL;
  gnome_help_display ("iiim-properties.xml", pageid, &error);

  if (error != NULL)
    {
      g_warning (error->message);
      g_error_free (error);
    }
}

void exec_cancel (GtkButton *button, gpointer user_data)
{
  gtk_main_quit ();
}

void exec_apply (GtkButton *button, gpointer user_data)
{
  IIIMProps *iiim_props = util_get_iiimprops ();
  update_iiim_props (iiim_props);
  /* now iiim-props must has everything we need */
  setget_write_back_to_gconf_and_x_props (iiim_props);
  if (iiim_props->b_switcher_autostart)
    start_iiim_panel ();
}

void exec_ok (GtkButton *button, gpointer user_data)
{
  exec_apply (button, user_data);
  gtk_main_quit ();
}

void exec_change_page (guint pagenum)
{
  pageid = page_link_ids[pagenum];
}
