/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <locale.h>

#include <glib.h>

/* X11 */
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "iiimcf.h"
#include "iiim-properties.h"
#include "iiim-properties-trigger.h"

static gboolean initialized = FALSE;
static IIIMCF_handle iiim;
IIIMCF_context context = NULL;
static GHashTable *le_ui_table;

void setget_set_on_CDE ();
GSList *cf_get_engines (gchar *);
static guint IIIMF2GDK();

/*
 * --- on_CDE () --- 
 * Judge CDE or JDS for DESKTOP_DEFAULT
 * status placement attribute.
 * This is a temporaly implementation, so if more appropriate
 * method will be found, this function will be rewritten.
 */
static const char *JDSONLYENV = "SESSIONTYPE";
 
static gboolean on_CDE ()
{
  char *value;

  value = getenv (JDSONLYENV);
  if (value == NULL)
    return TRUE;

  return FALSE;
}

static void create_context ()
{
  IIIMCF_attr attr;
  int n_lang;
  IIIMCF_language *lang_list;
  IIIMCF_event event;
  IIIMF_status st;
  gint i;
  gchar *lang, *lang2, *p;

  st = iiimcf_create_attr (&attr);
  if (st != IIIMF_STATUS_SUCCESS)
    return;

  iiimcf_get_supported_languages (iiim, &n_lang, &lang_list);
  if (!lang_list)
    {
      g_message ("no language enginge is avialable ...\n");
      return;
    }

  lang = g_strdup (setlocale (LC_CTYPE, NULL));
  p = strchr (lang, '.');
  if (p) *p = '\0';

  /* for ko_KR.UTF-8 locale */
  lang2 = g_strdup (lang);
  p = strchr (lang2, '_');
  if (p) *p = '\0';

  for (i=0; i < n_lang; i++)
    {
      char *langid;

      iiimcf_get_language_id (lang_list[i], (const char **)&langid);
      if (!strncmp (lang, langid, strlen (lang)) ||
	  !strncmp (lang2, langid, strlen (lang2)))
	break;
    }

  g_free (lang);
  g_free (lang2);

  /* use the first available language engine if lang isn't matched */
  if (i == n_lang) i = 0;

  iiimcf_attr_put_ptr_value (attr, IIIMCF_ATTR_INPUT_LANGUAGE,
			     lang_list[i]);

  st = iiimcf_create_context (iiim, attr, &context);
  if (st != IIIMF_STATUS_SUCCESS)
    return;

  iiimcf_destroy_attr (attr);

  /* create dummy ic focus event in order to get the hotkey profile
     event from server - dirty hack */
  iiimcf_create_seticfocus_event (&event);

  iiimcf_forward_event (context, event);  
}

/*
 * Initialize iiimcf library
 */
gboolean cf_initialize (Display *display)
{
  IIIMCF_attr attr = NULL;
  IIIMF_status st;

  if (initialized == TRUE)
    return TRUE;
  st = iiimcf_initialize (IIIMCF_ATTR_NULL);
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("iiimcf initialized failed...\n");
      return FALSE;
    }

  st = iiimcf_create_attr (&attr);
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("iiimcf create attr failed...\n");
      return FALSE;
    }

  st = iiimcf_attr_put_string_value (attr, IIIMCF_ATTR_CLIENT_TYPE,
				     "Gtk IIIMCF Module");
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("iiimcf put string value failed...\n");
      return FALSE;
    }

  st = iiimcf_attr_put_string_value (attr, IIIMCF_ATTR_CLIENT_X_DISPLAY_NAME,
				     XDisplayString (display));
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("iiimcf put string value failed...\n");
      return FALSE;
    }

  {
    Atom iiimd;
    Atom client_group;
    Window iiimx;
    char path[PATH_MAX];
    char client_group_id[PATH_MAX];

    iiimd = XInternAtom  (display, "IIIM_SERVER", True);
    if (iiimd != None)
      {
	iiimx = XGetSelectionOwner (display, iiimd);
	if (iiimx != None)
	  {
	    Atom type;
	    int format;
	    unsigned long length;
	    unsigned long nitem;
	    unsigned char *data;
	    data = NULL;
	    XGetWindowProperty (display, iiimx, iiimd,
				0, INT_MAX, False, XA_STRING,
				&type, &format, &nitem, &length, &data);
	    if (data != NULL && !strncmp ("uds:", (char *)data, 4))
	      {
		strncpy (path, (char *)data + 4, sizeof (path));
		path[(sizeof (path)) - 1] = '\0';
		XFree (data);
		st = iiimcf_attr_put_string_value (attr,
						   IIIMCF_ATTR_SERVER_ADDRESS,
						   path);
		if (st != IIIMF_STATUS_SUCCESS)
		  {
		    return FALSE;
		  }
		st = iiimcf_attr_put_string_value (attr,
						   IIIMCF_ATTR_SERVER_SERVICE,
						   "");
		if (st != IIIMF_STATUS_SUCCESS)
		  {
		    return FALSE;
		  }
	      }
	  }
      }
    client_group = XInternAtom (display, "IIIM_CLIENT_GROUP", True);
    if (client_group != NULL)
      {
	iiimx = XGetSelectionOwner (display, client_group);
	if (iiimx != None)
	  {
	    Atom type;
	    int format;
	    unsigned long length;
	    unsigned long nitem;
	    unsigned char *data;
	    data = NULL;
	    XGetWindowProperty (display, iiimx, client_group,
				0, INT_MAX, False, XA_STRING,
				&type, &format, &nitem, &length, &data);
	    if (data != NULL)
	      {
		strncpy (client_group_id, (char *)data, sizeof (client_group_id));
		path[(sizeof (client_group_id)) - 1] = '\0';
		XFree (data);
		st = iiimcf_attr_put_string_value (attr,
						   IIIMCF_ATTR_CLIENT_GROUP,
						   client_group_id);
		if (st != IIIMF_STATUS_SUCCESS)
		  {
		    return FALSE;
		  }

	      }
	  }
      }
  }
  st = iiimcf_create_handle (attr, &iiim);
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("iiimcf create handle failed... \n");
      return FALSE;
    }
  initialized = TRUE;

  create_context ();

  le_ui_table = g_hash_table_new (g_str_hash, g_str_equal);

  /* initialize engine tables *
  cf_get_engines ("dummy");

  /* Solaris specific */
  if (on_CDE())
    {
      setget_set_on_CDE ();
    }

  return TRUE;
}

GSList *
cf_get_user_layout_engine ()
{
  /* return unitle which handles all of keybord layout emulation
     with libkbltrans */
  if (initialized == FALSE)
    return NULL;

  return cf_get_engines ("x-kbl-en");
}


IIIMCF_context
cf_get_context ()
{
  return context;
}

/*
 * convert UTF-16 to UTF-8
 */
static gchar *to_gchar (const IIIMP_card16 *utf16)
{
  if (utf16 == NULL)
    {
      return "NULL";
    }
  else
    {
      return g_utf16_to_utf8 ((const gunichar2 *)utf16,
			      256, NULL, NULL, NULL);
    }
}

EngineDesc *cf_get_engine_desc_with_ui (gchar *engine_ui)
{
  EngineDesc *desc = (EngineDesc *)g_hash_table_lookup (le_ui_table, engine_ui);

  return (EngineDesc *)desc;
}

/*
 * get list of engine which claims to support given language
 */
GSList *cf_get_engines (gchar *lang_id)
{
  IIIMF_status st;
  IIIMCF_input_method *input_methods;
  IIIMCF_language *langs;
  int num_of_langs;
  int n_input_methods;
  const IIIMP_card16 *im_id, *im_hrn, *im_domain;
  gchar *engine_id;
  gchar *engine_ui;
  EngineDesc *ed;

  gint i, j;
  GSList *ret = NULL;

  st = iiimcf_get_supported_input_methods (iiim, &n_input_methods, &input_methods);
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("get supported input methouds failed...\n");
      return (GSList *)NULL;
    }
  for (i = 0; i < n_input_methods; i++)
    {
      st = iiimcf_get_input_method_desc (input_methods[i], &im_id, &im_hrn, &im_domain);
      if (st != IIIMF_STATUS_SUCCESS)
	{
	  g_message ("get input method desc for failed...\n");
	  continue;
	}
      st = iiimcf_get_input_method_languages (input_methods[i], &num_of_langs, &langs);
      if (st != IIIMF_STATUS_SUCCESS)
	{
	  g_message ("get input method languages failed...\n");
	  continue;
	}
      ed = g_new0 (EngineDesc, 1);
      engine_id = to_gchar (im_id);
      engine_ui = to_gchar (im_hrn);
      ed->id = engine_id;
      ed->ui = engine_ui;
      ed->iiimcf_im = input_methods[i];
      g_hash_table_insert (le_ui_table, engine_ui, ed);

      for (j = 0; j < num_of_langs; j++)
	{
	  const char *l;
	  st = iiimcf_get_language_id (langs[j], &l);
	  if (!strcmp (lang_id, l))
	    {
	      ret = g_slist_append (ret, ed);
	      break;
	    }
	}
    }

  return ret;
}

/*
 * get all of supported languages of iiim server
 */
GSList *cf_get_supported_langs ()
{
  IIIMF_status st;
  gint nlangs;
  IIIMCF_language *langs;
  GSList *list = NULL;
  gint i;

  if (!initialized)
    {
      g_message ("iiimcf is not initialized yet...\n");
      return NULL;
    }
  st = iiimcf_get_supported_languages (iiim, &nlangs, &langs);
  if (st != IIIMF_STATUS_SUCCESS)
    {
      g_message ("get supported languages failed...\n");
      return NULL;
    }

  for (i = 0; i < nlangs; i++) {
    const gchar *lang;
    st = iiimcf_get_language_id (langs[i], &lang);
    list = g_slist_append (list, (gchar *)lang);
  }

  return list;
}

gchar *gdk_keyval_name (guint);
/*
 * convert IIIMCF_keyevent to string representation
 */
static gchar *make_string_from_event (IIIMCF_keyevent *key)
{
  guint keyval;
  gchar buf[MAX_HOTKEY_STRING_SIZE];
  gchar *keyname, *s;

  memset (buf, 0, MAX_HOTKEY_STRING_SIZE);
  s = buf;

  if (key->modifier & CONTROL_MOD)
    {
      s = g_stpcpy (s, CONTROL);
      s = g_stpcpy (s, CONCATENATION);
    }
  if (key->modifier & SHIFT_MOD)
    {
      s = g_stpcpy (s, SHIFT);
      s = g_stpcpy (s, CONCATENATION);
    }
  if (key->modifier & ALT_MOD)
    {
      s = g_stpcpy (s, ALT);
      s = g_stpcpy (s, CONCATENATION);
    }

  keyval = IIIMF2GDK(key->keycode);
  keyname = gdk_keyval_name (keyval);

  g_stpcpy (s, keyname);

  return g_strdup (buf);
}

void iiimcf_get_hotkeys (IIIMCF_context, gint *, IIIMCF_hotkey **);
/*
 * gt the hotkey settings
 */
GSList *cf_get_hotkeys (gchar *type)
{
  gint i, k, nkeys = 0;
  IIIMCF_hotkey *hotkeys;
  IIIMCF_keyevent *kev;
  GSList *list = NULL;
  
  if (!initialized)
    {
      g_message ("iiimcf is not initialized yet ...\n");
      return NULL;
    }

  iiimcf_get_hotkeys (context, &nkeys, &hotkeys);
  if (!nkeys) return NULL;

  for (i = 0; i < nkeys; i++)
    if (!strcasecmp (type, hotkeys[i].hotkey_label))
      break;

  if (i == nkeys)
    {
      g_message ("no trigger key is found ...\n");
      return NULL;
    }

  kev = hotkeys[i].keys;
  for (k = 0; k < hotkeys[i].nkeys; k++, kev++)
    {
      gchar *key;

      key = make_string_from_event (kev);
      list = g_slist_append (list, key);
    }

  return list;
}
  
static
guint IIIMF2GDK(guint kv) 
{
  guint kg;
  switch (kv) 
    { 
    case IIIMF_KEYCODE_CANCEL: 
      kg = GDK_Cancel; 
      break; 
    case IIIMF_KEYCODE_BACK_SPACE: 
      kg = GDK_BackSpace; 
      break; 
    case IIIMF_KEYCODE_TAB: 
      kg = GDK_Tab; 
      break; 
    case IIIMF_KEYCODE_ENTER: 
      kg = GDK_Return; 
      break; 
    case IIIMF_KEYCODE_CLEAR: 
      kg = GDK_Clear; 
      break; 
    case IIIMF_KEYCODE_SHIFT: 
      kg = GDK_Shift_L; 
      break; 
    case IIIMF_KEYCODE_CONTROL: 
      kg = GDK_Control_L; 
      break; 
    case IIIMF_KEYCODE_ALT: 
      kg = GDK_Alt_L; 
      break; 
    case IIIMF_KEYCODE_PAUSE: 
      kg = GDK_Pause; 
      break; 
    case IIIMF_KEYCODE_CAPS_LOCK: 
      kg = GDK_Caps_Lock; 
      break; 
    case IIIMF_KEYCODE_KANJI: 
#ifdef linux
      kg = GDK_Kanji;
#else
      kg = GDK_Henkan_Mode;
#endif /* linux */
      break; 
    case IIIMF_KEYCODE_HANGUL: 
      kg = GDK_Hangul; 
      break; 
    case IIIMF_KEYCODE_HANJA: 
      kg = GDK_Hangul_Hanja; 
      break; 
    case IIIMF_KEYCODE_ESCAPE: 
      kg = GDK_Escape; 
      break; 
    case IIIMF_KEYCODE_CONVERT: 
#ifdef linux
      kg = GDK_Henkan_Mode;
#else
      kg = GDK_Kanji;
#endif /* linux */
      break; 
    case IIIMF_KEYCODE_NONCONVERT: 
#ifdef linux
      kg = GDK_Muhenkan;
#else
      kg = GDK_Execute;
#endif /* linux */
      break; 
    case IIIMF_KEYCODE_MODECHANGE: 
      kg = GDK_Mode_switch; 
      break; 
    case IIIMF_KEYCODE_SPACE: 
      kg = GDK_space; 
      break; 
    case IIIMF_KEYCODE_PAGE_UP: 
      kg = GDK_Page_Up; 
      break; 
    case IIIMF_KEYCODE_PAGE_DOWN: 
      kg = GDK_Page_Down; 
      break; 
    case IIIMF_KEYCODE_END: 
      kg = GDK_End; 
      break; 
    case IIIMF_KEYCODE_HOME: 
      kg = GDK_Home; 
      break; 
    case IIIMF_KEYCODE_LEFT: 
      kg = GDK_Left; 
      break; 
    case IIIMF_KEYCODE_UP: 
      kg = GDK_Up; 
      break; 
    case IIIMF_KEYCODE_RIGHT: 
      kg = GDK_Right; 
      break; 
    case IIIMF_KEYCODE_DOWN: 
      kg = GDK_Down; 
      break; 
    case IIIMF_KEYCODE_COMMA: 
      kg = GDK_comma; 
      break; 
    case IIIMF_KEYCODE_MINUS: 
      kg = GDK_minus; 
      break; 
    case IIIMF_KEYCODE_PERIOD: 
      kg = GDK_period; 
      break; 
    case IIIMF_KEYCODE_SLASH: 
      kg = GDK_slash; 
      break; 
    case IIIMF_KEYCODE_0: 
      kg = GDK_0; 
      break; 
    case IIIMF_KEYCODE_1: 
      kg = GDK_1; 
      break; 
    case IIIMF_KEYCODE_2: 
      kg = GDK_2; 
      break; 
    case IIIMF_KEYCODE_3: 
      kg = GDK_3; 
      break; 
    case IIIMF_KEYCODE_4: 
      kg = GDK_4; 
      break; 
    case IIIMF_KEYCODE_5: 
      kg = GDK_5; 
      break; 
    case IIIMF_KEYCODE_6: 
      kg = GDK_6; 
      break; 
    case IIIMF_KEYCODE_7: 
      kg = GDK_7; 
      break; 
    case IIIMF_KEYCODE_8: 
      kg = GDK_8; 
      break; 
    case IIIMF_KEYCODE_9: 
      kg = GDK_9; 
      break; 
    case IIIMF_KEYCODE_SEMICOLON: 
      kg = GDK_semicolon; 
      break; 
    case IIIMF_KEYCODE_EQUALS: 
      kg = GDK_equal; 
      break; 
    case IIIMF_KEYCODE_A: 
      kg = GDK_a; 
      break; 
    case IIIMF_KEYCODE_B: 
      kg = GDK_b; 
      break; 
    case IIIMF_KEYCODE_C: 
      kg = GDK_c; 
      break; 
    case IIIMF_KEYCODE_D: 
      kg = GDK_d; 
      break; 
    case IIIMF_KEYCODE_E: 
      kg = GDK_e; 
      break; 
    case IIIMF_KEYCODE_F: 
      kg = GDK_f; 
      break; 
    case IIIMF_KEYCODE_G: 
      kg = GDK_g; 
      break; 
    case IIIMF_KEYCODE_H: 
      kg = GDK_h; 
      break; 
    case IIIMF_KEYCODE_I: 
      kg = GDK_i; 
      break; 
    case IIIMF_KEYCODE_J: 
      kg = GDK_j; 
      break; 
    case IIIMF_KEYCODE_K: 
      kg = GDK_k; 
      break; 
    case IIIMF_KEYCODE_L: 
      kg = GDK_l; 
      break; 
    case IIIMF_KEYCODE_M: 
      kg = GDK_m; 
      break; 
    case IIIMF_KEYCODE_N: 
      kg = GDK_n; 
      break; 
    case IIIMF_KEYCODE_O: 
      kg = GDK_o; 
      break; 
    case IIIMF_KEYCODE_P: 
      kg = GDK_p; 
      break; 
    case IIIMF_KEYCODE_Q: 
      kg = GDK_q; 
      break; 
    case IIIMF_KEYCODE_R: 
      kg = GDK_r; 
      break; 
    case IIIMF_KEYCODE_S: 
      kg = GDK_s; 
      break; 
    case IIIMF_KEYCODE_T: 
      kg = GDK_t; 
      break; 
    case IIIMF_KEYCODE_U: 
      kg = GDK_u; 
      break; 
    case IIIMF_KEYCODE_V: 
      kg = GDK_v; 
      break; 
    case IIIMF_KEYCODE_W: 
      kg = GDK_w; 
      break; 
    case IIIMF_KEYCODE_X: 
      kg = GDK_x; 
      break; 
    case IIIMF_KEYCODE_Y: 
      kg = GDK_y; 
      break; 
    case IIIMF_KEYCODE_Z: 
      kg = GDK_z; 
      break; 
    case IIIMF_KEYCODE_OPEN_BRACKET: 
      kg = GDK_bracketleft; 
      break; 
    case IIIMF_KEYCODE_BACK_SLASH: 
      kg = GDK_backslash; 
      break; 
    case IIIMF_KEYCODE_CLOSE_BRACKET: 
      kg = GDK_bracketright; 
      break; 
    case IIIMF_KEYCODE_NUMPAD0: 
      kg = GDK_KP_0; 
      break; 
    case IIIMF_KEYCODE_NUMPAD1: 
      kg = GDK_KP_1; 
      break; 
    case IIIMF_KEYCODE_NUMPAD2: 
      kg = GDK_KP_2; 
      break; 
    case IIIMF_KEYCODE_NUMPAD3: 
      kg = GDK_KP_3; 
      break; 
    case IIIMF_KEYCODE_NUMPAD4: 
      kg = GDK_KP_4; 
      break; 
    case IIIMF_KEYCODE_NUMPAD5: 
      kg = GDK_KP_5; 
      break; 
    case IIIMF_KEYCODE_NUMPAD6: 
      kg = GDK_KP_6; 
      break; 
    case IIIMF_KEYCODE_NUMPAD7: 
      kg = GDK_KP_7; 
      break; 
    case IIIMF_KEYCODE_NUMPAD8: 
      kg = GDK_KP_8; 
      break; 
    case IIIMF_KEYCODE_NUMPAD9: 
      kg = GDK_KP_9; 
      break; 
    case IIIMF_KEYCODE_MULTIPLY: 
      kg = GDK_KP_Multiply; 
      break; 
    case IIIMF_KEYCODE_ADD: 
      kg = GDK_KP_Add; 
      break; 
    case IIIMF_KEYCODE_SEPARATOR: 
      kg = GDK_KP_Separator; 
      break; 
    case IIIMF_KEYCODE_SUBTRACT: 
      kg = GDK_KP_Subtract; 
      break; 
    case IIIMF_KEYCODE_DECIMAL: 
      kg = GDK_KP_Decimal; 
      break; 
    case IIIMF_KEYCODE_DIVIDE: 
      kg = GDK_KP_Divide; 
      break; 
    case IIIMF_KEYCODE_F1: 
      kg = GDK_F1; 
      break; 
    case IIIMF_KEYCODE_F2: 
      kg = GDK_F2; 
      break; 
    case IIIMF_KEYCODE_F3: 
      kg = GDK_F3; 
      break; 
    case IIIMF_KEYCODE_F4: 
      kg = GDK_F4; 
      break; 
    case IIIMF_KEYCODE_F5: 
      kg = GDK_F5; 
      break; 
    case IIIMF_KEYCODE_F6: 
      kg = GDK_F6; 
      break; 
    case IIIMF_KEYCODE_F7: 
      kg = GDK_F7; 
      break; 
    case IIIMF_KEYCODE_F8: 
      kg = GDK_F8; 
      break; 
    case IIIMF_KEYCODE_F9: 
      kg = GDK_F9; 
      break; 
    case IIIMF_KEYCODE_F10: 
      kg = GDK_F10; 
      break; 
    case IIIMF_KEYCODE_F11: 
      kg = GDK_F11; 
      break; 
    case IIIMF_KEYCODE_F12: 
      kg = GDK_F12; 
      break; 
    case IIIMF_KEYCODE_DELETE: 
      kg = GDK_Delete; 
      break; 
    case IIIMF_KEYCODE_DEAD_GRAVE: 
      kg = GDK_dead_grave; 
      break; 
    case IIIMF_KEYCODE_DEAD_ACUTE: 
      kg = GDK_dead_acute; 
      break; 
    case IIIMF_KEYCODE_DEAD_CIRCUMFLEX: 
      kg = GDK_dead_circumflex; 
      break; 
    case IIIMF_KEYCODE_DEAD_TILDE: 
      kg = GDK_dead_tilde; 
      break; 
    case IIIMF_KEYCODE_DEAD_MACRON: 
      kg = GDK_dead_macron; 
      break; 
    case IIIMF_KEYCODE_DEAD_BREVE: 
      kg = GDK_dead_breve; 
      break; 
    case IIIMF_KEYCODE_DEAD_ABOVEDOT: 
      kg = GDK_dead_abovedot; 
      break; 
    case IIIMF_KEYCODE_DEAD_DIAERESIS: 
      kg = GDK_dead_diaeresis; 
      break; 
    case IIIMF_KEYCODE_DEAD_ABOVERING: 
      kg = GDK_dead_abovering; 
      break; 
    case IIIMF_KEYCODE_DEAD_DOUBLEACUTE: 
      kg = GDK_dead_doubleacute; 
      break; 
    case IIIMF_KEYCODE_DEAD_CARON: 
      kg = GDK_dead_caron; 
      break; 
    case IIIMF_KEYCODE_DEAD_CEDILLA: 
      kg = GDK_dead_cedilla; 
      break; 
    case IIIMF_KEYCODE_DEAD_OGONEK: 
      kg = GDK_dead_ogonek; 
      break; 
    case IIIMF_KEYCODE_DEAD_IOTA: 
      kg = GDK_dead_iota; 
      break; 
    case IIIMF_KEYCODE_DEAD_VOICED_SOUND: 
      kg = GDK_dead_voiced_sound; 
      break; 
    case IIIMF_KEYCODE_DEAD_SEMIVOICED_SOUND: 
      kg = GDK_dead_semivoiced_sound; 
      break; 
    case IIIMF_KEYCODE_NUM_LOCK: 
      kg = GDK_Num_Lock; 
      break; 
    case IIIMF_KEYCODE_SCROLL_LOCK: 
      kg = GDK_Scroll_Lock; 
      break; 
    case IIIMF_KEYCODE_AMPERSAND: 
      kg = GDK_ampersand; 
      break; 
    case IIIMF_KEYCODE_ASTERISK: 
      kg = GDK_asterisk; 
      break; 
    case IIIMF_KEYCODE_QUOTEDBL: 
      kg = GDK_quotedbl; 
      break; 
    case IIIMF_KEYCODE_LESS: 
      kg = GDK_less; 
      break; 
    case IIIMF_KEYCODE_PRINTSCREEN: 
      kg = GDK_Print; 
      break; 
    case IIIMF_KEYCODE_INSERT: 
      kg = GDK_Insert; 
      break; 
    case IIIMF_KEYCODE_HELP: 
      kg = GDK_Help; 
      break; 
    case IIIMF_KEYCODE_META: 
      kg = GDK_Meta_L; 
      break; 
    case IIIMF_KEYCODE_GREATER: 
      kg = GDK_greater; 
      break; 
    case IIIMF_KEYCODE_BRACELEFT: 
      kg = GDK_braceleft; 
      break; 
    case IIIMF_KEYCODE_BRACERIGHT: 
      kg = GDK_braceright; 
      break; 
    case IIIMF_KEYCODE_BACK_QUOTE: 
      kg = GDK_grave; 
      break; 
    case IIIMF_KEYCODE_QUOTE: 
      kg = GDK_apostrophe; 
      break; 
    case IIIMF_KEYCODE_KP_UP: 
      kg = GDK_KP_Up; 
      break; 
    case IIIMF_KEYCODE_KP_DOWN: 
      kg = GDK_KP_Down; 
      break; 
    case IIIMF_KEYCODE_KP_LEFT: 
      kg = GDK_KP_Left; 
      break; 
    case IIIMF_KEYCODE_KP_RIGHT: 
      kg = GDK_KP_Right; 
      break; 
    case IIIMF_KEYCODE_KATAKANA: 
      kg = GDK_Katakana; 
      break; 
    case IIIMF_KEYCODE_HIRAGANA: 
      kg = GDK_Hiragana; 
      break; 
    case IIIMF_KEYCODE_FULL_WIDTH: 
      kg = GDK_Zenkaku; 
      break; 
    case IIIMF_KEYCODE_HALF_WIDTH: 
      kg = GDK_Hankaku; 
      break; 
    case IIIMF_KEYCODE_ROMAN_CHARACTERS: 
      kg = GDK_Romaji; 
      break; 
    case IIIMF_KEYCODE_PREVIOUS_CANDIDATE: 
      kg = GDK_PreviousCandidate; 
      break; 
    case IIIMF_KEYCODE_CODE_INPUT: 
      kg = GDK_Codeinput; 
      break; 
    case IIIMF_KEYCODE_JAPANESE_KATAKANA: 
      kg = GDK_Katakana; 
      break; 
    case IIIMF_KEYCODE_JAPANESE_HIRAGANA: 
      kg = GDK_Hiragana; 
      break; 
    case IIIMF_KEYCODE_KANA_LOCK: 
      kg = GDK_Kana_Lock; 
      break; 
    case IIIMF_KEYCODE_AT: 
      kg = GDK_at; 
      break; 
    case IIIMF_KEYCODE_COLON: 
      kg = GDK_colon; 
      break; 
    case IIIMF_KEYCODE_CIRCUMFLEX: 
      kg = GDK_asciicircum; 
      break; 
    case IIIMF_KEYCODE_DOLLAR: 
      kg = GDK_dollar; 
      break; 
    case IIIMF_KEYCODE_EURO_SIGN: 
      kg = GDK_EuroSign; 
      break; 
    case IIIMF_KEYCODE_EXCLAMATION_MARK: 
      kg = GDK_exclam; 
      break; 
    case IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK: 
      kg = GDK_exclamdown; 
      break; 
    case IIIMF_KEYCODE_LEFT_PARENTHESIS: 
      kg = GDK_parenleft; 
      break; 
    case IIIMF_KEYCODE_NUMBER_SIGN: 
      kg = GDK_numbersign; 
      break; 
    case IIIMF_KEYCODE_PLUS: 
      kg = GDK_plus; 
      break; 
    case IIIMF_KEYCODE_RIGHT_PARENTHESIS: 
      kg = GDK_parenright; 
      break; 
    case IIIMF_KEYCODE_UNDERSCORE: 
      kg = GDK_underscore; 
      break; 
    case IIIMF_KEYCODE_F13: 
      kg = GDK_F13; 
      break; 
    case IIIMF_KEYCODE_F14: 
      kg = GDK_F14; 
      break; 
    case IIIMF_KEYCODE_F15: 
      kg = GDK_F15; 
      break; 
    case IIIMF_KEYCODE_F16: 
      kg = GDK_F16; 
      break; 
    case IIIMF_KEYCODE_F17: 
      kg = GDK_F17; 
      break; 
    case IIIMF_KEYCODE_F18: 
      kg = GDK_F18; 
      break; 
    case IIIMF_KEYCODE_F19: 
      kg = GDK_F19; 
      break; 
    case IIIMF_KEYCODE_F20: 
      kg = GDK_F20; 
      break; 
    case IIIMF_KEYCODE_F21: 
      kg = GDK_F21; 
      break; 
    case IIIMF_KEYCODE_F22: 
      kg = GDK_F22; 
      break; 
    case IIIMF_KEYCODE_F23: 
      kg = GDK_F23; 
      break; 
    case IIIMF_KEYCODE_F24: 
      kg = GDK_F24; 
      break; 
    case IIIMF_KEYCODE_UNDO: 
      kg = GDK_Undo; 
      break; 
    case IIIMF_KEYCODE_FIND: 
      kg = GDK_Find; 
      break; 
    default: 
      kg = (unsigned int) (kv & 0x7fffffff); 
      break; 
    } 
    return (kg);
}
