/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom.xml;

import com.sun.g11n.vkb.*;
import com.sun.g11n.vkb.geom.*;
import static com.sun.g11n.vkb.Main.*;

import java.io.*;
import java.util.*;
import java.util.jar.*;

import javax.xml.parsers.*;

/**
 *
 * @author naoyuki
 */
public class XMLGeometryCollection implements GeometryCollection {
    
    private Set<Geometry> geoms;
    @Override public Set<Geometry> getGeometrySet() {
        return geoms;
    }
    
    @Override public Geometry getGeometryByName(String name) {
        if (name == null) {
            return null;
        }
        for (Geometry geom : geoms) {
            if (name.equals(geom.getDescription())) {
                return geom;
            }
        }
        return null;
    }

    private static GeometryCollection geometryCollection;
    public static GeometryCollection getInstance() {
        if (geometryCollection == null) {
            geometryCollection = new XMLGeometryCollection();
        }
        return geometryCollection;
    }
    
    private XMLGeometryCollection() {
        geoms = new HashSet<Geometry>();
        
        SAXHandler handler = new SAXHandler(geoms);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        } catch(Exception e) {
            e.printStackTrace();
            error("SAX Parser configuration error.");
        }
        
        String geomDataFileName = getXMLGeometryData();


        Set<InputStream> streamSet = new HashSet<InputStream>();
        if (geomDataFileName.endsWith(JAR_SUFFIX)) {
            try {
                JarFile jf = new JarFile(geomDataFileName);
                Enumeration<JarEntry> entries = jf.entries();
                for (; entries.hasMoreElements();) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().endsWith(XML_SUFFIX)) {
                        InputStream is = jf.getInputStream(entry);
                        streamSet.add(is);
                    }
                }
            } catch(Exception e) {
                try {
                    // for prototype testing : delete at release
                    String dataName = geomDataFileName.substring(geomDataFileName.lastIndexOf('/') + 1);
                    String protoDataName = System.getProperty("user.home") + File.separator + dataName;
                    JarFile jfp = new JarFile(protoDataName);
                    Enumeration<JarEntry> entries = jfp.entries();
                    for (; entries.hasMoreElements();) {
                        JarEntry entry = entries.nextElement();
                        if (entry.getName().endsWith(XML_SUFFIX)) {
                            InputStream is = jfp.getInputStream(entry);
                            streamSet.add(is);
                        }
                    }
                } catch(Exception e2) {
                    e2.printStackTrace();
                    error("JAR:" + geomDataFileName + " can not be read.");
                }
            }
        } else if (geomDataFileName.endsWith(XML_SUFFIX)) {
            try {
                FileInputStream fis = new FileInputStream(geomDataFileName);
                streamSet.add(fis);
            } catch(Exception e) {
                e.printStackTrace();
                error("XML:" + geomDataFileName + " can not be read.");
            }
        }
        for (InputStream is : streamSet) {
            try {
                saxParser.parse(is, handler);
            } catch(Exception e) {
                e.printStackTrace();
                // continue process with ignoring error xml
            }
        }
    }
    
    static final String JAR_SUFFIX = ".vkz";
    static final String XML_SUFFIX = ".vkx";

    
    /* Test method */
    public static void main(String[] args) {
        initProperties();
        GeometryCollection geoms = getInstance();
    }
}
