/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Main.java
 *
 * Created on 2007/11/30, 15:14
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.SymbolCollection;
import com.sun.g11n.vkb.geom.GeometryCollection;
import com.sun.g11n.vkb.geom.xkb.XKBGeometryCollection;
import com.sun.g11n.vkb.sym.xml.XMLSymbol;

import com.sun.g11n.vkb.geom.xml.XMLGeometryCollection;

import java.util.*;
import java.awt.Point;
import javax.swing.UIManager;

/**
 *
 * @author naoyuki
 */
public class Main {    
    private static ResourceBundle props;
    private static IMInterface imInterface = null;
    private static GeometryCollection geometryCollection;
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        parseArg(args);
        initProperties();

        String geometryDataType = getGeometryDataType();
        if (geometryDataType.equals("XML")) {
            geometryCollection = XMLGeometryCollection.getInstance();
        } else if (geometryDataType.equals("XKB")) {
            geometryCollection = XKBGeometryCollection.getInstance(args);
        }

        // Set Swing Look&Feel
        try {
            UIManager.setLookAndFeel(getSwingLFName());
        } catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } catch (Exception e2) {
                e.printStackTrace();
            }
        }

        final VKBManager manager = VKBManager.getInstance();
        int x = 0;
        int y = 0;
        // ControlPanel is disabled (by xDesign review)
        if (Prefs.getControlPanelVisibility()) {
            ControlPanel ctlp = ControlPanel.getInstance();
            Point pos = Prefs.getControlPanelPosition();
            ctlp.setLocation(pos);
            ctlp.setVisible(true);
            int w = ctlp.getWidth();
            int h = ctlp.getHeight();
            POS p = getDefaultKBDPosition();
            switch (p) {
                case TOP: // not supported
                case LEFT: // not supported
                case RIGHT: 
                    x = w;
                    break;
                case BOTTOM:
                    y = h;
            }
        }
        if (Prefs.getKeyboardFrames().size() < 1) {
            manager.newKeyboardFrame();
        }
    }

    /*
     * parse argument:
     *     -keepScale : bingup keyboard which size is the one which was at last exit
     */
    private static void parseArg(String[] args) {
        keepScale = false;
        for (String arg : args) {
            if (arg.equals("-keepScale")) {
                keepScale = true;
            }
        }
    }
    private static boolean keepScale;
    static boolean getKeepScale() {
        return keepScale;
    }




    /*
     * return SymbolCollection to be used for filling symbol list
     * this list is chaged dynamically, so it should not be caheched
     */
    static SymbolCollection getSymbolCollection() {
        return (SymbolCollection)XMLSymbol.getInstance();
    }
    /*
     * returns GeometryCollection to be used for filling geometry list
     */
    static GeometryCollection getGeometryCollection() {
        return geometryCollection;
    }
    
    /*
     * return TransferStub implementation object for sending
     * string to client application
     */
    static IMInterface getIMInterface() {
        if (imInterface == null) {
            // determine class for tarnsfer event to client
            String imInterfaceClassName = getIMInterfaceClassName();
            try {
                Class imInterfaceClass = Class.forName(imInterfaceClassName);
                imInterface = (IMInterface) imInterfaceClass.newInstance();
            } catch (UnsatisfiedLinkError le) {
                System.err.println(imInterfaceClassName + " is not found.");
                System.err.println("Virtual Keybaord will not work as on screen keyboard.");
                imInterface = new PseudoIMInterface_Impl();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imInterface;
    }
    
    //////////////////////// Propertiy handling stuff /////////////////////////
    public static void initProperties() {
        props = ResourceBundle.getBundle("com.sun.g11n.vkb.vkb-default");
        // read user's property file here and override system default
    }
    
    /*
     * To prevent spread property keys everywhere, keep property access static methods here
     */
    public static String getGeometryDataType() {
        return props.getString("vkb.geometry_data");
    }
    
    public static String getXMLGeometryData() {
        return props.getString("vkb.xml.geometry_file");
    }
    
    public static String getIMInterfaceClassName() {
        return props.getString("vkb.iminterface_class");
    }

    public static String getSwingLFName() {
        return props.getString("vkb.swing_lf");
    }
    
    public static String[] getSendLayoutCommand() {
        String[] ret;
        String command = props.getString("vkb.export_layout.command");
        if (command == null) {
            return null;
        }
        String argument = null;
        try {
            argument = props.getString("vkb.export_layout.argument");
        } catch(MissingResourceException e) {
            argument = null;
        }
        if (argument != null) {
            ret = new String[2];
            ret[1] = argument;
        } else {
            ret = new String[1];
        }
        ret[0] = command;
        return ret;
    }
    
    public static FrameStyle getDefaultFrameStyle() {
        String style = props.getString("vkb.frame_style");
        if (style.equals("SINGLE_FRAME")) {
            return FrameStyle.SINGLE_FRAME;
        } else if (style.equals("MULTIPLE_FRAME")) {
            return FrameStyle.MULTIPLE_FRAME;
        } else if (style.equals("TAB_FRAME")) {
            return FrameStyle.TAB_FRAME;
        }
        return FrameStyle.INTERNAL_FRAME;
    }
    
    public static boolean getShowAllSection() {
        String section =  props.getString("vkb.show_all_section");
        return checkBool(section);
    }
    
    public static int getInitialFrameWidth() {
        String ws = props.getString("vkb.frame_initial_width");
        try {
            int i = Integer.parseInt(ws);
            return i;
        } catch(NumberFormatException e) {
            e.printStackTrace();
            return 100; // apearently strange width for not hiding error
        }
    }
    
    public static int getInitialFrameHeight() {
        String hs = props.getString("vkb.frame_initial_height");
        try {
            int i = Integer.parseInt(hs);
            return i;
        } catch(NumberFormatException e) {
            e.printStackTrace();
            return 10;
        }
    }
    
    public static boolean getDefaultResizable() {
        return checkBool(props.getString("vkb.canvas_resizable"));
    }
    
    public static boolean getMaxmizeFrame() {
        return checkBool(props.getString("vkb.maxmize_frame"));
    }
    
    public static String getSymbolTableFileName() {
        return props.getString("vkb.xkb.symboltable_file");
    }
    
    /*
     * Translate key name to normal keyboard top label (CTRL -> Control)
     */
    public static String getKeyLabel(String name) {
        try {
            return props.getString("vkb.keylabel." + name);
        } catch (MissingResourceException e) {
            // System.out.println(e.getMessage());
            return "";
        }
    }
    /*
     * Default scale factor for Geometry data number
     */
    public static float getDefaultScaleFactor() {
        String scaleStr = props.getString("vkb.xkb.scale_factor");
        try {
            float f = Float.parseFloat(scaleStr);
            return f;
        } catch(NumberFormatException e) {
            e.printStackTrace();
            return (float)1;
        }
    }
    
    /*
     * Default keyboard position relative to ControlPanel
     */
    public static enum POS {
        TOP, RIGHT, BOTTOM, LEFT,
    }
    public static POS getDefaultKBDPosition() {
        String pos = props.getString("vkb.frame_pos");
        if (pos.equals("TOP")) {
            return POS.TOP;
        }
        if (pos.equals("LEFT")) {
            return POS.LEFT;
        }
        if (pos.equals("BOTTOM")) {
            return POS.BOTTOM;
        }
        return POS.RIGHT;
    }
    
    /*
     * Default geometry type
     */
    public static String getDefaultGeometryName() {
        return props.getString("vkb.default.geometry");
    }
    
    /*
     * Default symbol type
     */
    public static String getDefaultSymbolName() {
        return props.getString("vkb.default.symbol");
    }
    
    /*
     * Toolbar is visible or not.
     */
    public static boolean getDefaultControlPanelVisibility() {
        return checkBool(props.getString("vkb.control_panel_visible"));
    }
    
    /*
     * System directory for saving cusmomized layout data for system wide use.
     */
    public static String getSystemConfigDir() {
        String dir = props.getString("vkb.system_config_dir");
        return dir;
    }
    
    /*
     * User directory for saving customized layout data for user only use.
     */
    public static String getUserConfigDir() {
        String dir = props.getString("vkb.user_config_dir");
        if (dir.startsWith("$HOME")) {
            String home = System.getProperty("user.home");
            dir = dir.replace("$HOME", home);
        }
        return dir;
    }
    
    /*
     * User config file contains non-use user defined layout
     */
    public static String getUserConfigFile() {
        return props.getString("vkb.user_config_file");
    }
    
    /*
     * File name suffix for customized layout data
     */
    public static String getLayoutFileSuffix() {
        return props.getString("vkb.layout_data_suffix");
    }
    
    /*
     * default Tooltip on/off
     */
    public static boolean getDefaultTooltipEnabled() {
        return checkBool(props.getString("vkb.tooltip"));
    }

    /*
     * default sync mode
     */
    public static boolean getDefaultSyncMode() {
        return checkBool(props.getString("vkb.sync"));
    }
    
    /*
     * lang item per menu
     */
    public static int getLangItemPerMenu() {
        String count = props.getString("vkb.lang_item_per_menu");
        try {
            int i = Integer.parseInt(count);
            return i;
        } catch(NumberFormatException e) {
            e.printStackTrace();
            return 15;
        }
    }
    /*
     * help type : gnome-help, java-help or browser
     */
    public static String getHelpType() {
        return props.getString("vkb.help.type");
    }
    public static String getHelpBrowser() {
        return props.getString("vkb.help.browser");
    }
    public static String getHelpFile() {
        return props.getString("vkb.help.browser.file");
    }
    
    // utility functions
    private static boolean checkBool(String b) {
        String bb = b.toLowerCase();
        if (bb.equals("true"))
            return true;
        return false;
    }
    
    public static void error(String err) {
        new Throwable("fatal error: " + err).printStackTrace();
        System.exit(1);
    }
    
    public static void warning(String warn) {
        new Throwable("warning: " + warn).printStackTrace();
    }
}
