/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <iconv.h>
#include "kbltrans.h"
#include "kbltrans_impl.h"

static int iconv_init = 0;
static iconv_t utf8to16_cd;
static size_t ICONV_BUF_SIZ = 256;
static char *iconv_buf;

static void
init_iconv ()
{
  utf8to16_cd = iconv_open ("UTF-16", "UTF-8");
  if (utf8to16_cd != (iconv_t)-1) {
    iconv_buf = (char *)XCALLOC (UTF16_CHAR, ICONV_BUF_SIZ);
    iconv_init = 1;
  }
}

static int
has_byte_order_mark (UTF16_CHAR *utf16) {
  if (utf16[0] == 0xfffe || utf16[0] == 0xfeff) {
    return 1;
  }
  return 0;
}

UTF16_CHAR *
utf8_to_utf16 (char *utf8)
{
  size_t in_size, left;
  char *out_buf;
  size_t ret;
  const char *in_buf = (const char *)utf8;
  UTF16_CHAR *alloc_str;

  if (utf8 == NULL || strlen (utf8) == 0) {
    return NULL;
  }

  if (iconv_init == 0) {
    init_iconv ();
  }

  if (iconv_init) {
    in_size = strlen (utf8);

    if (in_size + 1 > ICONV_BUF_SIZ) {
      XFREE (iconv_buf);
      ICONV_BUF_SIZ = in_size + 256;
      iconv_buf = (char *)XCALLOC (UTF16_CHAR, ICONV_BUF_SIZ);
    }
    left = ICONV_BUF_SIZ;
    out_buf = iconv_buf;
    ret = iconv (utf8to16_cd, &in_buf, &in_size, &out_buf, &left);
    if (ret != (size_t)-1) {
      if (has_byte_order_mark ((UTF16_CHAR *)iconv_buf)) {
	iconv_buf += 2;
	left += 2;
      }
      size_t alloc_len = ICONV_BUF_SIZ - left;
      alloc_str = XCALLOC (UTF16_CHAR, alloc_len / 2 + 1);
      memcpy (alloc_str, iconv_buf, alloc_len);
      alloc_str[alloc_len / 2] = 0;

      return alloc_str;
    }
  }
  return NULL;
}
