/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * SymbolsReader.java
 *
 * Created on 2006/07/10, 18:23
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.io.*;
import java.util.*;

/**
 *
 * @author naoyuki
 */
public class SymbolsReader {
    
    private Set<SymbolTable> symbolTableSet;
    private String baseDir = null;
    private Map<String, SymbolElmTbl> tableMap;
    
    /** Creates a new instance of SymbolsReader */
    public SymbolsReader(File dir) throws IOException {
        baseDir = dir.getAbsolutePath();
        String[] fileList = dir.list();
        symbolTableSet = new HashSet<SymbolTable>();
        readFiles(dir, fileList);
        // make tableMap from symbolTableSet
        tableMap = makeTableMap();
    }
    
    public Map<String, SymbolElmTbl> getTableMap() {
        return tableMap;
    }
    
    private Map<String, SymbolElmTbl> makeTableMap() {
        String fileName;
        Map<String, SymbolElmTbl> map = new HashMap<String, SymbolElmTbl>();
        for (SymbolTable symTbl : symbolTableSet) {
            fileName = symTbl.getName();
            SortedSet<String> elmKeySet = symTbl.getKeys();
            for (String elmKey : elmKeySet) {
                SymbolElmTbl elmTbl = symTbl.getSymbolTable(elmKey);
                String elmName = fileName + "(" + elmKey + ")";
                map.put(elmName, elmTbl);
            }
        }
        return map;
    }

    private void readFiles(File parent, String[] strArray) throws  IOException {
        for (String fileName : strArray) {

            File f = new File(parent, fileName);
            if (f.isDirectory()) {
                readFiles(f, f.list()); // recursive call
            } else if (f.canRead()) {
                InputStream in = new FileInputStream(f);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = null;
                VariantOption opt = null;
                // f.getName() should be replaced with <full path> - <base path> impl
                // to avoid duplicate name in different dir
                String tableName;
                String filePath = f.getAbsolutePath();
                int baseLen = baseDir.length();
                tableName = filePath.substring(baseLen + 1);
                
                SymbolTable symbolTbl = new SymbolTable(tableName);
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if (line.length() == 0 || line.startsWith("//")) {
                        continue;
                    }
                    opt = setOptions(opt, line);  

                    if (line.contains("xkb_symbols")) {
                        String name = Util.getTypeName(line);
                        SymbolElmTbl elm = new SymbolElmTbl(reader, opt);
                        symbolTbl.add(name, elm);
                    }
                }
                symbolTableSet.add(symbolTbl);
            } else {
                System.err.println(" File : " + fileName + " is not readable.");
            }
        }
    }

    private static VariantOption setOptions(VariantOption opt, String line) {
        opt = checkOpt(line, Const.DEFAULT, opt);
        opt = checkOpt(line, Const.PARTIAL, opt);
        opt = checkOpt(line, Const.HIDDEN, opt);
        opt = checkOpt(line, Const.ALPHA_KEY, opt);
        opt = checkOpt(line, Const.KEYPAD_KEY, opt);
        opt = checkOpt(line, Const.FUNC_KEY, opt);
        opt = checkOpt(line, Const.ALTGRP_KEY, opt);
        return opt;
    }
    
    private static VariantOption checkOpt(String line, String key, VariantOption opt) {
        if (line.contains(key)) {
            if (opt == null) {
                opt = new VariantOption();
            }
            opt.setOpt(key);
        }
        return opt;
    }
    

}
