/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * SymbolElmTbl.java
 *
 * Created on 2006/07/11, 13:45
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.io.*;
import java.util.*;

/**
 *
 * @author naoyuki
 */
public class SymbolElmTbl {
    

    private Map<String, GLSymbol> codeMap;
    private VariantOption option;
    private Set<String> includeSet;
    private Map<String, GLSymbol> overrideMap;
    
    public VariantOption getOption() {
        return option;
    }
    
    /** Creates a new instance of SymbolElmTbl */
    public SymbolElmTbl(BufferedReader reader, VariantOption option)  throws IOException {
        this.option = option;
        
        codeMap = new HashMap<String, GLSymbol>();
        
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            /*
             * keyword : key
             * format:
             *      key <code> { [G1L1, G1L2], [G2L1, G2L2] };
             *   or
             *      key <code> { type = "type name", symbols[Group?] = [ ?L1, ?L2 ] };
             */
            if (line.startsWith("key ") || line.startsWith("key\t")) {
                line = Util.trimComment(line);

                while (!line.endsWith("};")) {
                    String line2 = reader.readLine();
                    if (line2 == null) {
                        System.err.println(" symbol data is broken. " + line);
                        System.exit(1);
                    }
                    line2 = line2.trim();
                    line2 = Util.trimComment(line2);
                    line += (" " + line2);
                }
                String[] items = line.split("[ \t]+", 3);
                if (items.length != 3) {
                    System.err.println(" symbol data is broken... : " + items.length + "/" + line);
                    System.exit(1);
                }
                codeMap.put(items[1], new GLSymbol(items[2].trim()));
                continue;
            } else if (line.startsWith("include ")) {
                line = Util.trimComment(line);
                if (includeSet == null) {
                    includeSet = new HashSet<String>();
                }
                includeSet.add(Util.getTypeName(line));
                continue;
            } else if (line.startsWith("override")) {
                line = Util.trimComment(line);
                
                while (!line.endsWith("};")) {
                    String line3 = reader.readLine();
                    if (line3 == null) {
                        System.err.println(" symbol data is broken. " + line);
                        System.exit(1);
                    }
                    line3 = line3.trim();
                    line3 = Util.trimComment(line3);
                    line += (" " + line3);
                }
                if (overrideMap == null) {
                    overrideMap = new HashMap<String, GLSymbol>();
                }

                String[] items = line.split("[ \t]", 4);
                if (items.length != 4) {
                    System.err.println(" symbol data is broken. " + items.length + "/" + line);
                    System.exit(1);
                }
                overrideMap.put(items[2], new GLSymbol(items[3].trim()));
                continue;
            }
            
            // table ends
            if (line.contains("};")) {
                break;
            }
        }
    }

    public void doInclude(Map<String, SymbolElmTbl> map) {
        if (includeSet != null) {
            for (String incElm : includeSet) {

                SymbolElmTbl elmTbl = map.get(incElm);
                if (elmTbl == null) {
                    if (!incElm.endsWith(")")) {
                        incElm = incElm + "(basic)"; // workaround for sun/it include "it"
                        elmTbl = map.get(incElm);
                    }
                }
                if (elmTbl != null) {
                    elmTbl.doInclude(map);
                    addCodeMap(codeMap, elmTbl.getCodeMap(), false);
                } else {
                    System.err.println(" non exist elm = " + incElm);                    
                }
            }
        }
        if (overrideMap != null) {
            codeMap.putAll(overrideMap);
        }
    }
    
    public static void addCodeMap(Map<String, GLSymbol> dstMap, Map<String, GLSymbol> srcMap, boolean override) {
        for (String srcKey : srcMap.keySet()) {
            if (dstMap.containsKey(srcKey)) {
                GLSymbol newSym;
                if (override) {
                    newSym = dstMap.get(srcKey).newSymWithOverride(srcMap.get(srcKey));
                } else {
                    newSym = dstMap.get(srcKey).newSymWithoutOverride(srcMap.get(srcKey));
                }
                dstMap.put(srcKey, newSym);
            } else {
                GLSymbol gls = srcMap.get(srcKey);
                dstMap.put(srcKey, srcMap.get(srcKey));
            }
        }
    }
    
    public Map<String, GLSymbol> getCodeMap() {
        return codeMap;
    }
    
    public String toString() {
        return "# of codes = " + codeMap.size();
    }
    

}
