/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Main.java
 *
 * Created on 2006/07/20, 14:52
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;
import java.io.*;

/**
 *
 * @author naoyuki
 */
public class Main {
    
    private static LONameMapper mapper;
    public static LONameMapper getMapper() {
        return mapper;
    }

    private static String US_LAYOUT = "US/English";
    private static Map<String, GLSymbol> us_map;
    public static Map<String, GLSymbol> getUSMap() {
        return us_map;
    }

    /** Creates a new instance of Main */
    public Main(File dataDir, DataOutput output, Set<String> types, File defFile) {
        try {
            SymbolsReader sr = new SymbolsReader(dataDir);
            Map<String, SymbolElmTbl> symbolMap = sr.getTableMap();
            mapper = new LONameMapper(defFile);
            if (types.isEmpty()) {
                // target is all supported types
                types.addAll(mapper.getSupportedTypes());
            }
            Map<String, Map<String, GLSymbol>> pinfo = new HashMap<String, Map<String, GLSymbol>>();
            for (String name : types) {
                String[] elms = mapper.getElmNames(name);

                Map<String, GLSymbol> buffer = new HashMap<String, GLSymbol>();
                for (String elm : elms) {
                    if (!elm.endsWith(")")) {
                        elm += "(basic)";
                    }
                    SymbolElmTbl elmTbl = symbolMap.get(elm);
                    if (elmTbl != null) {
                        // ignore not exist element
                        elmTbl.doInclude(symbolMap);
                        SymbolElmTbl.addCodeMap(buffer, elmTbl.getCodeMap(), true);
                    }
                }
                pinfo.put(name, buffer);
                if (!name.equals(US_LAYOUT)) {
                    us_map = buffer;
                }
            }
            output.print(pinfo);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        System.out.println("Finished.");
    }
    
    private static String USAGE = "Usage: kldm [-xkbsym <xkb symbol dir> -deffile <kbd layout map file> -xmldata <output data file> -types <interest layout types> -calcview]";
    private static void usage() {
        System.err.println(USAGE);
        System.exit(1);
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        File xkbSymbolDir = null;
        File mapDefFile = null;
        Set<String> layoutTypes = new HashSet<String>();
        DataOutput output = null;
        
        for (int i = 0, len = args.length; i < len; i++) {
            if (args[i].equals("-help")) {
                usage();
            } else if (args[i].equals("-xkbsym")) {
                if (++i < len)  {
                    xkbSymbolDir = new File(args[i]);
                    continue;
                }
                usage();
            } else if (args[i].equals("-deffile"))  {
                if (++i < len) {
                    mapDefFile = new File(args[i]);
                    continue;
                } 
                usage();
            } else if (args[i].equals("-xmldata")) {
                if (++i < len) {
                    output = new XMLOutput(new File(args[i]));
                    continue;
                }
                usage();
            } else if (args[i].equals("-bindata")) {
                if (++i < len) {
                    output = new BinDataOutput(new File(args[i]));
                    continue;
                }
                usage();
            } else if (args[i]. equals("-keysym2char")) {
                if (++i < len) {
                    output = new KeysymToChar(new File(args[i]));
                    continue;
                }
            } else if (args[i].equals("-types")) {
                for (i++; i < len; i++) {
                    if (args[i].startsWith("-")) {
                        i--;
                        break;
                    }
                    layoutTypes.add(args[i]);
                }
            } else if (args[i].equals("-calcview")) {
                try {
                    Class calcOutput = Class.forName("kldhandler.CalcOutput");
                    output = (DataOutput)calcOutput.newInstance();
                } catch(Exception e) {
                    System.err.println(" The classes for Calc output is not installed.");
                }
            } else if (args[i].equals("-testdata")) {
                output = new TestOutput();
            }
        }
        
        if (xkbSymbolDir == null || !xkbSymbolDir.isDirectory()) {
            usage();
        }

        if (output == null) {
            output = new TextOutput();
        }
        
        new Main(xkbSymbolDir, output, layoutTypes, mapDefFile);
    }
    
}
